/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.template.ModelTemplateElemental;
import com.lycanitesmobs.client.renderer.CreatureRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureEffect;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureScrolling;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelWisp
extends ModelTemplateElemental {
    LayerCreatureEffect ballLayer;
    LayerCreatureEffect ballGlowLayer;
    LayerCreatureEffect hairLayer;
    float maxLeg = 0.0f;

    public ModelWisp() {
        this(1.0f);
    }

    public ModelWisp(float shadowSize) {
        this.initModel("wisp", LycanitesMobs.modInfo, "entity/wisp");
        this.trophyScale = 1.2f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
    }

    @Override
    public void addCustomLayers(CreatureRenderer renderer) {
        super.addCustomLayers(renderer);
        this.ballLayer = new LayerCreatureEffect(renderer, "ball", true, LayerCreatureEffect.BLEND.NORMAL.id, true);
        renderer.func_177094_a(this.ballLayer);
        this.ballGlowLayer = new LayerCreatureEffect(renderer, "ball", true, LayerCreatureEffect.BLEND.ADD.id, true);
        renderer.func_177094_a(this.ballGlowLayer);
        this.hairLayer = new LayerCreatureScrolling(renderer, "hair", true, LayerCreatureEffect.BLEND.NORMAL.id, true, new Vector2f(0.0f, 4.0f));
        renderer.func_177094_a(this.hairLayer);
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        if (partName.equals("haircenter")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.1f), 0.0f, 0.0f);
        } else if (partName.equals("hairleft")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.05f)) * 0.1f), (float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.2f - 0.2f), 0.0f);
        } else if (partName.equals("hairright")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.05f)) * 0.1f), -((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.2f - 0.2f)), 0.0f);
        } else if (partName.contains("fringeleft")) {
            this.rotate(-((float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f)), 0.0f, -((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.1f)));
        } else if (partName.contains("fringeright")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f), 0.0f, (float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.1f));
        } else if (partName.equals("armleft")) {
            this.rotate(0.0f, 0.0f, (float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.1f));
        } else if (partName.equals("armright")) {
            this.rotate(0.0f, 0.0f, -((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.1f)));
        }
        if (entity instanceof BaseCreatureEntity && ((BaseCreatureEntity)entity).isAttackOnCooldown()) {
            if (partName.equals("armleft")) {
                this.rotate(0.0f, 25.0f, 25.0f);
            }
            if (partName.equals("armright")) {
                this.rotate(0.0f, -25.0f, -25.0f);
            }
        }
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if (partName.contains("ball") && entity instanceof BaseCreatureEntity && ((BaseCreatureEntity)entity).isAttackOnCooldown()) {
            return false;
        }
        if (partName.equals("ball01")) {
            return layer == this.ballLayer;
        }
        if (partName.equals("ball02") || partName.equals("ball03")) {
            return layer == this.ballGlowLayer;
        }
        if (partName.contains("fringe")) {
            return layer == this.hairLayer;
        }
        if (partName.contains("hair")) {
            return layer == this.hairLayer;
        }
        return layer == null;
    }

    @Override
    public Vector4f getPartColor(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        if (layer == this.ballLayer || layer == this.ballGlowLayer) {
            float glowSpeed = 40.0f;
            float glow = loop * glowSpeed % 360.0f;
            float color = (float)Math.cos(Math.toRadians(glow)) * 0.1f + 0.9f;
            return new Vector4f(color, color, color, 1.0f);
        }
        return super.getPartColor(partName, entity, layer, trophy, loop);
    }

    @Override
    public void onRenderStart(LayerCreatureBase layer, Entity entity, boolean renderAsTrophy) {
        super.onRenderStart(layer, entity, renderAsTrophy);
        GlStateManager.disableLighting();
    }

    @Override
    public void onRenderFinish(LayerCreatureBase layer, Entity entity, boolean renderAsTrophy) {
        super.onRenderFinish(layer, entity, renderAsTrophy);
        GlStateManager.enableLighting();
    }
}

