/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.template.ModelTemplateElemental;
import com.lycanitesmobs.client.renderer.CreatureRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureEffect;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureScrolling;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelSylph
extends ModelTemplateElemental {
    LayerCreatureEffect hoodLayer;
    LayerCreatureEffect wingLayer;

    public ModelSylph() {
        this(1.0f);
    }

    public ModelSylph(float shadowSize) {
        this.initModel("sylph", LycanitesMobs.modInfo, "entity/sylph");
        this.trophyScale = 1.2f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
    }

    @Override
    public void addCustomLayers(CreatureRenderer renderer) {
        super.addCustomLayers(renderer);
        this.hoodLayer = new LayerCreatureEffect(renderer, "hood", false, LayerCreatureEffect.BLEND.NORMAL.id, true);
        renderer.func_177094_a(this.hoodLayer);
        this.wingLayer = new LayerCreatureScrolling(renderer, "wing", true, LayerCreatureEffect.BLEND.ADD.id, true, new Vector2f(0.0f, 1.0f));
        renderer.func_177094_a(this.wingLayer);
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        if (this.currentModelState != null) {
            this.currentModelState.attackAnimationSpeed = 0.08f;
        }
        if (partName.contains("wingleft")) {
            float attackAngle = 30.0f;
            if (partName.equals("wingleft02")) {
                attackAngle = 50.0f;
            } else if (partName.equals("wingleft03")) {
                attackAngle = 45.0f;
            }
            this.rotate(0.0f, 5.0f + (float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.2f)) * 0.4f), 4.0f + (float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.2f)) * 0.08f) + attackAngle * this.getAttackProgress());
        } else if (partName.contains("wingright")) {
            float attackAngle = -30.0f;
            if (partName.equals("wingright02")) {
                attackAngle = -50.0f;
            } else if (partName.equals("wingright03")) {
                attackAngle = -45.0f;
            }
            this.rotate(0.0f, -5.0f + (float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.2f + (float)Math.PI)) * 0.4f), -4.0f + (float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.2f + (float)Math.PI)) * 0.08f) + attackAngle * this.getAttackProgress());
        } else if (partName.contains("finger")) {
            if (partName.contains("thumb")) {
                this.rotate(-((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.2f)) * 0.2f - 0.2f)), 0.0f, 0.0f);
            } else {
                this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.2f)) * 0.2f - 0.2f), 0.0f, 0.0f);
            }
        }
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if (partName.contains("hood")) {
            return layer == this.hoodLayer;
        }
        if (partName.contains("wing")) {
            return layer == this.wingLayer;
        }
        return layer == null;
    }

    @Override
    public Vector4f getPartColor(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        if (layer == null) {
            float glowSpeed = 40.0f;
            float glow = loop * glowSpeed % 360.0f;
            float color = (float)Math.cos(Math.toRadians(glow)) * 0.1f + 0.9f;
            return new Vector4f(color, color, color, 1.0f);
        }
        return super.getPartColor(partName, entity, layer, trophy, loop);
    }

    @Override
    public void onRenderStart(LayerCreatureBase layer, Entity entity, boolean renderAsTrophy) {
        super.onRenderStart(layer, entity, renderAsTrophy);
        if (layer != null) {
            return;
        }
        GlStateManager.disableLighting();
    }

    @Override
    public void onRenderFinish(LayerCreatureBase layer, Entity entity, boolean renderAsTrophy) {
        super.onRenderFinish(layer, entity, renderAsTrophy);
        if (layer != null) {
            return;
        }
        GlStateManager.enableLighting();
    }
}

