/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.ModelCreatureObjOld;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelStrider
extends ModelCreatureObjOld {
    float maxLeg = 0.0f;

    public ModelStrider() {
        this(1.0f);
    }

    public ModelStrider(float shadowSize) {
        this.initModel("strider", LycanitesMobs.modInfo, "entity/strider");
        this.setPartCenter("body", 0.0f, 8.0f, 0.0f);
        this.setPartCenter("armleft", 0.4f, 9.0f, -1.8f);
        this.setPartCenter("armright", -0.4f, 9.0f, -1.8f);
        this.setPartCenter("legleft", 1.4f, 7.8f, 0.0f);
        this.setPartCenter("legright", -1.4f, 7.8f, 0.0f);
        this.setPartCenter("legback", 0.0f, 8.0f, 0.8f);
        this.lockHeadX = true;
        this.lockHeadY = true;
        this.trophyScale = 0.4f;
        this.trophyOffset = new float[]{0.0f, -0.2f, 0.0f};
        this.bodyIsTrophy = true;
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("armleft")) {
            rotZ = (float)((double)rotZ - Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX - Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        if (partName.equals("armright")) {
            rotZ = (float)((double)rotZ + Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        float walkSwing = 0.15f;
        if (partName.equals("legleft")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f + (float)Math.PI)) * walkSwing * (distance / 2.0f)));
        }
        if (partName.equals("legright")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f)) * walkSwing * (distance / 2.0f)));
        }
        if (partName.equals("legback")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f)) * walkSwing * distance));
        }
        if (entity instanceof BaseCreatureEntity && ((BaseCreatureEntity)entity).isAttackOnCooldown()) {
            if (partName.equals("armleft")) {
                this.rotate(-25.0f, 0.0f, 0.0f);
            }
            if (partName.equals("armright")) {
                this.rotate(-25.0f, 0.0f, 0.0f);
            }
        }
        if (entity instanceof BaseCreatureEntity && ((BaseCreatureEntity)entity).hasPickupEntity() && (partName.equals("armleft") || partName.equals("armright"))) {
            rotX = (float)((double)rotX + 20.0);
        }
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }
}

