/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.ModelCreatureObjOld;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelConcapedeHead
extends ModelCreatureObjOld {
    float maxLeg = 0.0f;

    public ModelConcapedeHead() {
        this(1.0f);
    }

    public ModelConcapedeHead(float shadowSize) {
        this.initModel("Concapede", LycanitesMobs.modInfo, "entity/concapedehead");
        this.setPartCenter("head", 0.0f, 0.5f, 0.6f);
        this.setPartCenter("leftmouth", 0.2f, 0.4f, 1.0f);
        this.setPartCenter("rightmouth", -0.2f, 0.4f, 1.0f);
        this.setPartCenter("body", 0.0f, 0.5f, 0.6f);
        this.setPartCenter("frontleftleg", 0.6f, 0.6f, 0.15f);
        this.setPartCenter("backleftleg", 0.6f, 0.6f, -0.15f);
        this.setPartCenter("frontrightleg", -0.6f, 0.6f, 0.15f);
        this.setPartCenter("backrightleg", -0.6f, 0.6f, -0.15f);
        this.lockHeadX = true;
        this.lockHeadY = true;
        this.trophyScale = 1.0f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("leftmouth") || partName.equals("rightmouth")) {
            if (partName.equals("leftmouth")) {
                this.centerPartToPart("leftmouth", "head");
            }
            if (partName.equals("rightmouth")) {
                this.centerPartToPart("rightmouth", "head");
            }
            if (!this.lockHeadX) {
                rotX = (float)((double)rotX + Math.toDegrees(lookX / 57.295776f));
            }
            if (!this.lockHeadY) {
                rotY = (float)((double)rotY + Math.toDegrees(lookY / 57.295776f));
            }
            if (partName.equals("leftmouth")) {
                this.uncenterPartToPart("leftmouth", "head");
            }
            if (partName.equals("rightmouth")) {
                this.uncenterPartToPart("rightmouth", "head");
            }
        }
        if (partName.equals("leftmouth")) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f + (float)Math.PI)) * 0.05f - 0.05f)), 0.0f, 0.0f);
        }
        if (partName.equals("rightmouth")) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f)), 0.0f, 0.0f);
        }
        if (partName.equals("frontleftleg") || partName.equals("backleftleg") || partName.equals("frontrightleg") || partName.equals("backrightleg")) {
            angleZ = 1.0f;
        }
        if (partName.equals("frontleftleg")) {
            angleY = 0.027777778f;
        }
        if (partName.equals("backleftleg")) {
            angleY = -0.027777778f;
        }
        if (partName.equals("frontrightleg")) {
            angleY = -0.027777778f;
        }
        if (partName.equals("backrightleg")) {
            angleY = 0.027777778f;
        }
        float walkSwing = 0.6f;
        if (partName.equals("frontrightleg") || partName.equals("backleftleg")) {
            rotation = (float)((double)rotation + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f + (float)Math.PI)) * walkSwing * distance));
        }
        if (partName.equals("frontleftleg") || partName.equals("backrightleg")) {
            rotation = (float)((double)rotation + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f)) * walkSwing * distance));
        }
        if (entity instanceof BaseCreatureEntity && ((BaseCreatureEntity)entity).isAttackOnCooldown() && (partName.equals("leftmouth") || partName.equals("rightmouth"))) {
            rotX += 20.0f;
        }
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }
}

