/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.Animator;
import com.lycanitesmobs.client.model.IAnimationModel;
import com.lycanitesmobs.client.model.ModelAnimation;
import com.lycanitesmobs.client.model.ModelObjAnimationFrame;
import com.lycanitesmobs.client.model.ModelObjPart;
import com.lycanitesmobs.client.model.ModelObjState;
import com.lycanitesmobs.client.model.ModelProjectileBase;
import com.lycanitesmobs.client.obj.ObjObject;
import com.lycanitesmobs.client.obj.TessellatorModel;
import com.lycanitesmobs.client.renderer.RenderProjectileModel;
import com.lycanitesmobs.client.renderer.layer.LayerProjectileBase;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;

@OnlyIn(value=Dist.CLIENT)
public class ModelProjectileObj
extends ModelProjectileBase
implements IAnimationModel {
    public static float modelXRotOffset = 180.0f;
    public static float modelYPosOffset = -1.5f;
    public TessellatorModel wavefrontObject;
    public List<ObjObject> wavefrontParts;
    public Map<String, ModelObjPart> animationParts = new HashMap<String, ModelObjPart>();
    public boolean dontColor = false;
    protected Animator animator;
    protected ModelObjPart currentAnimationPart;
    protected ModelAnimation animation;
    protected Map<Entity, ModelObjState> modelStates = new HashMap<Entity, ModelObjState>();
    protected ModelObjState currentModelState;

    public ModelProjectileObj() {
        this(1.0f);
    }

    public ModelProjectileObj(float shadowSize) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelProjectileObj initModel(String name, ModInfo groupInfo, String path) {
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(name);
        if (projectileInfo != null && !projectileInfo.enabled) {
            return this;
        }
        this.wavefrontObject = new TessellatorModel(new ResourceLocation(groupInfo.modid, "models/" + path + ".obj"));
        this.wavefrontParts = this.wavefrontObject.objObjects;
        if (this.wavefrontParts.isEmpty()) {
            LycanitesMobs.logWarning("", "Unable to load any parts for the " + name + " model!");
        }
        this.animator = new Animator();
        ResourceLocation modelPartsLocation = new ResourceLocation(groupInfo.modid, "models/" + path + "_parts.json");
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            InputStream in = Minecraft.func_71410_x().func_195551_G().func_199002_a(modelPartsLocation).func_199027_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                JsonArray jsonArray = (JsonArray)JSONUtils.func_188173_a((Gson)gson, (Reader)reader, JsonArray.class, (boolean)false);
                Iterator jsonIterator = jsonArray.iterator();
                while (jsonIterator.hasNext()) {
                    JsonObject partJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                    ModelObjPart animationPart = new ModelObjPart();
                    animationPart.loadFromJson(partJson);
                    this.addAnimationPart(animationPart);
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "There was a problem loading animation parts for " + name + ":");
            e.toString();
        }
        for (ModelObjPart part : this.animationParts.values()) {
            part.addChildren(this.animationParts.values().toArray(new ModelObjPart[this.animationParts.size()]));
        }
        ResourceLocation animationLocation = new ResourceLocation(groupInfo.modid, "models/" + path + "_animation.json");
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            InputStream in = Minecraft.func_71410_x().func_195551_G().func_199002_a(animationLocation).func_199027_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                JsonObject json = (JsonObject)JSONUtils.func_188173_a((Gson)gson, (Reader)reader, JsonObject.class, (boolean)false);
                this.animation = new ModelAnimation();
                this.animation.loadFromJson(json);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("Models", "Unable to load animation json for " + name + ".");
        }
        return this;
    }

    public void addAnimationPart(ModelObjPart animationPart) {
        if (this.animationParts.containsKey(animationPart.name)) {
            LycanitesMobs.logWarning("", "Tried to add an animation part that already exists: " + animationPart.name + ".");
            return;
        }
        if (animationPart.parentName != null && animationPart.parentName.equals(animationPart.name)) {
            animationPart.parentName = null;
        }
        this.animationParts.put(animationPart.name, animationPart);
    }

    @Override
    public void addCustomLayers(RenderProjectileModel renderer) {
        super.addCustomLayers(renderer);
        if (this.animation != null) {
            this.animation.addProjectileLayers(renderer);
        }
    }

    @Override
    public void render(BaseProjectileEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale, LayerProjectileBase layer, boolean animate) {
        boolean renderAsTrophy = false;
        if (scale < 0.0f) {
            renderAsTrophy = true;
            scale = -scale;
        } else if (entity != null) {
            scale *= 4.0f;
            scale *= entity.getProjectileScale();
        }
        this.currentModelState = this.getModelState(entity);
        if (animate) {
            this.generateAnimationFrames(entity, time, distance, loop, lookY, lookX, scale);
        }
        for (ObjObject part : this.wavefrontParts) {
            String partName = part.getName().toLowerCase();
            if (!this.canRenderPart(partName, entity, layer, renderAsTrophy)) continue;
            this.currentAnimationPart = this.animationParts.get(partName);
            if (this.currentAnimationPart == null) continue;
            GlStateManager.pushMatrix();
            this.animator.doAngle(modelXRotOffset, 1.0f, 0.0f, 0.0f);
            this.animator.doTranslate(0.0f, modelYPosOffset, 0.0f);
            this.animator.doScale(scale, scale, scale);
            this.currentAnimationPart.applyAnimationFrames(this.animator);
            this.onRenderStart(layer, entity);
            this.wavefrontObject.renderGroup(part, this.getPartColor(partName, entity, layer, renderAsTrophy, loop), this.getPartTextureOffset(partName, entity, layer, renderAsTrophy, loop));
            this.onRenderFinish(layer, entity);
            GlStateManager.popMatrix();
        }
        if (animate) {
            this.clearAnimationFrames();
        }
    }

    public void onRenderStart(LayerProjectileBase layer, BaseProjectileEntity entity) {
        if (!CreatureManager.getInstance().config.disableModelAlpha) {
            GlStateManager.enableBlend();
        }
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (layer != null) {
            layer.onRenderStart((Entity)entity);
        }
    }

    public void onRenderFinish(LayerProjectileBase layer, BaseProjectileEntity entity) {
        if (!CreatureManager.getInstance().config.disableModelAlpha) {
            GlStateManager.disableBlend();
        }
        if (layer != null) {
            layer.onRenderFinish((Entity)entity);
        }
    }

    public void generateAnimationFrames(BaseProjectileEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        for (ObjObject part : this.wavefrontParts) {
            String partName = part.getName().toLowerCase();
            this.currentAnimationPart = this.animationParts.get(partName);
            if (this.currentAnimationPart == null) continue;
            this.animatePart(partName, entity, time, distance, loop, -lookY, lookX, scale);
        }
    }

    public void clearAnimationFrames() {
        for (ModelObjPart animationPart : this.animationParts.values()) {
            animationPart.animationFrames.clear();
        }
    }

    @Override
    public boolean canRenderPart(String partName, BaseProjectileEntity entity, LayerProjectileBase layer, boolean trophy) {
        if (partName == null) {
            return false;
        }
        if (!this.animationParts.containsKey(partName = partName.toLowerCase())) {
            return false;
        }
        return super.canRenderPart(partName, entity, layer, trophy);
    }

    public void animatePart(String partName, BaseProjectileEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        this.rotate(rotX, rotY, rotZ);
    }

    public ModelObjState getModelState(BaseProjectileEntity entity) {
        if (entity == null) {
            return null;
        }
        if (this.modelStates.containsKey((Object)entity)) {
            if (!entity.func_70089_S()) {
                this.modelStates.remove((Object)entity);
                return null;
            }
            return this.modelStates.get((Object)entity);
        }
        ModelObjState modelState = new ModelObjState((Entity)entity);
        this.modelStates.put((Entity)entity, modelState);
        return modelState;
    }

    @Override
    public void angle(float rotation, float angleX, float angleY, float angleZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("angle", rotation, angleX, angleY, angleZ));
    }

    @Override
    public void rotate(float rotX, float rotY, float rotZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("rotate", 1.0f, rotX, rotY, rotZ));
    }

    @Override
    public void translate(float posX, float posY, float posZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("translate", 1.0f, posX, posY, posZ));
    }

    @Override
    public void scale(float scaleX, float scaleY, float scaleZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("scale", 1.0f, scaleX, scaleY, scaleZ));
    }

    @Override
    public double rotateToPoint(double aTarget, double bTarget) {
        return this.rotateToPoint(0.0, 0.0, aTarget, bTarget);
    }

    @Override
    public double rotateToPoint(double aCenter, double bCenter, double aTarget, double bTarget) {
        if (aTarget - aCenter == 0.0) {
            if (aTarget > aCenter) {
                return 0.0;
            }
            if (aTarget < aCenter) {
                return 180.0;
            }
        }
        if (bTarget - bCenter == 0.0) {
            if (bTarget > bCenter) {
                return 90.0;
            }
            if (bTarget < bCenter) {
                return -90.0;
            }
        }
        if (aTarget - aCenter == 0.0 && bTarget - bCenter == 0.0) {
            return 0.0;
        }
        return Math.toDegrees(Math.atan2(aCenter - aTarget, bCenter - bTarget) - 1.5707963267948966);
    }

    @Override
    public double[] rotateToPoint(double xCenter, double yCenter, double zCenter, double xTarget, double yTarget, double zTarget) {
        double[] rotations = new double[]{this.rotateToPoint(yCenter, -zCenter, yTarget, -zTarget), this.rotateToPoint(-zCenter, xCenter, -zTarget, xTarget), this.rotateToPoint(yCenter, xCenter, yTarget, xTarget)};
        return rotations;
    }

    public void shiftOrigin(String fromPartName, String toPartName) {
        ModelObjPart fromPart = this.animationParts.get(fromPartName);
        ModelObjPart toPart = this.animationParts.get(toPartName);
        float offsetX = toPart.centerX - fromPart.centerX;
        float offsetY = toPart.centerY - fromPart.centerY;
        float offsetZ = toPart.centerZ - fromPart.centerZ;
        this.translate(offsetX, offsetY, offsetZ);
    }

    public void shiftOriginBack(String fromPartName, String toPartName) {
        ModelObjPart fromPart = this.animationParts.get(fromPartName);
        ModelObjPart toPart = this.animationParts.get(toPartName);
        float offsetX = toPart.centerX - fromPart.centerX;
        float offsetY = toPart.centerY - fromPart.centerY;
        float offsetZ = toPart.centerZ - fromPart.centerZ;
        this.translate(-offsetX, -offsetY, -offsetZ);
    }
}

