/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model;

import com.lycanitesmobs.client.renderer.RenderProjectileModel;
import com.lycanitesmobs.client.renderer.layer.LayerProjectileBase;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class ModelProjectileBase
extends EntityModel<BaseProjectileEntity> {
    public ModelProjectileBase() {
        this(1.0f);
    }

    public ModelProjectileBase(float shadowSize) {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
    }

    public void addCustomLayers(RenderProjectileModel renderer) {
    }

    public void func_78088_a(BaseProjectileEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        this.render(entity, time, distance, loop, lookY, lookX, scale, null, true);
    }

    public void render(BaseProjectileEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale, LayerProjectileBase layer, boolean animate) {
        float sizeScale = 1.0f;
        if (entity != null) {
            sizeScale *= entity.getProjectileScale();
        }
        GL11.glScalef((float)sizeScale, (float)sizeScale, (float)sizeScale);
        GL11.glTranslatef((float)0.0f, (float)(0.5f - sizeScale / 2.0f), (float)0.0f);
    }

    public boolean canRenderPart(String partName, BaseProjectileEntity entity, LayerProjectileBase layer, boolean trophy) {
        if (layer == null) {
            return this.canBaseRenderPart(partName, entity, trophy);
        }
        if (entity != null) {
            return layer.canRenderPart(partName, entity, trophy);
        }
        return false;
    }

    public boolean canBaseRenderPart(String partName, BaseProjectileEntity entity, boolean trophy) {
        return true;
    }

    public Vector4f getPartColor(String partName, BaseProjectileEntity entity, LayerProjectileBase layer, boolean trophy, float loop) {
        if (layer == null || entity == null) {
            return this.getBasePartColor(partName, entity, trophy, loop);
        }
        return layer.getPartColor(partName, entity, trophy);
    }

    public Vector4f getBasePartColor(String partName, BaseProjectileEntity entity, boolean trophy, float loop) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Vector2f getPartTextureOffset(String partName, BaseProjectileEntity entity, LayerProjectileBase layer, boolean trophy, float loop) {
        if (layer == null || !(entity instanceof BaseProjectileEntity)) {
            return this.getBaseTextureOffset(partName, entity, trophy, loop);
        }
        return layer.getTextureOffset(partName, entity, trophy, loop);
    }

    public Vector2f getBaseTextureOffset(String partName, BaseProjectileEntity entity, boolean trophy, float loop) {
        return new Vector2f(0.0f, 0.0f);
    }
}

