/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model;

import com.lycanitesmobs.client.renderer.CreatureRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureSaddle;
import com.lycanitesmobs.client.renderer.layer.LayerEquipment;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class ModelCreatureBase
extends EntityModel<BaseCreatureEntity> {
    public ModelCreatureBase() {
        this(1.0f);
    }

    public ModelCreatureBase(float shadowSize) {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
    }

    public void addCustomLayers(CreatureRenderer renderer) {
        renderer.func_177094_a(new LayerEquipment(renderer, "chest"));
        renderer.func_177094_a(new LayerCreatureSaddle(renderer));
    }

    public void func_78088_a(BaseCreatureEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        this.render(entity, time, distance, loop, lookY, lookX, scale, null, true);
    }

    public void render(BaseCreatureEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale, LayerCreatureBase layer, boolean animate) {
        float sizeScale = 1.0f;
        if (entity != null) {
            sizeScale *= entity.func_213355_cm();
        }
        GL11.glScalef((float)sizeScale, (float)sizeScale, (float)sizeScale);
        GL11.glTranslatef((float)0.0f, (float)(0.5f - sizeScale / 2.0f), (float)0.0f);
    }

    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if (layer == null) {
            return this.canBaseRenderPart(partName, entity, trophy);
        }
        if (entity instanceof BaseCreatureEntity) {
            return layer.canRenderPart(partName, (BaseCreatureEntity)entity, trophy);
        }
        return false;
    }

    public boolean canBaseRenderPart(String partName, Entity entity, boolean trophy) {
        return true;
    }

    public Vector4f getPartColor(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        if (layer == null || !(entity instanceof BaseCreatureEntity)) {
            return this.getBasePartColor(partName, entity, trophy, loop);
        }
        return layer.getPartColor(partName, (BaseCreatureEntity)entity, trophy);
    }

    public Vector4f getBasePartColor(String partName, Entity entity, boolean trophy, float loop) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Vector2f getPartTextureOffset(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        if (layer == null || !(entity instanceof BaseCreatureEntity)) {
            return this.getBaseTextureOffset(partName, entity, trophy, loop);
        }
        return layer.getTextureOffset(partName, (BaseCreatureEntity)entity, trophy, loop);
    }

    public Vector2f getBaseTextureOffset(String partName, Entity entity, boolean trophy, float loop) {
        return new Vector2f(0.0f, 0.0f);
    }
}

