/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary.lists;

import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.client.gui.widgets.BaseList;
import com.lycanitesmobs.client.gui.widgets.BaseListEntry;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.Subspecies;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.gui.widget.list.AbstractList;

public class SubspeciesList
extends BaseList<BeastiaryScreen> {
    private CreatureInfo creature;
    private boolean summoning;

    public SubspeciesList(BeastiaryScreen screen, boolean summoning, int width, int height, int top, int bottom, int x) {
        super(screen, width, height, top, bottom, x, 24);
        this.summoning = summoning;
        this.refreshList();
    }

    public void refreshList() {
        this.replaceEntries(new ArrayList());
        this.creature = !this.summoning ? ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedCreature : ((BeastiaryScreen)((Object)this.screen)).playerExt.getSelectedSummonSet().getCreatureInfo();
        if (this.creature == null) {
            return;
        }
        int index = 1;
        this.addEntry((AbstractList.AbstractListEntry)new Entry(this, index++, 0));
        for (int subspeciesIndex : this.creature.subspecies.keySet()) {
            Subspecies subspecies;
            if (!((BeastiaryScreen)((Object)this.screen)).playerExt.getBeastiary().hasKnowledgeRank(this.creature.getName(), 2) || (subspecies = this.creature.subspecies.get(subspeciesIndex)) != null && "rare".equals(subspecies.rarity)) continue;
            this.addEntry((AbstractList.AbstractListEntry)new Entry(this, index++, subspeciesIndex));
        }
    }

    public void setSelected(@Nullable BaseListEntry entry) {
        super.setSelected((AbstractList.AbstractListEntry)entry);
        if (!this.summoning && entry instanceof Entry) {
            ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedSubspecies = ((Entry)entry).subspeciesIndex;
        } else {
            ((BeastiaryScreen)((Object)this.screen)).playerExt.getSelectedSummonSet().setSubspecies(this.getSelectedIndex());
            ((BeastiaryScreen)((Object)this.screen)).playerExt.sendSummonSetToServer((byte)((BeastiaryScreen)((Object)this.screen)).playerExt.selectedSummonSet);
        }
    }

    protected boolean isSelectedItem(int index) {
        if (!(this.getEntry(index) instanceof Entry)) {
            return false;
        }
        if (!this.summoning) {
            return ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedSubspecies == ((Entry)this.getEntry((int)index)).subspeciesIndex;
        }
        return ((BeastiaryScreen)((Object)this.screen)).playerExt.getSelectedSummonSet().getSubspecies() == index;
    }

    protected void renderBackground() {
        if (!this.summoning) {
            if (this.creature != ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedCreature) {
                this.refreshList();
            }
        } else if (this.creature != ((BeastiaryScreen)((Object)this.screen)).playerExt.getSelectedSummonSet().getCreatureInfo()) {
            this.refreshList();
        }
    }

    public static class Entry
    extends BaseListEntry {
        private SubspeciesList parentList;
        public int subspeciesIndex;

        public Entry(SubspeciesList parentList, int index, int subspeciesIndex) {
            this.parentList = parentList;
            this.index = index;
            this.subspeciesIndex = subspeciesIndex;
        }

        @Override
        public void render(int index, int top, int left, int bottom, int right, int mouseX, int mouseY, boolean focus, float partialTicks) {
            Subspecies subspecies = this.parentList.creature.getSubspecies(this.subspeciesIndex);
            int nameY = top + 6;
            if (subspecies == null) {
                ((BeastiaryScreen)((Object)this.parentList.screen)).getFontRenderer().func_211126_b("Normal", (float)(left + 20), (float)nameY, 0xFFFFFF);
                return;
            }
            ((BeastiaryScreen)((Object)this.parentList.screen)).getFontRenderer().func_211126_b(subspecies.getTitle().func_150254_d(), (float)(left + 20), (float)nameY, 0xFFFFFF);
        }

        @Override
        protected void onClicked() {
            this.parentList.setSelected(this);
        }
    }
}

