/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary.lists;

import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureFilterList;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureList;
import com.lycanitesmobs.client.gui.widgets.BaseListEntry;
import com.lycanitesmobs.core.info.CreatureInfo;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.util.text.TranslationTextComponent;

public class PetTypeList
extends CreatureFilterList {
    public PetTypeList(BeastiaryScreen parentGui, int width, int height, int top, int bottom, int x) {
        super(parentGui, width, height, top, bottom, x, 24);
        this.refreshList();
    }

    @Override
    public void refreshList() {
        this.replaceEntries(new ArrayList());
        int index = 0;
        this.addEntry((AbstractList.AbstractListEntry)new Entry(this, index++, "gui.beastiary.pets"));
        this.addEntry((AbstractList.AbstractListEntry)new Entry(this, index++, "gui.beastiary.mounts"));
        this.addEntry((AbstractList.AbstractListEntry)new Entry(this, index++, "gui.beastiary.familiars"));
    }

    @Override
    public void setSelected(@Nullable BaseListEntry entry) {
        super.setSelected(entry);
        ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedPetType = this.getSelectedIndex();
        for (CreatureList creatureList : this.filteredLists) {
            if (creatureList == null) continue;
            this.updateCreatureListType(creatureList);
        }
    }

    protected boolean isSelectedItem(int index) {
        return ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedPetType == index;
    }

    public void updateCreatureListType(CreatureList creatureList) {
        int index = this.getSelectedIndex();
        CreatureList.Type listType = null;
        if (index == 0) {
            listType = CreatureList.Type.PET;
        } else if (index == 1) {
            listType = CreatureList.Type.MOUNT;
        } else if (index == 2) {
            listType = CreatureList.Type.FAMILIAR;
        }
        creatureList.changeType(listType);
    }

    @Override
    public void addFilteredList(CreatureList creatureList) {
        super.addFilteredList(creatureList);
        this.updateCreatureListType(creatureList);
    }

    @Override
    public boolean canListCreature(CreatureInfo creatureInfo, CreatureList.Type listType) {
        int index = this.getSelectedIndex();
        if (creatureInfo == null || listType == null) {
            return false;
        }
        if (index == 0 && listType == CreatureList.Type.PET) {
            return true;
        }
        if (index == 1 && listType == CreatureList.Type.MOUNT) {
            return true;
        }
        return index == 2 && listType == CreatureList.Type.FAMILIAR;
    }

    @Override
    public void renderSlot(int index, int top, int left, int bottom, int right) {
    }

    public static class Entry
    extends CreatureFilterList.Entry {
        public String petTypeKey;

        public Entry(CreatureFilterList parentList, int index, String petTypeKey) {
            super(parentList, index);
            this.petTypeKey = petTypeKey;
        }

        @Override
        public void render(int index, int top, int left, int bottom, int right, int mouseX, int mouseY, boolean focus, float partialTicks) {
            ((BeastiaryScreen)((Object)this.parentList.screen)).getFontRenderer().func_211126_b(new TranslationTextComponent(this.petTypeKey, new Object[0]).func_150254_d(), (float)(left + 2), (float)(top + 4), 0xFFFFFF);
        }
    }
}

