/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary.lists;

import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureFilterList;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureList;
import com.lycanitesmobs.client.gui.widgets.BaseListEntry;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.CreatureType;
import java.util.ArrayList;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.client.gui.widget.list.AbstractList;

public class CreatureTypeList
extends CreatureFilterList {
    public CreatureTypeList(BeastiaryScreen parentGui, int width, int height, int top, int bottom, int x) {
        super(parentGui, width, height, top, bottom, x, 16);
        this.refreshList();
    }

    @Override
    public void refreshList() {
        this.replaceEntries(new ArrayList());
        int typeIndex = 0;
        ArrayList<CreatureType> creatureTypes = new ArrayList<CreatureType>();
        creatureTypes.addAll(CreatureManager.getInstance().creatureTypes.values());
        creatureTypes.sort(Comparator.comparing(CreatureType::getName));
        for (CreatureType creatureType : creatureTypes) {
            if (((BeastiaryScreen)((Object)this.screen)).playerExt.beastiary.getCreaturesDescovered(creatureType) <= 0) continue;
            this.addEntry((AbstractList.AbstractListEntry)new Entry(this, typeIndex++, creatureType));
        }
    }

    @Override
    public void setSelected(@Nullable BaseListEntry entry) {
        if (entry instanceof Entry) {
            ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedCreatureType = ((Entry)entry).creatureType;
            ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedCreature = null;
        }
        super.setSelected(entry);
    }

    protected boolean isSelectedItem(int index) {
        if (!(this.getEntry(index) instanceof Entry)) {
            return false;
        }
        return ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedCreatureType != null && ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedCreatureType.equals(((Entry)this.getEntry((int)index)).creatureType);
    }

    @Override
    public boolean canListCreature(CreatureInfo creatureInfo, CreatureList.Type listType) {
        if (((BeastiaryScreen)((Object)this.screen)).playerExt.selectedCreatureType == null || creatureInfo == null) {
            return false;
        }
        return creatureInfo.creatureType == ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedCreatureType;
    }

    public static class Entry
    extends CreatureFilterList.Entry {
        public CreatureType creatureType;

        public Entry(CreatureFilterList parentList, int index, CreatureType creatureType) {
            super(parentList, index);
            this.creatureType = creatureType;
        }

        @Override
        public void render(int index, int top, int left, int bottom, int right, int mouseX, int mouseY, boolean focus, float partialTicks) {
            ((BeastiaryScreen)((Object)this.parentList.screen)).getFontRenderer().func_211126_b(this.creatureType.getTitle().func_150254_d(), (float)(left + 4), (float)(top + 2), 0xFFFFFF);
        }
    }
}

