/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary.lists;

import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.client.gui.widgets.BaseList;
import com.lycanitesmobs.client.gui.widgets.BaseListEntry;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CreatureDescriptionList
extends BaseList {
    public CreatureKnowledge creatureKnowledge;

    public CreatureDescriptionList(BeastiaryScreen parentGui, int width, int height, int top, int bottom, int x) {
        super(parentGui, width, height, top, bottom, x, 500);
    }

    @Override
    public void createEntries() {
        this.addEntry((AbstractList.AbstractListEntry)new Entry(this));
    }

    public String getContent() {
        if (this.creatureKnowledge == null) {
            return "";
        }
        CreatureInfo creatureInfo = this.creatureKnowledge.getCreatureInfo();
        if (creatureInfo == null) {
            return "";
        }
        StringTextComponent text = new StringTextComponent("");
        if (creatureInfo.creatureType != null && creatureInfo.isTameable() && creatureInfo.creatureType.getTreatItem() != null) {
            text.func_150258_a("\u00a7l").func_150257_a((ITextComponent)new TranslationTextComponent("gui.beastiary.tameable", new Object[0])).func_150258_a(": \u00a7r").func_150257_a(creatureInfo.creatureType.getTreatItem().func_200296_o()).func_150258_a("\n\n");
        }
        if (creatureInfo.creatureType != null && creatureInfo.isSummonable() && creatureInfo.creatureType.getTreatItem() != null) {
            text.func_150258_a("\u00a7l").func_150257_a((ITextComponent)new TranslationTextComponent("gui.beastiary.summonable", new Object[0])).func_150258_a("\u00a7r\n\n");
        }
        text.func_150258_a("\u00a7l").func_150257_a((ITextComponent)new TranslationTextComponent("gui.beastiary.summary", new Object[0])).func_150258_a(": \u00a7r").func_150258_a("\n").func_150257_a(creatureInfo.getDescription());
        text.func_150258_a("\n\n\u00a7l").func_150257_a((ITextComponent)new TranslationTextComponent("creature.stat.base", new Object[0])).func_150258_a(": \u00a7r");
        if (this.creatureKnowledge.rank >= 2) {
            String statPrefix = "\n" + new TranslationTextComponent("creature.stat.base", new Object[0]) + " ";
            text.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("creature.stat.health", new Object[0])).func_150258_a(": " + creatureInfo.health);
            text.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("creature.stat.defense", new Object[0])).func_150258_a(": " + creatureInfo.defense);
            text.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("creature.stat.speed", new Object[0])).func_150258_a(": " + creatureInfo.speed);
            text.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("creature.stat.damage", new Object[0])).func_150258_a(": " + creatureInfo.damage);
            text.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("creature.stat.pierce", new Object[0])).func_150258_a(": " + creatureInfo.pierce);
            StringTextComponent effectText = new StringTextComponent(creatureInfo.effectDuration + "s " + creatureInfo.effectAmplifier + "X");
            if (creatureInfo.effectDuration <= 0.0 || creatureInfo.effectAmplifier < 0.0) {
                effectText = new TranslationTextComponent("common.none", new Object[0]);
            }
            text.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("creature.stat.effect", new Object[0])).func_150258_a(": ").func_150257_a((ITextComponent)effectText);
        } else {
            text.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("gui.beastiary.unlockedat", new Object[0])).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("creature.stat.knowledge", new Object[0])).func_150258_a(" 2");
        }
        text.func_150258_a("\n\n\u00a7l").func_150257_a((ITextComponent)new TranslationTextComponent("gui.beastiary.combat", new Object[0])).func_150258_a(": \u00a7r");
        if (this.creatureKnowledge.rank >= 2) {
            text.func_150258_a("\n").func_150257_a(creatureInfo.getCombatDescription());
        } else {
            text.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("gui.beastiary.unlockedat", new Object[0])).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("creature.stat.knowledge", new Object[0])).func_150258_a(" 2");
        }
        text.func_150258_a("\n\n\u00a7l").func_150257_a((ITextComponent)new TranslationTextComponent("gui.beastiary.habitat", new Object[0])).func_150258_a(": \u00a7r");
        if (this.creatureKnowledge.rank >= 2) {
            text.func_150258_a("\n").func_150257_a(creatureInfo.getHabitatDescription());
        } else {
            text.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("gui.beastiary.unlockedat", new Object[0])).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("creature.stat.knowledge", new Object[0])).func_150258_a(" 2");
        }
        return text.func_150254_d();
    }

    public static class Entry
    extends BaseListEntry {
        private CreatureDescriptionList parentList;

        public Entry(CreatureDescriptionList parentList) {
            this.parentList = parentList;
        }

        @Override
        public void render(int index, int top, int left, int bottom, int right, int mouseX, int mouseY, boolean focus, float partialTicks) {
            if (index == 0) {
                this.drawSplitString(this.parentList.getContent(), left + 6, top, this.parentList.getWidth() - 20, 0xFFFFFF, true);
            }
        }

        @Override
        protected void onClicked() {
        }
    }
}

