/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureList;
import com.lycanitesmobs.client.gui.beastiary.lists.SubspeciesList;
import com.lycanitesmobs.client.gui.buttons.ButtonBase;
import com.lycanitesmobs.client.gui.buttons.CreatureButton;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.network.MessageSummonSetSelection;
import com.lycanitesmobs.core.pets.SummonSet;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SummoningBeastiaryScreen
extends BeastiaryScreen {
    public CreatureList petList;
    public SubspeciesList subspeciesList;
    private int summoningSlotIdStart = 200;
    private int petCommandIdStart = 300;

    public SummoningBeastiaryScreen(PlayerEntity player) {
        super(player);
    }

    @Override
    public void initWidgets() {
        super.initWidgets();
        int petListHeight = this.colLeftHeight;
        int petListY = this.colLeftY;
        this.petList = new CreatureList(CreatureList.Type.SUMMONABLE, this, null, this.colLeftWidth, petListHeight, petListY, petListY + petListHeight, this.colLeftX);
        this.children.add(this.petList);
        int subspeciesListHeight = 80;
        int subspeciesListY = this.colRightY + 70;
        this.subspeciesList = new SubspeciesList(this, true, 90, subspeciesListHeight, subspeciesListY, subspeciesListY + subspeciesListHeight, this.colRightX);
        this.children.add(this.subspeciesList);
        int summoningSlots = this.playerExt.summonSetMax;
        int buttonSpacing = 2;
        int buttonWidth = 32;
        int buttonHeight = 32;
        int buttonX = this.colRightX + Math.round((float)this.colRightWidth / 2.0f) - Math.round((float)(buttonWidth + buttonSpacing) * ((float)summoningSlots / 2.0f));
        int buttonY = this.colRightY + 10;
        int tabSpacing = buttonSpacing;
        for (int i = 1; i <= summoningSlots; ++i) {
            String buttonText = String.valueOf(i);
            CreatureInfo creatureInfo = this.playerExt.getSummonSet(i).getCreatureInfo();
            CreatureButton tabButton = new CreatureButton(this.summoningSlotIdStart + i, buttonX += tabSpacing, buttonY, buttonWidth, buttonHeight, buttonText, creatureInfo, this);
            this.addButton((Widget)tabButton);
            if (i == this.playerExt.selectedSummonSet) {
                tabButton.active = false;
            }
            tabSpacing = buttonWidth + buttonSpacing;
        }
        int buttonMarginX = 10 + Math.max(Math.max(this.getFontRenderer().func_78256_a(new TranslationTextComponent("gui.pet.actions", new Object[0]).func_150254_d()), this.getFontRenderer().func_78256_a(new TranslationTextComponent("gui.pet.stance", new Object[0]).func_150254_d())), this.getFontRenderer().func_78256_a(new TranslationTextComponent("gui.pet.movement", new Object[0]).func_150254_d()));
        buttonWidth = 80;
        buttonHeight = 20;
        buttonX = this.colRightX + buttonMarginX;
        buttonY = this.colRightY + this.colRightHeight - (buttonHeight + buttonSpacing) * 3;
        ButtonBase button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.PVP.id + this.petCommandIdStart, buttonX, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.pvp", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        buttonX = this.colRightX + buttonMarginX;
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.PASSIVE.id + this.petCommandIdStart, buttonX, buttonY += buttonHeight + 2, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.passive", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.DEFENSIVE.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.defensive", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.ASSIST.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.assist", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.AGGRESSIVE.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.aggressive", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        buttonX = this.colRightX + buttonMarginX;
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.FOLLOW.id + this.petCommandIdStart, buttonX, buttonY += buttonHeight + 2, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.follow", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.WANDER.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.wander", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.SIT.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.sit", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
    }

    @Override
    public void renderBackground(int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderWidgets(int mouseX, int mouseY, float partialTicks) {
        super.renderWidgets(mouseX, mouseY, partialTicks);
        if (this.playerExt.beastiary.getSummonableList().isEmpty()) {
            return;
        }
        this.petList.render(mouseX, mouseY, partialTicks);
        this.subspeciesList.render(mouseX, mouseY, partialTicks);
        for (Widget buttonWidget : this.buttons) {
            if (!(buttonWidget instanceof ButtonBase)) continue;
            ButtonBase button = (ButtonBase)buttonWidget;
            if (button.buttonId >= this.summoningSlotIdStart && button.buttonId < this.petCommandIdStart) {
                boolean bl = button.active = button.buttonId - this.summoningSlotIdStart != this.playerExt.selectedSummonSet;
                if (!(button instanceof CreatureButton)) continue;
                CreatureButton buttonCreature = (CreatureButton)button;
                buttonCreature.creatureInfo = this.playerExt.getSummonSet(button.buttonId - this.summoningSlotIdStart).getCreatureInfo();
                continue;
            }
            if (button.buttonId < this.petCommandIdStart) continue;
            if (this.playerExt.getSelectedSummonSet() != null) {
                button.visible = true;
                if (button.buttonId == BaseCreatureEntity.PET_COMMAND_ID.PVP.id + this.petCommandIdStart) {
                    if (this.playerExt.getSelectedSummonSet().getPVP()) {
                        button.setMessage(new TranslationTextComponent("gui.pet.pvp", new Object[0]).func_150254_d() + ": " + new TranslationTextComponent("common.yes", new Object[0]).func_150254_d());
                        continue;
                    }
                    button.setMessage(new TranslationTextComponent("gui.pet.pvp", new Object[0]).func_150254_d() + ": " + new TranslationTextComponent("common.no", new Object[0]).func_150254_d());
                    continue;
                }
                if (button.buttonId == BaseCreatureEntity.PET_COMMAND_ID.PASSIVE.id + this.petCommandIdStart) {
                    button.active = !this.playerExt.getSelectedSummonSet().passive;
                    continue;
                }
                if (button.buttonId == BaseCreatureEntity.PET_COMMAND_ID.DEFENSIVE.id + this.petCommandIdStart) {
                    button.active = this.playerExt.getSelectedSummonSet().getPassive() || this.playerExt.getSelectedSummonSet().getAssist() || this.playerExt.getSelectedSummonSet().getAggressive();
                    continue;
                }
                if (button.buttonId == BaseCreatureEntity.PET_COMMAND_ID.ASSIST.id + this.petCommandIdStart) {
                    button.active = this.playerExt.getSelectedSummonSet().getPassive() || !this.playerExt.getSelectedSummonSet().getAssist() || this.playerExt.getSelectedSummonSet().getAggressive();
                    continue;
                }
                if (button.buttonId == BaseCreatureEntity.PET_COMMAND_ID.AGGRESSIVE.id + this.petCommandIdStart) {
                    button.active = this.playerExt.getSelectedSummonSet().getPassive() || !this.playerExt.getSelectedSummonSet().getAggressive();
                    continue;
                }
                if (button.buttonId == BaseCreatureEntity.PET_COMMAND_ID.FOLLOW.id + this.petCommandIdStart) {
                    button.active = this.playerExt.getSelectedSummonSet().getSitting() || !this.playerExt.getSelectedSummonSet().getFollowing();
                    continue;
                }
                if (button.buttonId == BaseCreatureEntity.PET_COMMAND_ID.WANDER.id + this.petCommandIdStart) {
                    button.active = this.playerExt.getSelectedSummonSet().getSitting() || this.playerExt.getSelectedSummonSet().getFollowing();
                    continue;
                }
                if (button.buttonId != BaseCreatureEntity.PET_COMMAND_ID.SIT.id + this.petCommandIdStart) continue;
                button.active = !this.playerExt.getSelectedSummonSet().getSitting();
                continue;
            }
            button.visible = false;
        }
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(mouseX, mouseY, partialTicks);
        int marginX = 0;
        int nextX = this.colRightX + marginX;
        int nextY = this.colRightY + 44;
        int width = this.colRightWidth - marginX;
        if (this.playerExt.beastiary.getSummonableList().isEmpty()) {
            String text = new TranslationTextComponent("gui.beastiary.summoning.empty.info", new Object[0]).func_150254_d();
            this.drawSplitString(text, nextX, nextY, width, 0xFFFFFF, true);
            return;
        }
        CreatureInfo selectedCreature = this.playerExt.getSelectedSummonSet().getCreatureInfo();
        if (selectedCreature != null) {
            this.renderCreature(selectedCreature, this.colRightX + marginX / 2 + this.colRightWidth / 2, this.colRightY + Math.round((float)this.colRightHeight / 2.0f), mouseX, mouseY, partialTicks);
        }
        String text = "\u00a7l" + new TranslationTextComponent("gui.beastiary.player.focus", new Object[0]).func_150254_d() + ": ";
        this.getFontRenderer().func_211126_b(text, (float)nextX, (float)nextY, 0xFFFFFF);
        int barX = nextX + this.getFontRenderer().func_78256_a(text);
        int focusMax = Math.round((float)this.playerExt.summonFocusMax / (float)this.playerExt.summonFocusCharge);
        int focusAvailable = (int)Math.floor((double)this.playerExt.summonFocus / (double)this.playerExt.summonFocusCharge);
        float focusFilling = (float)this.playerExt.summonFocus / (float)this.playerExt.summonFocusCharge - (float)focusAvailable;
        this.drawBar(TextureManager.getTexture("GUIPetSpiritEmpty"), barX, nextY, 0.0f, 9.0f, 9.0f, focusMax, 10);
        this.drawBar(TextureManager.getTexture("GUIPetSpiritUsed"), barX, nextY, 0.0f, 9.0f, 9.0f, focusAvailable, 10);
        if (focusFilling > 0.0f) {
            this.drawTexture(TextureManager.getTexture("GUIPetSpiritFilling"), barX + 9 * focusAvailable, nextY, 0.0f, focusFilling, 1.0f, focusFilling * 9.0f, 9.0f);
        }
        if (selectedCreature != null) {
            nextY += 4 + this.getFontRenderer().func_78267_b(text, this.colRightWidth);
            text = "\u00a7l" + new TranslationTextComponent("creature.stat.focus", new Object[0]).func_150254_d() + ": ";
            this.getFontRenderer().func_211126_b(text, (float)nextX, (float)nextY, 0xFFFFFF);
            this.drawLevel(selectedCreature, TextureManager.getTexture("GUIPetLevel"), nextX + this.getFontRenderer().func_78256_a(text), nextY);
        } else {
            nextY += 4 + this.getFontRenderer().func_78267_b(text, this.colRightWidth);
            text = new TranslationTextComponent("gui.beastiary.summoning.select", new Object[0]).func_150254_d();
            this.drawSplitString(text, nextX, nextY, width, 0xFFFFFF, true);
        }
        int buttonHeight = 20;
        int buttonSpacing = 2;
        int buttonY = this.colRightY + this.colRightHeight - (buttonHeight + buttonSpacing) * 3;
        this.getFontRenderer().func_211126_b("\u00a7l" + new TranslationTextComponent("gui.pet.actions", new Object[0]).func_150254_d(), (float)this.colRightX, (float)(buttonY + 6), 0xFFFFFF);
        this.getFontRenderer().func_211126_b("\u00a7l" + new TranslationTextComponent("gui.pet.stance", new Object[0]).func_150254_d(), (float)this.colRightX, (float)((buttonY += buttonHeight + buttonSpacing) + 6), 0xFFFFFF);
        this.getFontRenderer().func_211126_b("\u00a7l" + new TranslationTextComponent("gui.pet.movement", new Object[0]).func_150254_d(), (float)this.colRightX, (float)((buttonY += buttonHeight + buttonSpacing) + 6), 0xFFFFFF);
    }

    @Override
    public void actionPerformed(int buttonId) {
        SummonSet summonSet;
        if (buttonId >= this.summoningSlotIdStart && buttonId < this.petCommandIdStart) {
            this.playerExt.setSelectedSummonSet(buttonId - this.summoningSlotIdStart);
            MessageSummonSetSelection message = new MessageSummonSetSelection(this.playerExt);
            LycanitesMobs.packetHandler.sendToServer(message);
        }
        if ((summonSet = this.playerExt.getSelectedSummonSet()) != null && buttonId >= this.petCommandIdStart) {
            int petCommandId = buttonId - this.petCommandIdStart;
            if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.PVP.id) {
                summonSet.pvp = !summonSet.pvp;
            } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.PASSIVE.id) {
                summonSet.passive = true;
                summonSet.assist = false;
                summonSet.aggressive = false;
            } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.DEFENSIVE.id) {
                summonSet.passive = false;
                summonSet.assist = false;
                summonSet.aggressive = false;
            } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.ASSIST.id) {
                summonSet.passive = false;
                summonSet.assist = true;
                summonSet.aggressive = false;
            } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.AGGRESSIVE.id) {
                summonSet.passive = false;
                summonSet.assist = true;
                summonSet.aggressive = true;
            } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.FOLLOW.id) {
                summonSet.following = true;
                summonSet.sitting = false;
            } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.WANDER.id) {
                summonSet.following = false;
                summonSet.sitting = false;
            } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.SIT.id) {
                summonSet.following = false;
                summonSet.sitting = true;
            }
            this.playerExt.sendSummonSetToServer((byte)this.playerExt.selectedSummonSet);
            if (this.playerExt.selectedPet == null) {
                this.mc.func_147108_a((Screen)new SummoningBeastiaryScreen((PlayerEntity)this.mc.field_71439_g));
            }
            return;
        }
        super.actionPerformed(buttonId);
    }

    @Override
    public ITextComponent getTitle() {
        if (this.playerExt.beastiary.getSummonableList().isEmpty()) {
            return new TranslationTextComponent("gui.beastiary.summoning.empty.title", new Object[0]);
        }
        return new TranslationTextComponent("gui.beastiary.summoning", new Object[0]);
    }

    @Override
    public int getDisplaySubspecies(CreatureInfo creatureInfo) {
        return this.playerExt.getSelectedSummonSet().subspecies;
    }

    @Override
    public void playCreatureSelectSound(CreatureInfo creatureInfo) {
        this.player.func_130014_f_().func_184148_a(this.player, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, ObjectManager.getSound(creatureInfo.getName() + "_tame"), SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }
}

