/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureFilterList;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureList;
import com.lycanitesmobs.client.gui.beastiary.lists.PetTypeList;
import com.lycanitesmobs.client.gui.buttons.ButtonBase;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.pets.PetEntry;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PetsBeastiaryScreen
extends BeastiaryScreen {
    public CreatureFilterList petTypeList;
    public CreatureList petList;
    private int petCommandIdStart = 200;
    private int releaseConfirmId = 300;
    private int releaseCancelId = 301;

    public PetsBeastiaryScreen(PlayerEntity player) {
        super(player);
        this.playerExt.selectedSubspecies = 0;
    }

    @Override
    public void initWidgets() {
        super.initWidgets();
        int petTypeListHeight = Math.round((float)this.colLeftHeight * 0.225f);
        int petTypeListY = this.colLeftY;
        this.petTypeList = new PetTypeList(this, this.colLeftWidth, petTypeListHeight, petTypeListY, petTypeListY + petTypeListHeight, this.colLeftX);
        this.children.add(this.petTypeList);
        int petListHeight = Math.round((float)this.colLeftHeight * 0.7f);
        int petListY = petTypeListY + petTypeListHeight + Math.round((float)this.colLeftHeight * 0.025f);
        this.petList = new CreatureList(CreatureList.Type.PET, this, this.petTypeList, this.colLeftWidth, petListHeight, petListY, petListY + petListHeight, this.colLeftX);
        this.children.add(this.petList);
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonSpacing = 2;
        int buttonMarginX = 10 + Math.max(Math.max(this.getFontRenderer().func_78256_a(new TranslationTextComponent("gui.pet.actions", new Object[0]).func_150254_d()), this.getFontRenderer().func_78256_a(new TranslationTextComponent("gui.pet.stance", new Object[0]).func_150254_d())), this.getFontRenderer().func_78256_a(new TranslationTextComponent("gui.pet.movement", new Object[0]).func_150254_d()));
        int buttonX = this.colRightX + buttonMarginX;
        int buttonY = this.colRightY + this.colRightHeight - (buttonHeight + buttonSpacing) * 3;
        ButtonBase button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.ACTIVE.id + this.petCommandIdStart, buttonX, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.active", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.TELEPORT.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.teleport", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.PVP.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.pvp", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.RELEASE.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.release", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        buttonX = this.colRightX + buttonMarginX;
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.PASSIVE.id + this.petCommandIdStart, buttonX, buttonY += buttonHeight + 2, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.passive", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.DEFENSIVE.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.defensive", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.ASSIST.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.assist", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.AGGRESSIVE.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.aggressive", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        buttonX = this.colRightX + buttonMarginX;
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.FOLLOW.id + this.petCommandIdStart, buttonX, buttonY += buttonHeight + 2, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.follow", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.WANDER.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.wander", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.SIT.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.pet.sit", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        buttonX = this.colRightX + Math.round((float)this.colRightWidth / 2.0f) - (buttonWidth + buttonSpacing);
        buttonY = this.colRightY + Math.round((float)this.colRightHeight / 2.0f) - Math.round((float)buttonHeight / 2.0f);
        button = new ButtonBase(this.releaseConfirmId, buttonX, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("common.yes", new Object[0]).func_150254_d(), this);
        button.visible = false;
        this.addButton((Widget)button);
        button = new ButtonBase(this.releaseCancelId, (buttonX += buttonSpacing) + buttonWidth, buttonY, buttonWidth, buttonHeight, new TranslationTextComponent("common.no", new Object[0]).func_150254_d(), this);
        button.visible = false;
        this.addButton((Widget)button);
    }

    @Override
    public void renderBackground(int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(mouseX, mouseY, partialTicks);
        if (this.playerExt.selectedPet != null) {
            this.renderCreature(this.playerExt.selectedPet.getCreatureInfo(), this.colRightX + this.colRightWidth / 2, this.colRightY + Math.round((float)this.colRightHeight / 2.0f), mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void renderWidgets(int mouseX, int mouseY, float partialTicks) {
        boolean empty;
        super.renderWidgets(mouseX, mouseY, partialTicks);
        boolean bl = empty = this.playerExt.petManager.getEntryList("pet").isEmpty() && this.playerExt.petManager.getEntryList("mount").isEmpty() && this.playerExt.petManager.getEntryList("familiar").isEmpty();
        if (!empty) {
            this.petTypeList.render(mouseX, mouseY, partialTicks);
            this.petList.render(mouseX, mouseY, partialTicks);
        }
        for (Widget buttonWidget : this.buttons) {
            if (!(buttonWidget instanceof ButtonBase)) continue;
            ButtonBase button = (ButtonBase)buttonWidget;
            if (button.buttonId >= this.petCommandIdStart && button.buttonId < this.releaseConfirmId) {
                boolean bl2 = button.visible = !empty && this.playerExt.selectedPet != null;
                if (this.playerExt.selectedPet != null && !this.playerExt.selectedPet.releaseEntity) {
                    if (button.buttonId == BaseCreatureEntity.PET_COMMAND_ID.ACTIVE.id + this.petCommandIdStart) {
                        if (!this.playerExt.selectedPet.spawningActive) {
                            button.setMessage(new TranslationTextComponent("gui.pet.summon", new Object[0]).func_150254_d());
                            continue;
                        }
                        button.setMessage(new TranslationTextComponent("gui.pet.dismiss", new Object[0]).func_150254_d());
                        continue;
                    }
                    if (button.buttonId == BaseCreatureEntity.PET_COMMAND_ID.PVP.id + this.petCommandIdStart) {
                        if (this.playerExt.selectedPet.summonSet.getPVP()) {
                            button.setMessage(new TranslationTextComponent("gui.pet.pvp", new Object[0]).func_150254_d() + ": " + new TranslationTextComponent("common.yes", new Object[0]).func_150254_d());
                            continue;
                        }
                        button.setMessage(new TranslationTextComponent("gui.pet.pvp", new Object[0]).func_150254_d() + ": " + new TranslationTextComponent("common.no", new Object[0]).func_150254_d());
                        continue;
                    }
                    if (button.buttonId == BaseCreatureEntity.PET_COMMAND_ID.PASSIVE.id + this.petCommandIdStart) {
                        button.active = !this.playerExt.selectedPet.summonSet.passive;
                        continue;
                    }
                    if (button.buttonId == BaseCreatureEntity.PET_COMMAND_ID.DEFENSIVE.id + this.petCommandIdStart) {
                        button.active = this.playerExt.selectedPet.summonSet.getPassive() || this.playerExt.selectedPet.summonSet.getAssist() || this.playerExt.selectedPet.summonSet.getAggressive();
                        continue;
                    }
                    if (button.buttonId == BaseCreatureEntity.PET_COMMAND_ID.ASSIST.id + this.petCommandIdStart) {
                        button.active = this.playerExt.selectedPet.summonSet.getPassive() || !this.playerExt.selectedPet.summonSet.getAssist() || this.playerExt.selectedPet.summonSet.getAggressive();
                        continue;
                    }
                    if (button.buttonId == BaseCreatureEntity.PET_COMMAND_ID.AGGRESSIVE.id + this.petCommandIdStart) {
                        button.active = this.playerExt.selectedPet.summonSet.getPassive() || !this.playerExt.selectedPet.summonSet.getAggressive();
                        continue;
                    }
                    if (button.buttonId == BaseCreatureEntity.PET_COMMAND_ID.FOLLOW.id + this.petCommandIdStart) {
                        button.active = this.playerExt.selectedPet.summonSet.getSitting() || !this.playerExt.selectedPet.summonSet.getFollowing();
                        continue;
                    }
                    if (button.buttonId == BaseCreatureEntity.PET_COMMAND_ID.WANDER.id + this.petCommandIdStart) {
                        button.active = this.playerExt.selectedPet.summonSet.getSitting() || this.playerExt.selectedPet.summonSet.getFollowing();
                        continue;
                    }
                    if (button.buttonId != BaseCreatureEntity.PET_COMMAND_ID.SIT.id + this.petCommandIdStart) continue;
                    button.active = !this.playerExt.selectedPet.summonSet.getSitting();
                    continue;
                }
                button.visible = false;
                continue;
            }
            if (button.buttonId != this.releaseConfirmId && button.buttonId != this.releaseCancelId) continue;
            button.visible = this.playerExt.selectedPet != null && this.playerExt.selectedPet.releaseEntity && !empty;
        }
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(mouseX, mouseY, partialTicks);
        int marginX = 0;
        int nextX = this.colRightX + marginX;
        int nextY = this.colRightY + 20;
        int width = this.colRightWidth - marginX;
        if (this.playerExt.petManager.getEntryList("pet").isEmpty() && this.playerExt.petManager.getEntryList("mount").isEmpty() && this.playerExt.petManager.getEntryList("familiar").isEmpty()) {
            String text = new TranslationTextComponent("gui.beastiary.pets.empty.info", new Object[0]).func_150254_d();
            this.drawSplitString(text, nextX, nextY, width, 0xFFFFFF, true);
            return;
        }
        String text = "\u00a7l" + new TranslationTextComponent("gui.beastiary.player.spirit", new Object[0]).func_150254_d() + ": ";
        this.getFontRenderer().func_211126_b(text, (float)nextX, (float)nextY, 0xFFFFFF);
        int barX = nextX + this.getFontRenderer().func_78256_a(text);
        int spiritMax = Math.round((float)this.playerExt.spiritMax / (float)this.playerExt.spiritCharge);
        int spiritReserved = (int)Math.floor((double)this.playerExt.spiritReserved / (double)this.playerExt.spiritCharge);
        int spiritAvailable = (int)Math.floor((double)this.playerExt.spirit / (double)this.playerExt.spiritCharge);
        float spiritFilling = (float)this.playerExt.spirit / (float)this.playerExt.spiritCharge - (float)spiritAvailable;
        this.drawBar(TextureManager.getTexture("GUIPetSpiritEmpty"), barX, nextY, 0.0f, 9.0f, 9.0f, spiritMax, 10);
        this.drawBar(TextureManager.getTexture("GUIPetSpirit"), barX, nextY, 0.0f, 9.0f, 9.0f, spiritAvailable, 10);
        if (spiritFilling > 0.0f) {
            this.drawTexture(TextureManager.getTexture("GUIPetSpiritFilling"), barX + 9 * spiritAvailable, nextY, 0.0f, spiritFilling, 1.0f, spiritFilling * 9.0f, 9.0f);
        }
        this.drawBar(TextureManager.getTexture("GUIPetSpiritUsed"), barX, nextY, 0.0f, 9.0f, 9.0f, spiritReserved, -10);
        if (this.playerExt.selectedPet != null) {
            nextY += 4 + this.getFontRenderer().func_78267_b(text, this.colRightWidth);
            text = "\u00a7l" + new TranslationTextComponent("creature.stat.spirit", new Object[0]).func_150254_d() + ": ";
            this.getFontRenderer().func_211126_b(text, (float)nextX, (float)nextY, 0xFFFFFF);
            this.drawLevel(this.playerExt.selectedPet.getCreatureInfo(), TextureManager.getTexture("GUIPetLevel"), nextX + this.getFontRenderer().func_78256_a(text), nextY);
            nextY += 4 + this.getFontRenderer().func_78267_b(text, this.colRightWidth);
            text = this.playerExt.selectedPet.respawnTime <= 0 ? "\u00a7l" + new TranslationTextComponent("creature.stat.health", new Object[0]).func_150254_d() + ": " : "\u00a7l" + new TranslationTextComponent("creature.stat.respawning", new Object[0]).func_150254_d() + ": ";
            this.getFontRenderer().func_211126_b(text, (float)nextX, (float)nextY, 0xFFFFFF);
            barX = nextX + this.getFontRenderer().func_78256_a(text);
            int barY = nextY - 1;
            int barWidth = 80;
            int barHeight = 10;
            this.drawTexture(TextureManager.getTexture("GUIPetBarEmpty"), barX, barY, 0.0f, 1.0f, 1.0f, barWidth, barHeight);
            if (this.playerExt.selectedPet.respawnTime <= 0) {
                float healthNormal = this.playerExt.selectedPet.getHealth() / this.playerExt.selectedPet.getMaxHealth();
                this.drawTexture(TextureManager.getTexture("GUIPetBarHealth"), barX, barY, 0.0f, healthNormal, 1.0f, (float)barWidth * healthNormal, barHeight);
            } else {
                float respawnNormal = 1.0f - (float)this.playerExt.selectedPet.respawnTime / (float)this.playerExt.selectedPet.respawnTimeMax;
                this.drawTexture(TextureManager.getTexture("GUIPetBarRespawn"), barX, barY, 0.0f, respawnNormal, 1.0f, (float)barWidth * respawnNormal, barHeight);
            }
        } else {
            nextY += 4 + this.getFontRenderer().func_78267_b(text, this.colRightWidth);
            text = new TranslationTextComponent("gui.beastiary.pets.select", new Object[0]).func_150254_d();
            this.drawSplitString(text, nextX, nextY, width, 0xFFFFFF, true);
        }
        int buttonHeight = 20;
        int buttonSpacing = 2;
        int buttonY = this.colRightY + this.colRightHeight - (buttonHeight + buttonSpacing) * 3;
        if (this.playerExt.selectedPet != null && !this.playerExt.selectedPet.releaseEntity) {
            this.getFontRenderer().func_211126_b("\u00a7l" + new TranslationTextComponent("gui.pet.actions", new Object[0]).func_150254_d(), (float)this.colRightX, (float)(buttonY + 6), 0xFFFFFF);
            this.getFontRenderer().func_211126_b("\u00a7l" + new TranslationTextComponent("gui.pet.stance", new Object[0]).func_150254_d(), (float)this.colRightX, (float)((buttonY += buttonHeight + buttonSpacing) + 6), 0xFFFFFF);
            this.getFontRenderer().func_211126_b("\u00a7l" + new TranslationTextComponent("gui.pet.movement", new Object[0]).func_150254_d(), (float)this.colRightX, (float)((buttonY += buttonHeight + buttonSpacing) + 6), 0xFFFFFF);
        }
        if (this.playerExt.selectedPet != null && this.playerExt.selectedPet.releaseEntity) {
            text = new TranslationTextComponent("gui.pet.release.confirm", new Object[0]).func_150254_d();
            nextX = this.colRightX;
            nextY = this.colRightY + Math.round((float)this.colRightHeight / 2.0f) - Math.round((float)buttonHeight / 2.0f) - this.getFontRenderer().func_78267_b(text, this.colRightWidth) - 2;
            this.drawSplitString(text, nextX, nextY, this.colRightWidth, 0xFFFFFF, true);
        }
    }

    @Override
    public void actionPerformed(int buttonId) {
        if (this.playerExt.selectedPet != null && this.playerExt.selectedPet.summonSet != null) {
            PetEntry petEntry = this.playerExt.selectedPet;
            if (buttonId >= this.petCommandIdStart && buttonId < this.releaseConfirmId) {
                int petCommandId = buttonId - this.petCommandIdStart;
                if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.ACTIVE.id) {
                    petEntry.spawningActive = !petEntry.spawningActive;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.TELEPORT.id) {
                    petEntry.teleportEntity = true;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.PVP.id) {
                    petEntry.summonSet.pvp = !petEntry.summonSet.pvp;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.RELEASE.id) {
                    petEntry.releaseEntity = true;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.PASSIVE.id) {
                    petEntry.summonSet.passive = true;
                    petEntry.summonSet.assist = false;
                    petEntry.summonSet.aggressive = false;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.DEFENSIVE.id) {
                    petEntry.summonSet.passive = false;
                    petEntry.summonSet.assist = false;
                    petEntry.summonSet.aggressive = false;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.ASSIST.id) {
                    petEntry.summonSet.passive = false;
                    petEntry.summonSet.assist = true;
                    petEntry.summonSet.aggressive = false;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.AGGRESSIVE.id) {
                    petEntry.summonSet.passive = false;
                    petEntry.summonSet.assist = true;
                    petEntry.summonSet.aggressive = true;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.FOLLOW.id) {
                    petEntry.summonSet.following = true;
                    petEntry.summonSet.sitting = false;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.WANDER.id) {
                    petEntry.summonSet.following = false;
                    petEntry.summonSet.sitting = false;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.SIT.id) {
                    petEntry.summonSet.following = false;
                    petEntry.summonSet.sitting = true;
                }
                this.playerExt.sendPetEntryToServer(petEntry);
                if (this.playerExt.selectedPet == null) {
                    this.mc.func_147108_a((Screen)new PetsBeastiaryScreen((PlayerEntity)this.mc.field_71439_g));
                }
                return;
            }
            if (buttonId == this.releaseCancelId) {
                petEntry.releaseEntity = false;
                return;
            }
            if (buttonId == this.releaseConfirmId) {
                this.playerExt.selectedPet = null;
                this.playerExt.sendPetEntryRemoveRequest(petEntry);
                return;
            }
        }
        super.actionPerformed(buttonId);
    }

    @Override
    public ITextComponent getTitle() {
        if (this.playerExt.selectedPet != null) {
            ITextComponent title = this.playerExt.selectedPet.getDisplayName();
            if (this.playerExt.selectedPet.releaseEntity) {
                title = new TranslationTextComponent("gui.pet.release", new Object[0]).func_150258_a(" ").func_150257_a(title);
            }
            return title;
        }
        if (this.playerExt.petManager.getEntryList("pet").isEmpty() && this.playerExt.petManager.getEntryList("mount").isEmpty() && this.playerExt.petManager.getEntryList("familiar").isEmpty()) {
            return new TranslationTextComponent(new TranslationTextComponent("gui.beastiary.pets.empty.title", new Object[0]).func_150254_d(), new Object[0]);
        }
        return new TranslationTextComponent(new TranslationTextComponent("gui.beastiary.pets", new Object[0]).func_150254_d(), new Object[0]);
    }

    @Override
    public int getDisplaySubspecies(CreatureInfo creatureInfo) {
        return this.playerExt.selectedPet.subspeciesID;
    }

    @Override
    public void playCreatureSelectSound(CreatureInfo creatureInfo) {
        this.player.func_130014_f_().func_184148_a(this.player, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, ObjectManager.getSound(creatureInfo.getName() + "_tame"), SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }
}

