/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary;

import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureDescriptionList;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureList;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureTypeList;
import com.lycanitesmobs.client.gui.beastiary.lists.SubspeciesList;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CreaturesBeastiaryScreen
extends BeastiaryScreen {
    public CreatureTypeList creatureTypeList;
    public CreatureList creatureList;
    public SubspeciesList subspeciesList;
    public CreatureDescriptionList descriptionList;

    public CreaturesBeastiaryScreen(PlayerEntity player) {
        super(player);
    }

    @Override
    public void initWidgets() {
        super.initWidgets();
        this.creatureTypeList = new CreatureTypeList(this, this.colLeftWidth, this.colLeftHeight, this.colLeftY, this.colLeftY + this.colLeftHeight, this.colLeftX);
        this.children.add(this.creatureTypeList);
        int selectionListsWidth = this.getScaledX(0.125f);
        int creatureListY = this.colRightY;
        int creatureListHeight = Math.round((float)this.colRightHeight * 0.6f);
        this.creatureList = new CreatureList(CreatureList.Type.KNOWLEDGE, this, this.creatureTypeList, selectionListsWidth, creatureListHeight, creatureListY, creatureListY + creatureListHeight, this.colRightX);
        this.children.add(this.creatureList);
        int subspeciesListY = creatureListY + 2 + creatureListHeight;
        int subspeciesListHeight = Math.round((float)this.colRightHeight * 0.4f) - 2;
        this.subspeciesList = new SubspeciesList(this, false, selectionListsWidth, subspeciesListHeight, subspeciesListY, subspeciesListY + subspeciesListHeight, this.colRightX);
        this.children.add(this.subspeciesList);
        int newLine = this.getFontRenderer().func_78267_b("AAAAAAAAAAAAAAAAAAAAAAAAAAAAA", this.colRightWidth - selectionListsWidth) + 2;
        int descriptionListY = this.colRightY + newLine * 3;
        this.descriptionList = new CreatureDescriptionList(this, this.colRightWidth - selectionListsWidth, this.colRightHeight, descriptionListY, this.colRightY + this.colRightHeight, this.colRightX + selectionListsWidth + 2);
        this.children.add(this.descriptionList);
    }

    @Override
    public void renderBackground(int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(mouseX, mouseY, partialTicks);
        if (this.playerExt.selectedCreature != null) {
            int marginX = this.getScaledX(0.125f) + 8;
            this.renderCreature(this.playerExt.selectedCreature, this.colRightX + marginX / 2 + this.colRightWidth / 2, this.colRightY + 100, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void renderWidgets(int mouseX, int mouseY, float partialTicks) {
        super.renderWidgets(mouseX, mouseY, partialTicks);
        if (this.playerExt.getBeastiary().creatureKnowledgeList.isEmpty()) {
            return;
        }
        this.creatureTypeList.render(mouseX, mouseY, partialTicks);
        if (this.playerExt.selectedCreatureType != null) {
            this.creatureList.render(mouseX, mouseY, partialTicks);
            this.subspeciesList.render(mouseX, mouseY, partialTicks);
        }
        if (this.playerExt.selectedCreature != null) {
            this.descriptionList.creatureKnowledge = this.playerExt.beastiary.getCreatureKnowledge(this.playerExt.selectedCreature.getName());
            this.descriptionList.render(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(mouseX, mouseY, partialTicks);
        int marginX = this.getScaledX(0.125f) + 8;
        int nextX = this.colRightX + marginX;
        int nextY = this.colRightY;
        int width = this.colRightWidth - marginX;
        if (this.playerExt.getBeastiary().creatureKnowledgeList.isEmpty()) {
            String text = new TranslationTextComponent("gui.beastiary.creatures.empty.info", new Object[0]).func_150254_d();
            this.drawSplitString(text, this.colRightX, nextY += this.getFontRenderer().func_78267_b("AAAAAAAAAAAAAAAAAAAAAAAAAAAAA", this.colRightWidth) + 2, this.colRightWidth, 0xFFFFFF, true);
            return;
        }
        if (this.playerExt.selectedCreature != null) {
            CreatureInfo creatureInfo = this.playerExt.selectedCreature;
            CreatureKnowledge creatureKnowledge = this.playerExt.beastiary.getCreatureKnowledge(this.playerExt.selectedCreature.getName());
            String text = "\u00a7l" + new TranslationTextComponent("creature.stat.element", new Object[0]).func_150254_d() + ": \u00a7r";
            text = text + (creatureInfo.elements != null ? creatureInfo.getElementNames().func_150254_d() : "None");
            this.getFontRenderer().func_78279_b(text, nextX, nextY, width, 0xFFFFFF);
            nextY += 2 + this.getFontRenderer().func_78267_b(text, width);
            text = "\u00a7l" + new TranslationTextComponent("creature.stat.cost", new Object[0]).func_150254_d() + ": \u00a7r";
            this.getFontRenderer().func_78279_b(text, nextX, nextY, width, 0xFFFFFF);
            this.drawLevel(creatureInfo, TextureManager.getTexture("GUIPetLevel"), nextX + this.getFontRenderer().func_78256_a(text), nextY);
            nextY += 2 + this.getFontRenderer().func_78267_b(text, width);
            text = "\u00a7l" + new TranslationTextComponent("creature.stat.knowledge", new Object[0]).func_150254_d() + ": \u00a7r";
            this.getFontRenderer().func_78279_b(text, nextX, nextY, width, 0xFFFFFF);
            this.drawBar(TextureManager.getTexture("GUIPetSpiritEmpty"), nextX + this.getFontRenderer().func_78256_a(text), nextY, 0.0f, 9.0f, 9.0f, 3, 10);
            if (creatureKnowledge != null) {
                this.drawBar(TextureManager.getTexture("GUIPetSpiritUsed"), nextX + this.getFontRenderer().func_78256_a(text), nextY, 0.0f, 9.0f, 9.0f, creatureKnowledge.rank, 10);
            }
        } else if (this.playerExt.selectedCreatureType != null) {
            String text = this.playerExt.selectedCreatureType.getTitle().func_150254_d();
            this.drawSplitString(text, nextX, nextY += this.getFontRenderer().func_78267_b("AAAAAAAAAAAAAAAAAAAAAAAAAAAAA", this.colRightWidth) + 2, width, 0xFFFFFF, true);
            nextY += 12 + this.getFontRenderer().func_78267_b(text, this.colRightWidth);
            text = new TranslationTextComponent("gui.beastiary.creatures.descovered", new Object[0]).func_150254_d() + ": ";
            text = text + this.playerExt.getBeastiary().getCreaturesDescovered(this.playerExt.selectedCreatureType);
            text = text + "/" + this.playerExt.selectedCreatureType.creatures.size();
            this.getFontRenderer().func_175063_a(text, (float)nextX, (float)nextY, 0xFFFFFF);
        } else {
            String text = new TranslationTextComponent("gui.beastiary.creatures.select", new Object[0]).func_150254_d();
            this.drawSplitString(text, this.colRightX, nextY += this.getFontRenderer().func_78267_b("AAAAAAAAAAAAAAAAAAAAAAAAAAAAA", this.colRightWidth) + 2, this.colRightWidth, 0xFFFFFF, true);
        }
    }

    @Override
    public ITextComponent getTitle() {
        if (this.creatureList != null && this.playerExt.selectedCreature != null) {
            return new TranslationTextComponent("", new Object[0]);
        }
        if (this.creatureTypeList != null && this.playerExt.selectedCreatureType != null) {
            return this.playerExt.selectedCreatureType.getTitle();
        }
        if (this.playerExt.getBeastiary().creatureKnowledgeList.isEmpty()) {
            return new TranslationTextComponent("gui.beastiary.creatures.empty.title", new Object[0]);
        }
        return new TranslationTextComponent("gui.beastiary.creatures", new Object[0]);
    }
}

