/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.client.gui.BaseScreen;
import com.lycanitesmobs.client.gui.beastiary.CreaturesBeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.ElementsBeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.IndexBeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.PetsBeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.SummoningBeastiaryScreen;
import com.lycanitesmobs.client.gui.buttons.ButtonBase;
import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class BeastiaryScreen
extends BaseScreen {
    static int OPENED_GUI_SCALE;
    static boolean GUI_ACTIVE;
    public Minecraft mc;
    public PlayerEntity player;
    public ExtendedPlayer playerExt;
    public LivingEntity creaturePreviewEntity;
    public float creaturePreviewTicks = 0.0f;
    public int centerX;
    public int centerY;
    public int windowWidth;
    public int windowHeight;
    public int halfX;
    public int halfY;
    public int windowX;
    public int windowY;
    public int colLeftX;
    public int colLeftY;
    public int colLeftWidth;
    public int colLeftHeight;
    public int colLeftCenterX;
    public int colLeftCenterY;
    public int colRightX;
    public int colRightY;
    public int colRightWidth;
    public int colRightHeight;
    public int colRightCenterX;
    public int colRightCenterY;

    public BeastiaryScreen(PlayerEntity player) {
        super((ITextComponent)new TranslationTextComponent("gui.beastiary.name", new Object[0]));
        this.player = player;
        this.playerExt = ExtendedPlayer.getForPlayer(player);
        this.mc = Minecraft.func_71410_x();
    }

    public void onClose() {
        super.onClose();
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void init() {
        super.init();
        if (this.scaledResolution == null) {
            this.scaledResolution = this.mc.field_195558_d;
        }
        this.zLevel = -1000.0f;
        this.windowWidth = this.getScaledX(0.95f);
        this.windowHeight = this.getScaledY(0.95f);
        this.halfX = this.windowWidth / 2;
        this.halfY = this.windowHeight / 2;
        this.windowX = this.width / 2 - this.windowWidth / 2;
        this.windowY = this.height / 2 - this.windowHeight / 2;
        this.centerX = this.windowX + this.windowWidth / 2;
        this.centerY = this.windowY + this.windowHeight / 2;
        this.colLeftX = this.windowX + this.getScaledX(0.041666668f);
        this.colLeftY = this.windowY + this.getScaledY(0.42592594f);
        this.colLeftWidth = this.getScaledX(0.16666667f);
        this.colLeftHeight = this.getScaledX(0.35185185f);
        this.colLeftCenterX = this.colLeftX + Math.round(this.colLeftWidth / 2);
        this.colLeftCenterY = this.colLeftY + Math.round(this.colLeftHeight / 2);
        this.colRightX = this.windowX + this.getScaledX(0.25f);
        this.colRightY = this.windowY + this.getScaledY(0.3888889f);
        this.colRightWidth = this.getScaledX(0.65625f);
        this.colRightHeight = this.getScaledX(0.37037036f);
        this.colRightCenterX = this.colRightX + Math.round(this.colRightWidth / 2);
        this.colRightCenterY = this.colRightY + Math.round(this.colRightHeight / 2);
    }

    @Override
    protected void initWidgets() {
        int menuPadding = 6;
        int menuX = this.centerX - Math.round((float)this.windowWidth / 2.0f) + menuPadding;
        int menuY = this.windowY + menuPadding;
        int menuWidth = this.windowWidth - menuPadding * 2;
        int buttonCount = 5;
        int buttonPadding = 2;
        int buttonX = menuX + buttonPadding;
        int buttonWidth = Math.round(menuWidth / buttonCount) - buttonPadding * 2;
        int buttonWidthPadded = buttonWidth + buttonPadding * 2;
        int buttonHeight = 20;
        ButtonBase button = new ButtonBase(Page.INDEX.id, buttonX + buttonWidthPadded * this.buttons.size(), menuY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.beastiary.index.title", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(Page.CREATURES.id, buttonX + buttonWidthPadded * this.buttons.size(), menuY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.beastiary.creatures", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(Page.PETS.id, buttonX + buttonWidthPadded * this.buttons.size(), menuY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.beastiary.pets", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(Page.SUMMONING.id, buttonX + buttonWidthPadded * this.buttons.size(), menuY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.beastiary.summoning", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
        button = new ButtonBase(Page.ELEMENTS.id, buttonX + buttonWidthPadded * this.buttons.size(), menuY, buttonWidth, buttonHeight, new TranslationTextComponent("gui.beastiary.elements", new Object[0]).func_150254_d(), this);
        this.addButton((Widget)button);
    }

    @Override
    public void renderBackground(int mouseX, int mouseY, float partialTicks) {
        this.drawTexture(TextureManager.getTexture("GUIBeastiaryBackground"), this.windowX, this.windowY, this.zLevel, 1.0f, 1.0f, this.windowWidth, this.windowHeight);
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        ITextComponent title = new StringTextComponent("\u00a7l\u00a7n").func_150257_a(this.getTitle());
        float width = this.getFontRenderer().func_78256_a(title.func_150254_d());
        this.getFontRenderer().func_175063_a(title.func_150254_d(), (float)(this.colRightCenterX - Math.round(width / 2.0f)), (float)this.colRightY, 0xFFFFFF);
    }

    @Override
    public void actionPerformed(int buttonId) {
        if (buttonId == Page.INDEX.id) {
            this.mc.func_147108_a((Screen)new IndexBeastiaryScreen((PlayerEntity)Minecraft.func_71410_x().field_71439_g));
        }
        if (buttonId == Page.CREATURES.id) {
            this.mc.func_147108_a((Screen)new CreaturesBeastiaryScreen((PlayerEntity)Minecraft.func_71410_x().field_71439_g));
        }
        if (buttonId == Page.PETS.id) {
            this.mc.func_147108_a((Screen)new PetsBeastiaryScreen((PlayerEntity)Minecraft.func_71410_x().field_71439_g));
        }
        if (buttonId == Page.SUMMONING.id) {
            this.mc.func_147108_a((Screen)new SummoningBeastiaryScreen((PlayerEntity)Minecraft.func_71410_x().field_71439_g));
        }
        if (buttonId == Page.ELEMENTS.id) {
            this.mc.func_147108_a((Screen)new ElementsBeastiaryScreen((PlayerEntity)Minecraft.func_71410_x().field_71439_g));
        }
    }

    public boolean func_223281_a_(int keyCode, int keyCodeB, int keyCodeC) {
        if (keyCode == 1 || keyCode == this.mc.field_71474_y.field_151445_Q.getKey().func_197937_c()) {
            this.mc.field_71439_g.func_71053_j();
        }
        return super.func_223281_a_(keyCode, keyCodeB, keyCodeC);
    }

    public ITextComponent getTitle() {
        return new TranslationTextComponent("gui.beastiary.name", new Object[0]);
    }

    public void drawLevel(CreatureInfo creatureInfo, ResourceLocation texture, int x, int y) {
        int level = creatureInfo.summonCost;
        if (level <= 10) {
            this.drawBar(texture, x, y, 0.0f, 9.0f, 9.0f, level, 10);
        }
    }

    public void renderCreature(CreatureInfo creatureInfo, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (creatureInfo == null) {
            this.creaturePreviewEntity = null;
            return;
        }
        try {
            boolean subspeciesMatch = true;
            if (this.creaturePreviewEntity instanceof BaseCreatureEntity) {
                boolean bl = subspeciesMatch = ((BaseCreatureEntity)this.creaturePreviewEntity).getSubspeciesIndex() == this.getDisplaySubspecies(creatureInfo);
            }
            if (this.creaturePreviewEntity == null || this.creaturePreviewEntity.getClass() != creatureInfo.entityClass || !subspeciesMatch) {
                this.creaturePreviewEntity = creatureInfo.createEntity(this.player.func_130014_f_());
                this.creaturePreviewEntity.field_70122_E = true;
                if (this.creaturePreviewEntity instanceof BaseCreatureEntity) {
                    ((BaseCreatureEntity)this.creaturePreviewEntity).setSubspecies(this.getDisplaySubspecies(creatureInfo));
                }
                if (this.creaturePreviewEntity instanceof AgeableCreatureEntity) {
                    ((AgeableCreatureEntity)this.creaturePreviewEntity).setGrowingAge(0);
                }
                this.onCreateDisplayEntity(creatureInfo, this.creaturePreviewEntity);
                this.playCreatureSelectSound(creatureInfo);
            }
            if (this.creaturePreviewEntity != null) {
                int creatureSize = 70;
                double creatureWidth = creatureInfo.width;
                double creatureHeight = creatureInfo.height;
                int scale = (int)Math.round((double)1.8f / Math.max(creatureWidth, creatureHeight) * (double)creatureSize);
                int posX = x;
                int posY = y + 32 + creatureSize;
                float lookX = (float)posX - (float)mouseX;
                float lookY = (float)posY - (float)mouseY;
                this.creaturePreviewTicks += partialTicks;
                if (this.creaturePreviewEntity instanceof BaseCreatureEntity) {
                    BaseCreatureEntity previewCreatureBase = (BaseCreatureEntity)this.creaturePreviewEntity;
                    previewCreatureBase.onlyRenderTicks = this.creaturePreviewTicks;
                }
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)posX, (float)posY, (float)-500.0f);
                GlStateManager.scalef((float)(-scale), (float)scale, (float)scale);
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                float f = this.creaturePreviewEntity.field_70761_aq;
                float f1 = this.creaturePreviewEntity.field_70177_z;
                float f2 = this.creaturePreviewEntity.field_70125_A;
                float f3 = this.creaturePreviewEntity.field_70758_at;
                float f4 = this.creaturePreviewEntity.field_70759_as;
                GlStateManager.rotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                RenderHelper.func_74519_b();
                GlStateManager.rotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)(-((float)Math.atan(lookY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                this.creaturePreviewEntity.field_70761_aq = (float)Math.atan(lookX / 40.0f) * 20.0f;
                this.creaturePreviewEntity.field_70177_z = (float)Math.atan(lookX / 40.0f) * 40.0f;
                this.creaturePreviewEntity.field_70125_A = -((float)Math.atan(lookY / 40.0f)) * 20.0f;
                this.creaturePreviewEntity.field_70759_as = this.creaturePreviewEntity.field_70177_z;
                this.creaturePreviewEntity.field_70758_at = this.creaturePreviewEntity.field_70177_z;
                GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.0f);
                EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
                renderManager.func_178631_a(180.0f);
                renderManager.func_178633_a(false);
                renderManager.func_188391_a((Entity)this.creaturePreviewEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, true);
                renderManager.func_178633_a(true);
                this.creaturePreviewEntity.field_70761_aq = f;
                this.creaturePreviewEntity.field_70177_z = f1;
                this.creaturePreviewEntity.field_70125_A = f2;
                this.creaturePreviewEntity.field_70758_at = f3;
                this.creaturePreviewEntity.field_70759_as = f4;
                GlStateManager.popMatrix();
                RenderHelper.func_74518_a();
                GlStateManager.disableRescaleNormal();
                GlStateManager.activeTexture((int)GLX.GL_TEXTURE1);
                GlStateManager.disableTexture();
                GlStateManager.activeTexture((int)GLX.GL_TEXTURE0);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "An exception occurred when trying to preview a creature in the Beastiary.");
            e.printStackTrace();
        }
    }

    public int getDisplaySubspecies(CreatureInfo creatureInfo) {
        return this.playerExt.selectedSubspecies;
    }

    public void playCreatureSelectSound(CreatureInfo creatureInfo) {
        this.player.func_130014_f_().func_184148_a(this.player, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, ObjectManager.getSound(creatureInfo.getName() + "_say"), SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    public void onCreateDisplayEntity(CreatureInfo creatureInfo, LivingEntity entity) {
    }

    public static enum Page {
        INDEX(0),
        CREATURES(1),
        PETS(2),
        SUMMONING(3),
        ELEMENTS(4);

        public byte id;

        private Page(byte i) {
            this.id = i;
        }
    }
}

