/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.client.gui.BaseScreen;
import com.lycanitesmobs.client.gui.buttons.ButtonBase;
import com.lycanitesmobs.client.gui.buttons.CreatureButton;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.network.MessageSummonSetSelection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;

public class MinionSelectionOverlay
extends BaseScreen {
    public PlayerEntity player;
    public ExtendedPlayer playerExt;
    int centerX;
    int centerY;
    int windowWidth;
    int windowHeight;
    int windowX;
    int windowY;

    public MinionSelectionOverlay(PlayerEntity player) {
        super((ITextComponent)new TranslationTextComponent("gui.minion.selection", new Object[0]));
        this.player = player;
        this.playerExt = ExtendedPlayer.getForPlayer(player);
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void init() {
        super.init();
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        this.windowWidth = 256;
        this.windowHeight = 256;
        this.windowX = this.centerX;
        this.windowY = this.centerY;
    }

    @Override
    protected void initWidgets() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int buttonWidth = 32;
        int buttonHeight = 32;
        int buttonX = this.centerX - Math.round(buttonWidth / 2);
        int buttonY = this.centerY - Math.round(buttonHeight / 2);
        int offset = 32;
        CreatureInfo creatureInfo = this.playerExt.getSummonSet(1).getCreatureInfo();
        CreatureButton button = new CreatureButton(1, buttonX, buttonY - Math.round(offset * 2), buttonWidth, buttonHeight, "1", creatureInfo, this);
        this.addButton((Widget)button);
        creatureInfo = this.playerExt.getSummonSet(2).getCreatureInfo();
        button = new CreatureButton(2, buttonX + Math.round(offset * 2), buttonY - Math.round((float)offset * 0.5f), buttonWidth, buttonHeight, "2", creatureInfo, this);
        this.addButton((Widget)button);
        creatureInfo = this.playerExt.getSummonSet(3).getCreatureInfo();
        button = new CreatureButton(3, buttonX + Math.round(offset * 1), buttonY + Math.round((float)offset * 1.75f), buttonWidth, buttonHeight, "3", creatureInfo, this);
        this.addButton((Widget)button);
        creatureInfo = this.playerExt.getSummonSet(4).getCreatureInfo();
        button = new CreatureButton(4, buttonX - Math.round(offset * 1), buttonY + Math.round((float)offset * 1.75f), buttonWidth, buttonHeight, "4", creatureInfo, this);
        this.addButton((Widget)button);
        creatureInfo = this.playerExt.getSummonSet(5).getCreatureInfo();
        button = new CreatureButton(5, buttonX - Math.round(offset * 2), buttonY - Math.round((float)offset * 0.5f), buttonWidth, buttonHeight, "5", creatureInfo, this);
        this.addButton((Widget)button);
    }

    @Override
    protected void renderForeground(int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    protected void renderWidgets(int mouseX, int mouseY, float partialTicks) {
        for (Object buttonObj : this.buttons) {
            if (!(buttonObj instanceof ButtonBase)) continue;
            ButtonBase button = (ButtonBase)((Object)buttonObj);
            button.visible = this.playerExt.getSummonSet(button.buttonId).isUseable();
            button.active = button.buttonId != this.playerExt.selectedSummonSet;
        }
    }

    @Override
    protected void renderBackground(int mouseX, int mouseY, float partialTicks) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TextureManager.getTexture("GUIMinion"));
    }

    @Override
    public void actionPerformed(int buttonId) {
        this.playerExt.setSelectedSummonSet(buttonId);
        MessageSummonSetSelection message = new MessageSummonSetSelection(this.playerExt);
        LycanitesMobs.packetHandler.sendToServer(message);
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        if (par2 == 1 || par2 == Minecraft.func_71410_x().field_71474_y.field_151445_Q.getKey().func_197937_c()) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
        return super.keyPressed(par1, par2, par3);
    }
}

