/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.client.gui.BaseContainerScreen;
import com.lycanitesmobs.client.gui.buttons.ButtonBase;
import com.lycanitesmobs.core.container.BaseContainer;
import com.lycanitesmobs.core.container.CreatureContainer;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.inventory.InventoryCreature;
import com.lycanitesmobs.core.network.MessageEntityGUICommand;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;

public class CreatureInventoryScreen
extends BaseContainerScreen<CreatureContainer> {
    public BaseCreatureEntity creature;
    public InventoryCreature creatureInventory;

    public CreatureInventoryScreen(CreatureContainer container, PlayerInventory playerInventory, ITextComponent name) {
        super(container, playerInventory, name);
        this.creature = container.creature;
        this.creatureInventory = container.creature.inventory;
    }

    @Override
    public void init() {
        super.init();
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    @Override
    protected void initWidgets() {
        int backX = (this.width - this.field_146999_f) / 2;
        int backY = (this.height - this.field_147000_g) / 2;
        if (!(this.creature instanceof TameableCreatureEntity)) {
            return;
        }
        TameableCreatureEntity pet = (TameableCreatureEntity)this.creature;
        if (!pet.petControlsEnabled()) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int buttonSpacing = 2;
        int buttonWidth = 128;
        int buttonHeight = 20;
        int buttonX = backX + this.field_146999_f;
        int buttonY = backY;
        String buttonText = new TranslationTextComponent("gui.pet.follow", new Object[0]).func_150254_d();
        ButtonBase button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.FOLLOW.id, buttonX + buttonSpacing, buttonY += buttonSpacing, buttonWidth, buttonHeight, buttonText, this);
        if (pet.isFollowing() && !pet.isSitting()) {
            button.active = false;
        }
        this.addButton((Widget)button);
        buttonText = new TranslationTextComponent("gui.pet.wander", new Object[0]).func_150254_d();
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.WANDER.id, buttonX + buttonSpacing, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, buttonText, this);
        if (!pet.isFollowing() && !pet.isSitting()) {
            button.active = false;
        }
        this.addButton((Widget)button);
        buttonText = new TranslationTextComponent("gui.pet.sit", new Object[0]).func_150254_d();
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.SIT.id, buttonX + buttonSpacing, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, buttonText, this);
        if (!pet.isFollowing() && pet.isSitting()) {
            button.active = false;
        }
        this.addButton((Widget)button);
        buttonText = new TranslationTextComponent("gui.pet.passive", new Object[0]).func_150254_d();
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.PASSIVE.id, buttonX + buttonSpacing, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, buttonText, this);
        if (pet.isPassive()) {
            button.active = false;
        }
        this.addButton((Widget)button);
        buttonText = new TranslationTextComponent("gui.pet.defensive", new Object[0]).func_150254_d();
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.DEFENSIVE.id, buttonX + buttonSpacing, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, buttonText, this);
        if (!(pet.isPassive() || pet.isAssisting() || pet.func_213398_dR())) {
            button.active = false;
        }
        this.addButton((Widget)button);
        buttonText = new TranslationTextComponent("gui.pet.assist", new Object[0]).func_150254_d();
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.ASSIST.id, buttonX + buttonSpacing, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, buttonText, this);
        if (!pet.isPassive() && pet.isAssisting() && !pet.func_213398_dR()) {
            button.active = false;
        }
        this.addButton((Widget)button);
        buttonText = new TranslationTextComponent("gui.pet.aggressive", new Object[0]).func_150254_d();
        button = new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.AGGRESSIVE.id, buttonX + buttonSpacing, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, buttonText, this);
        if (!pet.isPassive() && pet.func_213398_dR()) {
            button.active = false;
        }
        this.addButton((Widget)button);
        buttonText = new TranslationTextComponent("gui.pet.pvp", new Object[0]).func_150258_a(": ").func_150257_a((ITextComponent)(pet.isPVP() ? new TranslationTextComponent("common.yes", new Object[0]) : new TranslationTextComponent("common.no", new Object[0]))).func_150254_d();
        this.addButton((Widget)new ButtonBase(BaseCreatureEntity.PET_COMMAND_ID.PVP.id, buttonX + buttonSpacing, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, buttonText, this));
    }

    @Override
    protected void renderForeground(int mouseX, int mouseY, float partialTicks) {
        this.fontRenderer.func_211126_b(this.creatureInventory.getName(), 8.0f, 6.0f, 0x404040);
        this.fontRenderer.func_211126_b(this.field_213127_e.func_200200_C_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    @Override
    protected void renderBackground(int mouseX, int mouseY, float partialTicks) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TextureManager.getTexture("GUIInventoryCreature"));
        this.field_146999_f = 176;
        this.field_147000_g = 166;
        int backX = (this.width - this.field_146999_f) / 2;
        int backY = (this.height - this.field_147000_g) / 2;
        this.drawTexturedModalRect(backX, backY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawFrames(backX, backY, mouseX, mouseY);
        this.drawHealth(backX, backY);
        this.drawSlots(backX, backY);
    }

    protected void drawFrames(int backX, int backY, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TextureManager.getTexture("GUIInventoryCreature"));
        int statusWidth = 90;
        int statusHeight = 54;
        this.drawTexturedModalRect(backX + 79, backY + 17, 0, 256 - statusHeight, statusWidth, statusHeight);
        int creatureWidth = 54;
        int creatureHeight = 54;
        this.drawTexturedModalRect(backX - creatureWidth + 1, backY + 17, statusWidth, 256 - creatureHeight, creatureWidth, creatureHeight);
        InventoryScreen.func_147046_a((int)(backX + 26 - creatureWidth + 1), (int)(backY + 60), (int)17, (float)((float)backX - (float)mouseX), (float)((float)backY - (float)mouseY), (LivingEntity)this.creature);
    }

    protected void drawHealth(int backX, int backY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TextureManager.getTexture("GUIInventoryCreature"));
        int barWidth = 80;
        int barHeight = 11;
        int barX = backX + 91;
        int barY = backY + 5;
        int barU = 144;
        int barV = 256 - barHeight * 2;
        this.drawTexturedModalRect(barX, barY, barU, barV, barWidth, barHeight);
        barWidth = Math.round((float)barWidth * (this.creature.func_110143_aJ() / this.creature.func_110138_aP()));
        this.drawTexturedModalRect(barX, barY, barU, barV += barHeight, barWidth, barHeight);
    }

    protected void drawSlots(int backX, int backY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TextureManager.getTexture("GUIInventoryCreature"));
        BaseContainer container = (BaseContainer)this.func_212873_a_();
        List creatureSlots = container.field_75151_b.subList(container.specialStart, container.inventoryFinish + 1);
        int slotWidth = 18;
        int slotHeight = 18;
        int slotU = 238;
        int slotVBase = 0;
        for (Slot creatureSlot : creatureSlots) {
            int slotX = backX + creatureSlot.field_75223_e - 1;
            int slotY = backY + creatureSlot.field_75221_f - 1;
            int slotV = slotVBase;
            String slotType = this.creatureInventory.getTypeFromSlot(creatureSlot.getSlotIndex());
            if (slotType != null) {
                if (slotType.equals("saddle")) {
                    slotV += slotHeight;
                } else if (slotType.equals("bag")) {
                    slotV += slotHeight * 2;
                } else if (slotType.equals("chest")) {
                    slotV += slotHeight * 3;
                }
            }
            this.drawTexturedModalRect(slotX, slotY, slotU, slotV, slotWidth, slotHeight);
        }
    }

    @Override
    public void actionPerformed(int buttonId) {
        MessageEntityGUICommand message = new MessageEntityGUICommand(buttonId, (Entity)this.creature);
        LycanitesMobs.packetHandler.sendToServer(message);
    }
}

