/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.gui.buttons.ButtonBase;
import com.mojang.blaze3d.platform.GlStateManager;
import java.net.URI;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;

public abstract class BaseScreen
extends Screen
implements Button.IPressable {
    public MainWindow scaledResolution;
    public float zLevel = 0.0f;

    public BaseScreen(ITextComponent screenName) {
        super(screenName);
    }

    public void init(Minecraft minecraft, int width, int height) {
        this.minecraft = minecraft;
        super.init(minecraft, width, height);
        this.initWidgets();
    }

    protected void init() {
        super.init();
    }

    protected abstract void initWidgets();

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(mouseX, mouseY, partialTicks);
        this.renderWidgets(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
        this.renderForeground(mouseX, mouseY, partialTicks);
    }

    protected abstract void renderBackground(int var1, int var2, float var3);

    protected void renderWidgets(int mouseX, int mouseY, float partialTicks) {
    }

    protected abstract void renderForeground(int var1, int var2, float var3);

    public void onPress(Button guiButton) {
        if (!(guiButton instanceof ButtonBase)) {
            return;
        }
        this.actionPerformed(((ButtonBase)guiButton).buttonId);
    }

    public abstract void actionPerformed(int var1);

    public FontRenderer getFontRenderer() {
        return ClientManager.getInstance().getFontRenderer();
    }

    public int getScaledX(float x) {
        float scaledWidth;
        if (this.scaledResolution == null) {
            this.scaledResolution = this.minecraft.field_195558_d;
        }
        float targetAspect = 0.5625f;
        float scaledHeight = this.scaledResolution.func_198087_p();
        float currentAspect = scaledHeight * x / ((scaledWidth = (float)this.scaledResolution.func_198107_o()) * x);
        if (currentAspect < targetAspect) {
            scaledWidth = scaledHeight + scaledHeight * targetAspect;
        } else if (currentAspect > targetAspect) {
            scaledHeight = scaledWidth + scaledWidth * targetAspect;
        }
        float guiWidth = scaledWidth * x;
        return Math.round(Math.max(x, guiWidth));
    }

    public int getScaledY(float y) {
        float baseHeight = Math.round((float)this.getScaledX(y) * 0.5625f);
        return Math.round(baseHeight * y);
    }

    protected void openURI(URI uri) {
        try {
            Util.func_110647_a().func_195642_a(uri);
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "Unable to open link: " + uri.toString());
            e.printStackTrace();
        }
    }

    public void drawSplitString(String str, int x, int y, int wrapWidth, int textColor, boolean shadow) {
        if (shadow) {
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.0f);
            this.getFontRenderer().func_78279_b(str, x, y, wrapWidth, 0x444444);
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)0.0f);
        }
        this.getFontRenderer().func_78279_b(str, x, y, wrapWidth, textColor);
    }

    public void drawTexture(ResourceLocation texture, float x, float y, float z, float u, float v, float width, float height) {
        GlStateManager.enableBlend();
        GlStateManager.disableDepthTest();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableAlphaTest();
        this.getMinecraft().func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a(0.0, (double)v).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a((double)u, (double)v).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a((double)u, 0.0).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableAlphaTest();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableDepthTest();
        GlStateManager.disableBlend();
    }

    public void drawTexturedTiled(ResourceLocation texture, float x, float y, float z, float u, float v, float width, float height, float resolution) {
        float scaleX;
        GlStateManager.enableBlend();
        GlStateManager.disableDepthTest();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableAlphaTest();
        this.getMinecraft().func_110434_K().func_110577_a(texture);
        float scaleY = scaleX = 0.00390625f * resolution;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(x + 0.0f), (double)(y + height), (double)z).func_187315_a((double)((u + 0.0f) * scaleX), (double)((v + height) * scaleY)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a((double)((u + width) * scaleX), (double)((v + height) * scaleY)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + 0.0f), (double)z).func_187315_a((double)((u + width) * scaleX), (double)((v + 0.0f) * scaleY)).func_181675_d();
        buffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)z).func_187315_a((double)((u + 0.0f) * scaleX), (double)((v + 0.0f) * scaleY)).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawBar(ResourceLocation texture, int x, int y, float z, float width, float height, int segments, int segmentLimit) {
        boolean reverse;
        boolean bl = reverse = segmentLimit < 0;
        if (reverse) {
            segmentLimit = -segmentLimit;
        }
        for (int i = 0; i < segments; ++i) {
            int currentSegment = i;
            if (reverse) {
                currentSegment = segmentLimit - i - 1;
            }
            this.drawTexture(texture, (float)x + width * (float)currentSegment, y, z, 1.0f, 1.0f, width, height);
        }
    }

    @Deprecated
    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        this.drawTexturedModalRect(x, y, u, v, width, height, 1);
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, int resolution) {
        float scaleX;
        float scaleY = scaleX = 0.00390625f * (float)resolution;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + height), (double)this.zLevel).func_187315_a((double)((float)(u + 0) * scaleX), (double)((float)(v + height) * scaleY)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.zLevel).func_187315_a((double)((float)(u + width) * scaleX), (double)((float)(v + height) * scaleY)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0), (double)this.zLevel).func_187315_a((double)((float)(u + width) * scaleX), (double)((float)(v + 0) * scaleY)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.zLevel).func_187315_a((double)((float)(u + 0) * scaleX), (double)((float)(v + 0) * scaleY)).func_181675_d();
        tessellator.func_78381_a();
    }
}

