/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.ModelCreatureBase;
import com.lycanitesmobs.client.model.ModelEquipment;
import com.lycanitesmobs.client.model.ModelEquipmentPart;
import com.lycanitesmobs.client.model.ModelProjectileBase;
import com.lycanitesmobs.client.model.projectile.ModelAetherwave;
import com.lycanitesmobs.client.model.projectile.ModelChaosOrb;
import com.lycanitesmobs.client.model.projectile.ModelCrystalShard;
import com.lycanitesmobs.client.model.projectile.ModelLightBall;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.item.equipment.EquipmentPartManager;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ModelManager {
    private static ModelManager INSTANCE;
    public Map<CreatureInfo, ModelCreatureBase> creatureModels = new HashMap<CreatureInfo, ModelCreatureBase>();
    public Map<Subspecies, ModelCreatureBase> creatureSubspeciesModels = new HashMap<Subspecies, ModelCreatureBase>();
    public Map<ProjectileInfo, ModelProjectileBase> projectileModels = new HashMap<ProjectileInfo, ModelProjectileBase>();
    public Map<String, ModelProjectileBase> oldProjectileModels = new HashMap<String, ModelProjectileBase>();
    public ModelEquipment equipmentModel;
    public Map<ItemEquipmentPart, ModelEquipmentPart> equipmentPartModels = new HashMap<ItemEquipmentPart, ModelEquipmentPart>();

    public static ModelManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ModelManager();
        }
        return INSTANCE;
    }

    public void createModels() {
        try {
            for (CreatureInfo creatureInfo : CreatureManager.getInstance().creatures.values()) {
                if (creatureInfo.dummy) continue;
                this.creatureModels.put(creatureInfo, (ModelCreatureBase)((Object)Class.forName(creatureInfo.modelClassName).getConstructor(new Class[0]).newInstance(new Object[0])));
                for (Subspecies subspecies : creatureInfo.subspecies.values()) {
                    if (subspecies.modelClassName == null) continue;
                    this.creatureSubspeciesModels.put(subspecies, (ModelCreatureBase)((Object)Class.forName(subspecies.modelClassName).getConstructor(new Class[0]).newInstance(new Object[0])));
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LycanitesMobs.logError("Unable to load a Creature model, check that the model class name(s) is correct in the associated creature json (check subspecies models if any too).");
            throw new RuntimeException(e);
        }
        try {
            for (ProjectileInfo projectileInfo : ProjectileManager.getInstance().projectiles.values()) {
                if (projectileInfo.modelClassName == null) continue;
                this.projectileModels.put(projectileInfo, (ModelProjectileBase)((Object)Class.forName(projectileInfo.modelClassName).getConstructor(new Class[0]).newInstance(new Object[0])));
            }
            this.oldProjectileModels.put("lightball", new ModelLightBall());
            this.oldProjectileModels.put("crystalshard", new ModelCrystalShard());
            this.oldProjectileModels.put("aetherwave", new ModelAetherwave());
            this.oldProjectileModels.put("chaosorb", new ModelChaosOrb());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LycanitesMobs.logError("Unable to load a Projectile model, check that the model class name is correct in the associated projectile json.");
            throw new RuntimeException(e);
        }
        this.equipmentModel = new ModelEquipment();
        for (ItemEquipmentPart equipmentPart : EquipmentPartManager.getInstance().equipmentParts.values()) {
            this.equipmentPartModels.put(equipmentPart, new ModelEquipmentPart(equipmentPart));
        }
    }

    public ModelCreatureBase getCreatureModel(CreatureInfo creatureInfo, @Nullable Subspecies subspecies) {
        if (subspecies != null && this.creatureSubspeciesModels.containsKey(subspecies)) {
            return this.creatureSubspeciesModels.get(subspecies);
        }
        if (this.creatureModels.containsKey(creatureInfo)) {
            return this.creatureModels.get(creatureInfo);
        }
        return null;
    }

    public ModelProjectileBase getProjectileModel(ProjectileInfo projectileInfo) {
        if (this.projectileModels.containsKey(projectileInfo)) {
            return this.projectileModels.get(projectileInfo);
        }
        return null;
    }

    @Deprecated
    public ModelProjectileBase getOldProjectileModel(String projectileName) {
        if (this.oldProjectileModels.containsKey(projectileName)) {
            return this.oldProjectileModels.get(projectileName);
        }
        return null;
    }

    public ModelEquipment getEquipmentModel() {
        return this.equipmentModel;
    }

    public ModelEquipmentPart getEquipmentPartModel(ItemEquipmentPart equipmentPart) {
        if (this.equipmentPartModels.containsKey((Object)equipmentPart)) {
            return this.equipmentPartModels.get((Object)equipmentPart);
        }
        return null;
    }
}

