/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util.pooled.cache;

import io.github.cadiboo.nocubes.util.pooled.cache.XYZCache;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.IFluidState;

public final class StateCache
extends XYZCache
implements AutoCloseable {
    private static final ThreadLocal<StateCache> POOL = ThreadLocal.withInitial(() -> new StateCache(0, 0, 0, 0, 0, 0));
    @Nonnull
    private BlockState[] blockStates;
    @Nonnull
    private IFluidState[] fluidStates;
    private boolean inUse;

    private StateCache(int startPaddingX, int startPaddingY, int startPaddingZ, int sizeX, int sizeY, int sizeZ) {
        super(startPaddingX, startPaddingY, startPaddingZ, sizeX, sizeY, sizeZ);
        this.blockStates = new BlockState[sizeX * sizeY * sizeZ];
        this.fluidStates = new IFluidState[sizeX * sizeY * sizeZ];
        this.inUse = false;
    }

    @Nonnull
    public static StateCache retain(int startPaddingX, int startPaddingY, int startPaddingZ, int sizeX, int sizeY, int sizeZ) {
        StateCache pooled = POOL.get();
        if (pooled.inUse) {
            throw new IllegalStateException("StateCache is already in use!");
        }
        pooled.inUse = true;
        pooled.startPaddingX = startPaddingX;
        pooled.startPaddingY = startPaddingY;
        pooled.startPaddingZ = startPaddingZ;
        if (pooled.sizeX == sizeX && pooled.sizeY == sizeY && pooled.sizeZ == sizeZ) {
            return pooled;
        }
        pooled.sizeX = sizeX;
        pooled.sizeY = sizeY;
        pooled.sizeZ = sizeZ;
        int size = sizeX * sizeY * sizeZ;
        if (pooled.blockStates.length < size || (float)pooled.blockStates.length > (float)size * 1.25f) {
            pooled.blockStates = new BlockState[size];
        }
        if (pooled.fluidStates.length < size || (float)pooled.fluidStates.length > (float)size * 1.25f) {
            pooled.fluidStates = new IFluidState[size];
        }
        return pooled;
    }

    @Nonnull
    public BlockState[] getBlockStates() {
        return this.blockStates;
    }

    @Nonnull
    public IFluidState[] getFluidStates() {
        return this.fluidStates;
    }

    @Override
    public void close() {
        this.inUse = false;
    }
}

