/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util.pooled;

import java.util.ArrayList;
import javax.annotation.Nonnull;

public final class Vec3
implements AutoCloseable {
    private static final ArrayList<Vec3> POOL = new ArrayList();
    public double x;
    public double y;
    public double z;

    private Vec3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Vec3 retain(double x, double y, double z) {
        ArrayList<Vec3> arrayList = POOL;
        synchronized (arrayList) {
            Vec3 pooled;
            if (!POOL.isEmpty() && (pooled = POOL.remove(POOL.size() - 1)) != null) {
                pooled.x = x;
                pooled.y = y;
                pooled.z = z;
                return pooled;
            }
        }
        return new Vec3(x, y, z);
    }

    @Nonnull
    public static Vec3 retain(double[] vertexAsArray) {
        return Vec3.retain(vertexAsArray[0], vertexAsArray[1], vertexAsArray[2]);
    }

    @Nonnull
    public static Vec3 retain(float[] vertexAsArray) {
        return Vec3.retain(vertexAsArray[0], vertexAsArray[1], vertexAsArray[2]);
    }

    public Vec3 addOffset(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vec3 copy() {
        return new Vec3(this.x, this.y, this.z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<Vec3> arrayList = POOL;
        synchronized (arrayList) {
            POOL.add(this);
        }
    }
}

