/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import io.github.cadiboo.nocubes.NoCubes;
import javax.annotation.Nonnull;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;

public interface Proxy {
    public void replaceFluidRenderer();

    default public void preloadClasses() {
        this.preloadClass("net.minecraft.block.BlockState", "BlockState");
        this.preloadClass("net.minecraft.world.IWorldReader", "IWorldReader");
        this.preloadClass("net.minecraft.world.World", "World");
    }

    default public void preloadClass(@Nonnull String qualifiedName, @Nonnull String simpleName) {
        try {
            NoCubes.LOGGER.info("Loading class \"" + simpleName + "\"...");
            ClassLoader classLoader = this.getClass().getClassLoader();
            long startTime = System.nanoTime();
            Class.forName(qualifiedName, false, classLoader);
            NoCubes.LOGGER.info("Loaded class \"" + simpleName + "\" in " + (System.nanoTime() - startTime) + " nano seconds");
            NoCubes.LOGGER.info("Initialising class \"" + simpleName + "\"...");
            Class.forName(qualifiedName, true, classLoader);
            NoCubes.LOGGER.info("Initialised \"" + simpleName + "\"");
        }
        catch (ClassNotFoundException e) {
            CrashReport crashReport = new CrashReport("Failed to load class \"" + simpleName + "\". This should not be possible!", (Throwable)e);
            crashReport.func_85058_a("Loading class");
            throw new ReportedException(crashReport);
        }
    }
}

