/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import java.util.HashMap;

public final class ModProfiler
implements AutoCloseable {
    public static final HashMap<Thread, ModProfiler> PROFILERS = new HashMap();
    private static final ThreadLocal<ModProfiler> PROFILER = ThreadLocal.withInitial(() -> {
        ModProfiler profiler = new ModProfiler();
        PROFILERS.put(Thread.currentThread(), profiler);
        return profiler;
    });
    public static boolean profilersEnabled = false;
    private int virtualSections = 0;
    private int startedSections = 0;

    public ModProfiler() {
        if (profilersEnabled) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableProfiling() {
        profilersEnabled = true;
        HashMap<Thread, ModProfiler> hashMap = PROFILERS;
        synchronized (hashMap) {
            for (ModProfiler modProfiler : PROFILERS.values()) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableProfiling() {
        profilersEnabled = false;
        HashMap<Thread, ModProfiler> hashMap = PROFILERS;
        synchronized (hashMap) {
            for (ModProfiler modProfiler : PROFILERS.values()) {
            }
        }
    }

    public static ModProfiler get() {
        return PROFILER.get();
    }

    public ModProfiler start(String name) {
        if (this.startedSections == this.virtualSections++ && profilersEnabled) {
            ++this.startedSections;
        }
        return this;
    }

    public void end() {
        if (this.startedSections == this.virtualSections--) {
            --this.startedSections;
        }
    }

    @Override
    public void close() {
        this.end();
    }
}

