/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.pooled.cache.DensityCache;
import io.github.cadiboo.nocubes.util.pooled.cache.SmoothableCache;
import io.github.cadiboo.nocubes.util.pooled.cache.StateCache;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;

public final class CacheUtil {
    private static final IFluidState[] NULL_FLUID_STATES = new IFluidState[8000];
    private static final ThreadLocal<IFluidState[]> EXTEND_FLUID_STATES_THREAD_LOCAL = ThreadLocal.withInitial(() -> new IFluidState[0]);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StateCache generateStateCache(int fromX, int fromY, int fromZ, int toX, int toY, int toZ, int startPaddingX, int startPaddingY, int startPaddingZ, @Nonnull IWorldReader cache, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        int cacheSizeX = Math.abs(toX - fromX);
        int cacheSizeY = Math.abs(toY - fromY);
        int cacheSizeZ = Math.abs(toZ - fromZ);
        StateCache stateCache = StateCache.retain(startPaddingX, startPaddingY, startPaddingZ, cacheSizeX, cacheSizeY, cacheSizeZ);
        try (ModProfiler ignored = ModProfiler.get().start("generate stateCache");){
            BlockState[] blockStates = stateCache.getBlockStates();
            IFluidState[] fluidStates = stateCache.getFluidStates();
            CacheUtil.fillStateCache(fromX, fromY, fromZ, cacheSizeX, cacheSizeY, cacheSizeZ, cache, pooledMutableBlockPos, blockStates, fluidStates);
            CacheUtil.calculateStateCacheExtendedFluids(cacheSizeX, cacheSizeY, cacheSizeZ, blockStates, fluidStates, stateCache, stateCache.sizeX, stateCache.sizeY);
            StateCache stateCache2 = stateCache;
            return stateCache2;
        }
        catch (Exception e) {
            stateCache.close();
            throw e;
        }
    }

    private static void calculateStateCacheExtendedFluids(int cacheSizeX, int cacheSizeY, int cacheSizeZ, @Nonnull BlockState[] blockStates, @Nonnull IFluidState[] fluidStates, @Nonnull StateCache stateCache, int stateCacheSizeX, int stateCacheSizeY) {
        int extend = Config.extendFluidsRange.getRange();
        if (extend < 1) {
            return;
        }
        int fluidStatesLength = fluidStates.length;
        Object[] extendedFluidStates = EXTEND_FLUID_STATES_THREAD_LOCAL.get();
        if (extendedFluidStates.length < fluidStatesLength) {
            extendedFluidStates = new IFluidState[fluidStatesLength];
            EXTEND_FLUID_STATES_THREAD_LOCAL.set((IFluidState[])extendedFluidStates);
        } else if (fluidStatesLength > 16384) {
            Arrays.fill(extendedFluidStates, null);
        } else {
            System.arraycopy(NULL_FLUID_STATES, 0, extendedFluidStates, 0, fluidStatesLength);
        }
        int index = 0;
        for (int z = 0; z < cacheSizeZ; ++z) {
            for (int y = 0; y < cacheSizeY; ++y) {
                int x = 0;
                while (x < cacheSizeX) {
                    if (IsSmoothable.TERRAIN_SMOOTHABLE.apply(blockStates[index])) {
                        block3: for (int xOffset = -extend; xOffset <= extend; ++xOffset) {
                            for (int zOffset = -extend; zOffset <= extend; ++zOffset) {
                                IFluidState state1;
                                if (xOffset == 0 && zOffset == 0) continue;
                                int checkX = x + xOffset;
                                int checkZ = z + zOffset;
                                if (checkX < 0 || checkX >= cacheSizeX || checkZ < 0 || checkZ >= cacheSizeZ || !(state1 = fluidStates[stateCache.getIndex(checkX, y, checkZ, stateCacheSizeX, stateCacheSizeY)]).func_206889_d()) continue;
                                extendedFluidStates[index] = state1;
                                break block3;
                            }
                        }
                    }
                    ++x;
                    ++index;
                }
            }
        }
        for (int i = 0; i < fluidStatesLength; ++i) {
            Object extendedFluidState = extendedFluidStates[i];
            if (extendedFluidState == null) continue;
            fluidStates[i] = extendedFluidState;
        }
    }

    private static void fillStateCache(int fromX, int fromY, int fromZ, int cacheSizeX, int cacheSizeY, int cacheSizeZ, @Nonnull IWorldReader cache, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos, BlockState[] blockStates, IFluidState[] fluidStates) {
        int cx = fromX >> 4;
        int cz = fromZ >> 4;
        IChunk currentChunk = cache.func_212866_a_(cx, cz);
        int index = 0;
        for (int z = 0; z < cacheSizeZ; ++z) {
            for (int y = 0; y < cacheSizeY; ++y) {
                int x = 0;
                while (x < cacheSizeX) {
                    BlockState blockState;
                    int checkX = fromX + x;
                    int checkZ = fromZ + z;
                    boolean changed = false;
                    if (cx != checkX >> 4) {
                        cx = checkX >> 4;
                        changed = true;
                    }
                    if (cz != checkZ >> 4) {
                        cz = checkZ >> 4;
                        changed = true;
                    }
                    if (changed) {
                        currentChunk = cache.func_212866_a_(cx, cz);
                    }
                    pooledMutableBlockPos.func_181079_c(checkX, fromY + y, checkZ);
                    blockStates[index] = blockState = currentChunk.func_180495_p((BlockPos)pooledMutableBlockPos);
                    fluidStates[index] = blockState.func_204520_s();
                    ++x;
                    ++index;
                }
            }
        }
    }

    public static SmoothableCache generateSmoothableCache(int fromX, int fromY, int fromZ, int toX, int toY, int toZ, int startPaddingX, int startPaddingY, int startPaddingZ, @Nonnull StateCache stateCache, @Nonnull IsSmoothable isStateSmoothable) {
        int cacheSizeX = Math.abs(toX - fromX);
        int cacheSizeY = Math.abs(toY - fromY);
        int cacheSizeZ = Math.abs(toZ - fromZ);
        try (ModProfiler ignored = ModProfiler.get().start("generate smoothableCache");){
            SmoothableCache smoothableCache = SmoothableCache.retain(startPaddingX, startPaddingY, startPaddingZ, cacheSizeX, cacheSizeY, cacheSizeZ);
            boolean[] smoothableCacheArray = smoothableCache.getSmoothableCache();
            int stateCacheSizeX = stateCache.sizeX;
            int stateCacheSizeY = stateCache.sizeY;
            int diffX = stateCache.startPaddingX - startPaddingX;
            int diffY = stateCache.startPaddingY - startPaddingY;
            int diffZ = stateCache.startPaddingZ - startPaddingZ;
            BlockState[] blockStateArray = stateCache.getBlockStates();
            int smoothableIndex = 0;
            for (int z = 0; z < cacheSizeZ; ++z) {
                for (int y = 0; y < cacheSizeY; ++y) {
                    int x = 0;
                    while (x < cacheSizeX) {
                        smoothableCacheArray[smoothableIndex] = isStateSmoothable.apply(blockStateArray[stateCache.getIndex(x + diffX, y + diffY, z + diffZ, stateCacheSizeX, stateCacheSizeY)]);
                        ++x;
                        ++smoothableIndex;
                    }
                }
            }
            SmoothableCache smoothableCache2 = smoothableCache;
            return smoothableCache2;
        }
    }

    public static DensityCache generateDensityCache(int fromX, int fromY, int fromZ, int toX, int toY, int toZ, int startPaddingX, int startPaddingY, int startPaddingZ, @Nonnull StateCache stateCache, @Nonnull SmoothableCache smoothableCache) {
        int cacheSizeX = Math.abs(toX - fromX);
        int cacheSizeY = Math.abs(toY - fromY);
        int cacheSizeZ = Math.abs(toZ - fromZ);
        try (ModProfiler ignored = ModProfiler.get().start("generate densityCache");){
            DensityCache densityCache = DensityCache.retain(startPaddingX, startPaddingY, startPaddingZ, cacheSizeX, cacheSizeY, cacheSizeZ);
            float[] densityCacheArray = densityCache.getDensityCache();
            int index = 0;
            for (int z = 0; z < cacheSizeZ; ++z) {
                for (int y = 0; y < cacheSizeY; ++y) {
                    int x = 0;
                    while (x < cacheSizeX) {
                        densityCacheArray[index] = CacheUtil.getBlockDensity(x, y, z, startPaddingX, startPaddingY, startPaddingZ, stateCache, smoothableCache);
                        ++x;
                        ++index;
                    }
                }
            }
            DensityCache densityCache2 = densityCache;
            return densityCache2;
        }
    }

    private static float getBlockDensity(int posX, int posY, int posZ, int densityCacheStartPaddingX, int densityCacheStartPaddingY, int densityCacheStartPaddingZ, @Nonnull StateCache stateCache, @Nonnull SmoothableCache smoothableCache) {
        int stateCacheDiffX = stateCache.startPaddingX - densityCacheStartPaddingX;
        int stateCacheDiffY = stateCache.startPaddingY - densityCacheStartPaddingY;
        int stateCacheDiffZ = stateCache.startPaddingZ - densityCacheStartPaddingZ;
        int stateCacheSizeX = stateCache.sizeX;
        int stateCacheSizeY = stateCache.sizeY;
        BlockState[] stateCacheArray = stateCache.getBlockStates();
        int smoothableCacheSizeX = smoothableCache.sizeX;
        int smoothableCacheSizeY = smoothableCache.sizeY;
        boolean[] smoothableCacheArray = smoothableCache.getSmoothableCache();
        float density = 0.0f;
        for (int zOffset = 0; zOffset < 2; ++zOffset) {
            for (int yOffset = 0; yOffset < 2; ++yOffset) {
                for (int xOffset = 0; xOffset < 2; ++xOffset) {
                    density += ModUtil.getIndividualBlockDensity(smoothableCacheArray[smoothableCache.getIndex(posX + xOffset, posY + yOffset, posZ + zOffset, smoothableCacheSizeX, smoothableCacheSizeY)], stateCacheArray[stateCache.getIndex(posX + xOffset + stateCacheDiffX, posY + yOffset + stateCacheDiffY, posZ + zOffset + stateCacheDiffZ, stateCacheSizeX, stateCacheSizeY)]);
                }
            }
        }
        return density;
    }
}

