/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mesh.generator;

import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.pooled.Face;
import io.github.cadiboo.nocubes.util.pooled.FaceList;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import io.github.cadiboo.nocubes.util.pooled.Vec3b;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public final class MarchingTetrahedra
implements MeshGenerator {
    private final byte[][] CUBE_VERTICES = new byte[][]{{0, 0, 0}, {1, 0, 0}, {1, 1, 0}, {0, 1, 0}, {0, 0, 1}, {1, 0, 1}, {1, 1, 1}, {0, 1, 1}};
    private final byte[][] TETRA_LIST = new byte[][]{{0, 2, 3, 7}, {0, 6, 2, 7}, {0, 4, 6, 7}, {0, 6, 1, 2}, {0, 1, 6, 4}, {5, 6, 1, 4}};

    @Override
    @Nonnull
    public HashMap<Vec3b, FaceList> generateChunk(@Nonnull float[] data, @Nonnull byte[] dims) {
        byte[][] cube_vertices = this.CUBE_VERTICES;
        byte[][] tetra_list = this.TETRA_LIST;
        byte[] x = new byte[]{0, 0, 0};
        short n = 0;
        float[] grid = new float[8];
        HashMap<Vec3b, FaceList> posToFaces = new HashMap<Vec3b, FaceList>();
        x[2] = 0;
        while (x[2] < dims[2] - 1) {
            x[1] = 0;
            while (x[1] < dims[1] - 1) {
                x[0] = 0;
                while (x[0] < dims[0] - 1) {
                    for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
                        grid[i] = data[n + cube_vertices[i][0] + dims[0] * (cube_vertices[i][1] + dims[1] * cube_vertices[i][2])];
                    }
                    FaceList faces = FaceList.retain();
                    block21: for (int i = 0; i < tetra_list.length; i = (int)((byte)(i + 1))) {
                        byte[] T = tetra_list[i];
                        byte triindex = 0;
                        if (grid[T[0]] < 0.0f) {
                            triindex = (byte)(triindex | 1);
                        }
                        if (grid[T[1]] < 0.0f) {
                            triindex = (byte)(triindex | 2);
                        }
                        if (grid[T[2]] < 0.0f) {
                            triindex = (byte)(triindex | 4);
                        }
                        if (grid[T[3]] < 0.0f) {
                            triindex = (byte)(triindex | 8);
                        }
                        switch (triindex) {
                            case 0: 
                            case 15: {
                                continue block21;
                            }
                            case 14: {
                                faces.add(Face.retain(this.interp(T[0], T[1], grid, x), this.interp(T[0], T[3], grid, x), this.interp(T[0], T[2], grid, x)));
                                continue block21;
                            }
                            case 1: {
                                faces.add(Face.retain(this.interp(T[0], T[1], grid, x), this.interp(T[0], T[2], grid, x), this.interp(T[0], T[3], grid, x)));
                                continue block21;
                            }
                            case 13: {
                                faces.add(Face.retain(this.interp(T[1], T[0], grid, x), this.interp(T[1], T[2], grid, x), this.interp(T[1], T[3], grid, x)));
                                continue block21;
                            }
                            case 2: {
                                faces.add(Face.retain(this.interp(T[1], T[0], grid, x), this.interp(T[1], T[3], grid, x), this.interp(T[1], T[2], grid, x)));
                                continue block21;
                            }
                            case 12: {
                                faces.add(Face.retain(this.interp(T[1], T[2], grid, x), this.interp(T[1], T[3], grid, x), this.interp(T[0], T[3], grid, x), this.interp(T[0], T[2], grid, x)));
                                continue block21;
                            }
                            case 3: {
                                faces.add(Face.retain(this.interp(T[1], T[2], grid, x), this.interp(T[0], T[2], grid, x), this.interp(T[0], T[3], grid, x), this.interp(T[1], T[3], grid, x)));
                                continue block21;
                            }
                            case 4: {
                                faces.add(Face.retain(this.interp(T[2], T[0], grid, x), this.interp(T[2], T[1], grid, x), this.interp(T[2], T[3], grid, x)));
                                continue block21;
                            }
                            case 11: {
                                faces.add(Face.retain(this.interp(T[2], T[0], grid, x), this.interp(T[2], T[3], grid, x), this.interp(T[2], T[1], grid, x)));
                                continue block21;
                            }
                            case 5: {
                                faces.add(Face.retain(this.interp(T[0], T[1], grid, x), this.interp(T[1], T[2], grid, x), this.interp(T[2], T[3], grid, x), this.interp(T[0], T[3], grid, x)));
                                continue block21;
                            }
                            case 10: {
                                faces.add(Face.retain(this.interp(T[0], T[1], grid, x), this.interp(T[0], T[3], grid, x), this.interp(T[2], T[3], grid, x), this.interp(T[1], T[2], grid, x)));
                                continue block21;
                            }
                            case 6: {
                                faces.add(Face.retain(this.interp(T[2], T[3], grid, x), this.interp(T[0], T[2], grid, x), this.interp(T[0], T[1], grid, x), this.interp(T[1], T[3], grid, x)));
                                continue block21;
                            }
                            case 9: {
                                faces.add(Face.retain(this.interp(T[2], T[3], grid, x), this.interp(T[1], T[3], grid, x), this.interp(T[0], T[1], grid, x), this.interp(T[0], T[2], grid, x)));
                                continue block21;
                            }
                            case 7: {
                                faces.add(Face.retain(this.interp(T[3], T[0], grid, x), this.interp(T[3], T[1], grid, x), this.interp(T[3], T[2], grid, x)));
                                continue block21;
                            }
                            case 8: {
                                faces.add(Face.retain(this.interp(T[3], T[0], grid, x), this.interp(T[3], T[2], grid, x), this.interp(T[3], T[1], grid, x)));
                            }
                        }
                    }
                    posToFaces.put(Vec3b.retain(x[0], x[1], x[2]), faces);
                    x[0] = (byte)(x[0] + 1);
                    n = (short)(n + 1);
                }
                x[1] = (byte)(x[1] + 1);
                n = (short)(n + 1);
            }
            x[2] = (byte)(x[2] + 1);
            n = (short)(n + dims[0]);
        }
        return posToFaces;
    }

    @Override
    @Nonnull
    public FaceList generateBlock(@Nonnull float[] data, @Nonnull byte[] dims) {
        FaceList faces = FaceList.retain();
        byte[][] cube_vertices = this.CUBE_VERTICES;
        byte[][] tetra_list = this.TETRA_LIST;
        byte[] x = new byte[]{0, 0, 0};
        short n = 0;
        float[] grid = new float[8];
        x[2] = 0;
        while (x[2] < dims[2] - 1) {
            x[1] = 0;
            while (x[1] < dims[1] - 1) {
                x[0] = 0;
                while (x[0] < dims[0] - 1) {
                    for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
                        grid[i] = data[n + cube_vertices[i][0] + dims[0] * (cube_vertices[i][1] + dims[1] * cube_vertices[i][2])];
                    }
                    block21: for (byte[] T : tetra_list) {
                        byte triindex = 0;
                        if (grid[T[0]] < 0.0f) {
                            triindex = (byte)(triindex | 1);
                        }
                        if (grid[T[1]] < 0.0f) {
                            triindex = (byte)(triindex | 2);
                        }
                        if (grid[T[2]] < 0.0f) {
                            triindex = (byte)(triindex | 4);
                        }
                        if (grid[T[3]] < 0.0f) {
                            triindex = (byte)(triindex | 8);
                        }
                        switch (triindex) {
                            case 0: 
                            case 15: {
                                continue block21;
                            }
                            case 14: {
                                faces.add(Face.retain(this.interp(T[0], T[1], grid, x), this.interp(T[0], T[3], grid, x), this.interp(T[0], T[2], grid, x)));
                                continue block21;
                            }
                            case 1: {
                                faces.add(Face.retain(this.interp(T[0], T[1], grid, x), this.interp(T[0], T[2], grid, x), this.interp(T[0], T[3], grid, x)));
                                continue block21;
                            }
                            case 13: {
                                faces.add(Face.retain(this.interp(T[1], T[0], grid, x), this.interp(T[1], T[2], grid, x), this.interp(T[1], T[3], grid, x)));
                                continue block21;
                            }
                            case 2: {
                                faces.add(Face.retain(this.interp(T[1], T[0], grid, x), this.interp(T[1], T[3], grid, x), this.interp(T[1], T[2], grid, x)));
                                continue block21;
                            }
                            case 12: {
                                faces.add(Face.retain(this.interp(T[1], T[2], grid, x), this.interp(T[1], T[3], grid, x), this.interp(T[0], T[3], grid, x), this.interp(T[0], T[2], grid, x)));
                                continue block21;
                            }
                            case 3: {
                                faces.add(Face.retain(this.interp(T[1], T[2], grid, x), this.interp(T[0], T[2], grid, x), this.interp(T[0], T[3], grid, x), this.interp(T[1], T[3], grid, x)));
                                continue block21;
                            }
                            case 4: {
                                faces.add(Face.retain(this.interp(T[2], T[0], grid, x), this.interp(T[2], T[1], grid, x), this.interp(T[2], T[3], grid, x)));
                                continue block21;
                            }
                            case 11: {
                                faces.add(Face.retain(this.interp(T[2], T[0], grid, x), this.interp(T[2], T[3], grid, x), this.interp(T[2], T[1], grid, x)));
                                continue block21;
                            }
                            case 5: {
                                faces.add(Face.retain(this.interp(T[0], T[1], grid, x), this.interp(T[1], T[2], grid, x), this.interp(T[2], T[3], grid, x), this.interp(T[0], T[3], grid, x)));
                                continue block21;
                            }
                            case 10: {
                                faces.add(Face.retain(this.interp(T[0], T[1], grid, x), this.interp(T[0], T[3], grid, x), this.interp(T[2], T[3], grid, x), this.interp(T[1], T[2], grid, x)));
                                continue block21;
                            }
                            case 6: {
                                faces.add(Face.retain(this.interp(T[2], T[3], grid, x), this.interp(T[0], T[2], grid, x), this.interp(T[0], T[1], grid, x), this.interp(T[1], T[3], grid, x)));
                                continue block21;
                            }
                            case 9: {
                                faces.add(Face.retain(this.interp(T[2], T[3], grid, x), this.interp(T[1], T[3], grid, x), this.interp(T[0], T[1], grid, x), this.interp(T[0], T[2], grid, x)));
                                continue block21;
                            }
                            case 7: {
                                faces.add(Face.retain(this.interp(T[3], T[0], grid, x), this.interp(T[3], T[1], grid, x), this.interp(T[3], T[2], grid, x)));
                                continue block21;
                            }
                            case 8: {
                                faces.add(Face.retain(this.interp(T[3], T[0], grid, x), this.interp(T[3], T[2], grid, x), this.interp(T[3], T[1], grid, x)));
                            }
                        }
                    }
                    x[0] = (byte)(x[0] + 1);
                    n = (short)(n + 1);
                }
                x[1] = (byte)(x[1] + 1);
                n = (short)(n + 1);
            }
            x[2] = (byte)(x[2] + 1);
            n = (short)(n + dims[0]);
        }
        return faces;
    }

    @Override
    @Nonnull
    public FaceList generateBlock(@Nonnull BlockPos pos, @Nonnull IBlockReader blockAccess, @Nonnull IsSmoothable isSmoothable) {
        try (BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            int i;
            FaceList faces = FaceList.retain();
            int posX = pos.func_177958_n();
            int posY = pos.func_177956_o();
            int posZ = pos.func_177952_p();
            byte relativePosX = (byte)(posX & 0xF);
            byte relativePosY = (byte)(posY & 0xF);
            byte relativePosZ = (byte)(posZ & 0xF);
            float[] data = this.generateScalarFieldData(posX, posY, posZ, posX + 2, posY + 2, posZ + 2, blockAccess, isSmoothable, pooledMutableBlockPos);
            byte[][] cube_vertices = this.CUBE_VERTICES;
            byte[][] tetra_list = this.TETRA_LIST;
            byte[] x = new byte[]{relativePosX, relativePosY, relativePosZ};
            byte n = 0;
            float[] grid = new float[8];
            for (i = 0; i < 8; i = (int)((byte)(i + 1))) {
                grid[i] = data[n + cube_vertices[i][0] + 2 * (cube_vertices[i][1] + 2 * cube_vertices[i][2])];
            }
            block27: for (i = 0; i < tetra_list.length; i = (int)((byte)(i + 1))) {
                byte[] T = tetra_list[i];
                byte triindex = 0;
                if (grid[T[0]] < 0.0f) {
                    triindex = (byte)(triindex | 1);
                }
                if (grid[T[1]] < 0.0f) {
                    triindex = (byte)(triindex | 2);
                }
                if (grid[T[2]] < 0.0f) {
                    triindex = (byte)(triindex | 4);
                }
                if (grid[T[3]] < 0.0f) {
                    triindex = (byte)(triindex | 8);
                }
                switch (triindex) {
                    case 0: 
                    case 15: {
                        continue block27;
                    }
                    case 14: {
                        faces.add(Face.retain(this.interp(T[0], T[1], grid, x), this.interp(T[0], T[3], grid, x), this.interp(T[0], T[2], grid, x)));
                        continue block27;
                    }
                    case 1: {
                        faces.add(Face.retain(this.interp(T[0], T[1], grid, x), this.interp(T[0], T[2], grid, x), this.interp(T[0], T[3], grid, x)));
                        continue block27;
                    }
                    case 13: {
                        faces.add(Face.retain(this.interp(T[1], T[0], grid, x), this.interp(T[1], T[2], grid, x), this.interp(T[1], T[3], grid, x)));
                        continue block27;
                    }
                    case 2: {
                        faces.add(Face.retain(this.interp(T[1], T[0], grid, x), this.interp(T[1], T[3], grid, x), this.interp(T[1], T[2], grid, x)));
                        continue block27;
                    }
                    case 12: {
                        faces.add(Face.retain(this.interp(T[1], T[2], grid, x), this.interp(T[1], T[3], grid, x), this.interp(T[0], T[3], grid, x), this.interp(T[0], T[2], grid, x)));
                        continue block27;
                    }
                    case 3: {
                        faces.add(Face.retain(this.interp(T[1], T[2], grid, x), this.interp(T[0], T[2], grid, x), this.interp(T[0], T[3], grid, x), this.interp(T[1], T[3], grid, x)));
                        continue block27;
                    }
                    case 4: {
                        faces.add(Face.retain(this.interp(T[2], T[0], grid, x), this.interp(T[2], T[1], grid, x), this.interp(T[2], T[3], grid, x)));
                        continue block27;
                    }
                    case 11: {
                        faces.add(Face.retain(this.interp(T[2], T[0], grid, x), this.interp(T[2], T[3], grid, x), this.interp(T[2], T[1], grid, x)));
                        continue block27;
                    }
                    case 5: {
                        faces.add(Face.retain(this.interp(T[0], T[1], grid, x), this.interp(T[1], T[2], grid, x), this.interp(T[2], T[3], grid, x), this.interp(T[0], T[3], grid, x)));
                        continue block27;
                    }
                    case 10: {
                        faces.add(Face.retain(this.interp(T[0], T[1], grid, x), this.interp(T[0], T[3], grid, x), this.interp(T[2], T[3], grid, x), this.interp(T[1], T[2], grid, x)));
                        continue block27;
                    }
                    case 6: {
                        faces.add(Face.retain(this.interp(T[2], T[3], grid, x), this.interp(T[0], T[2], grid, x), this.interp(T[0], T[1], grid, x), this.interp(T[1], T[3], grid, x)));
                        continue block27;
                    }
                    case 9: {
                        faces.add(Face.retain(this.interp(T[2], T[3], grid, x), this.interp(T[1], T[3], grid, x), this.interp(T[0], T[1], grid, x), this.interp(T[0], T[2], grid, x)));
                        continue block27;
                    }
                    case 7: {
                        faces.add(Face.retain(this.interp(T[3], T[0], grid, x), this.interp(T[3], T[1], grid, x), this.interp(T[3], T[2], grid, x)));
                        continue block27;
                    }
                    case 8: {
                        faces.add(Face.retain(this.interp(T[3], T[0], grid, x), this.interp(T[3], T[2], grid, x), this.interp(T[3], T[1], grid, x)));
                    }
                }
            }
            FaceList faceList = faces;
            return faceList;
        }
    }

    private Vec3 interp(byte i0, byte i1, float[] grid, byte[] x) {
        float g0 = grid[i0];
        float g1 = grid[i1];
        byte[] p0 = this.CUBE_VERTICES[i0];
        byte[] p1 = this.CUBE_VERTICES[i1];
        Vec3 v = Vec3.retain(x[0], x[1], x[2]);
        float t = g0 - g1;
        if ((double)Math.abs(t) > 1.0E-6) {
            t = g0 / t;
        }
        v.x += (double)((float)p0[0] + t * (float)(p1[0] - p0[0]));
        v.y += (double)((float)p0[1] + t * (float)(p1[1] - p0[1]));
        v.z += (double)((float)p0[2] + t * (float)(p1[2] - p0[2]));
        return v;
    }
}

