/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mesh;

import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.mesh.MeshGeneratorType;
import io.github.cadiboo.nocubes.mesh.generator.OldNoCubes;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.pooled.Face;
import io.github.cadiboo.nocubes.util.pooled.FaceList;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import io.github.cadiboo.nocubes.util.pooled.Vec3b;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public final class MeshDispatcher {
    @Nonnull
    public static FaceList generateBlockMeshOffset(@Nonnull BlockPos pos, @Nonnull IBlockReader reader, @Nonnull IsSmoothable isSmoothable, @Nonnull MeshGeneratorType meshGenerator) {
        try (BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            FaceList faceList = MeshDispatcher.generateBlockMeshOffset(pos, reader, pooledMutableBlockPos, isSmoothable, meshGenerator);
            return faceList;
        }
    }

    @Nonnull
    public static FaceList generateBlockMeshOffset(@Nonnull BlockPos pos, @Nonnull IBlockReader reader, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos, @Nonnull IsSmoothable isSmoothable, @Nonnull MeshGeneratorType meshGenerator) {
        if (meshGenerator == MeshGeneratorType.OldNoCubes) {
            return OldNoCubes.generateBlock(pos, reader, isSmoothable, pooledMutableBlockPos);
        }
        FaceList chunkData = MeshDispatcher.generateBlockMeshUnOffset(pos, reader, pooledMutableBlockPos, isSmoothable, meshGenerator);
        int chunkPosX = pos.func_177958_n() >> 4 << 4;
        int chunkPosY = pos.func_177956_o() >> 4 << 4;
        int chunkPosZ = pos.func_177952_p() >> 4 << 4;
        return MeshDispatcher.offsetFaceList(chunkPosX, chunkPosY, chunkPosZ, chunkData);
    }

    @Nonnull
    public static FaceList generateBlockMeshUnOffset(@Nonnull BlockPos pos, @Nonnull IBlockReader reader, BlockPos.PooledMutableBlockPos pooledMutableBlockPos, @Nonnull IsSmoothable isSmoothable, @Nonnull MeshGeneratorType meshGeneratorType) {
        try (ModProfiler ignored = ModProfiler.get().start("generateBlock");){
            int subZ;
            int subY;
            int subX;
            int addZ;
            int addY;
            int addX;
            int posX = pos.func_177958_n();
            int posY = pos.func_177956_o();
            int posZ = pos.func_177952_p();
            int relativePosX = posX & 0xF;
            int relativePosY = posY & 0xF;
            int relativePosZ = posZ & 0xF;
            if (meshGeneratorType == MeshGeneratorType.MarchingCubes) {
                addX = 1;
                addY = 1;
                addZ = 1;
                subX = 0;
                subY = 0;
                subZ = 0;
            } else if (meshGeneratorType == MeshGeneratorType.MarchingTetrahedra) {
                addX = 1;
                addY = 1;
                addZ = 1;
                subX = 0;
                subY = 0;
                subZ = 0;
            } else if (meshGeneratorType == MeshGeneratorType.SurfaceNets) {
                addX = 0;
                addY = 0;
                addZ = 0;
                subX = 1;
                subY = 1;
                subZ = 1;
            } else {
                addX = 0;
                addY = 0;
                addZ = 0;
                subX = 0;
                subY = 0;
                subZ = 0;
            }
            MeshGenerator meshGenerator = meshGeneratorType.getMeshGenerator();
            int meshSizeX = 2 + addX + subX + meshGenerator.getSizeXExtension();
            int meshSizeY = 2 + addY + subY + meshGenerator.getSizeYExtension();
            byte by = 2 + addZ + subZ + meshGenerator.getSizeZExtension();
            float[] densityData = new float[meshSizeX * meshSizeY * by];
            int startPosX = posX - subX;
            int startPosY = posY - subY;
            int startPosZ = posZ - subZ;
            int index = 0;
            for (int z = 0; z < meshSizeX; ++z) {
                for (int y = 0; y < meshSizeY; ++y) {
                    int x = 0;
                    while (x < by) {
                        float density = 0.0f;
                        for (int zOffset = 0; zOffset < 2; ++zOffset) {
                            for (int yOffset = 0; yOffset < 2; ++yOffset) {
                                for (int xOffset = 0; xOffset < 2; ++xOffset) {
                                    pooledMutableBlockPos.func_181079_c(startPosX + x - xOffset, startPosY + y - yOffset, startPosZ + z - zOffset);
                                    BlockState state = reader.func_180495_p((BlockPos)pooledMutableBlockPos);
                                    density += ModUtil.getIndividualBlockDensity(isSmoothable.apply(state), state);
                                }
                            }
                        }
                        densityData[index] = density;
                        ++x;
                        ++index;
                    }
                }
            }
            FaceList finalFaces = FaceList.retain();
            HashMap<Vec3b, FaceList> vec3bFaceListHashMap = meshGenerator.generateChunk(densityData, new byte[]{meshSizeX, meshSizeY, by});
            for (FaceList generatedFaceList : vec3bFaceListHashMap.values()) {
                finalFaces.addAll(generatedFaceList);
                generatedFaceList.close();
            }
            for (Vec3b vec3b : vec3bFaceListHashMap.keySet()) {
                vec3b.close();
            }
            for (Face face : finalFaces) {
                Vec3 vertex0 = face.getVertex0();
                Vec3 vertex1 = face.getVertex1();
                Vec3 vertex2 = face.getVertex2();
                Vec3 vertex3 = face.getVertex3();
                vertex0.addOffset(relativePosX, relativePosY, relativePosZ);
                vertex1.addOffset(relativePosX, relativePosY, relativePosZ);
                vertex2.addOffset(relativePosX, relativePosY, relativePosZ);
                vertex3.addOffset(relativePosX, relativePosY, relativePosZ);
                vertex0.addOffset(-subX, -subY, -subZ);
                vertex1.addOffset(-subX, -subY, -subZ);
                vertex2.addOffset(-subX, -subY, -subZ);
                vertex3.addOffset(-subX, -subY, -subZ);
            }
            FaceList faceList = finalFaces;
            return faceList;
        }
    }

    @Nonnull
    public static HashMap<Vec3b, FaceList> offsetChunkMesh(@Nonnull BlockPos chunkPos, @Nonnull HashMap<Vec3b, FaceList> chunkData) {
        MeshDispatcher.offsetMesh(chunkPos.func_177958_n(), chunkPos.func_177956_o(), chunkPos.func_177952_p(), chunkData);
        return chunkData;
    }

    @Nonnull
    public static HashMap<Vec3b, FaceList> offsetMesh(int offsetX, int offsetY, int offsetZ, @Nonnull HashMap<Vec3b, FaceList> meshData) {
        for (FaceList faces : meshData.values()) {
            MeshDispatcher.offsetFaceList(offsetX, offsetY, offsetZ, faces);
        }
        return meshData;
    }

    @Nonnull
    public static FaceList offsetFaceList(int chunkPosX, int chunkPosY, int chunkPosZ, @Nonnull FaceList faces) {
        int size = faces.size();
        for (int i = 0; i < size; ++i) {
            Face face = (Face)faces.get(i);
            Vec3 vertex0 = face.getVertex0();
            Vec3 vertex1 = face.getVertex1();
            Vec3 vertex2 = face.getVertex2();
            Vec3 vertex3 = face.getVertex3();
            vertex0.addOffset(chunkPosX, chunkPosY, chunkPosZ);
            vertex1.addOffset(chunkPosX, chunkPosY, chunkPosZ);
            vertex2.addOffset(chunkPosX, chunkPosY, chunkPosZ);
            vertex3.addOffset(chunkPosX, chunkPosY, chunkPosZ);
        }
        return faces;
    }
}

