/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.hooks;

import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.render.RenderDispatcher;
import io.github.cadiboo.nocubes.collision.CollisionHandler;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.util.ModUtil;
import java.util.HashSet;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.renderer.chunk.ChunkRenderTask;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class Hooks {
    @OnlyIn(value=Dist.CLIENT)
    public static void preIteration(ChunkRender renderChunk, float x, float y, float z, ChunkRenderTask generator, CompiledChunk compiledchunk, BlockPos blockpos, BlockPos blockpos1, World world, VisGraph lvt_10_1_, HashSet lvt_11_1_, ChunkRenderCache lvt_12_1_, boolean[] aboolean, Random random, BlockRendererDispatcher blockrendererdispatcher) {
        RenderDispatcher.renderChunk(renderChunk, blockpos, generator, compiledchunk, (IWorld)world, (IEnviromentBlockReader)lvt_12_1_, aboolean, random, blockrendererdispatcher);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean renderBlockDamage(BlockRendererDispatcher blockrendererdispatcher, BlockState iblockstate, BlockPos blockpos, TextureAtlasSprite textureatlassprite, IEnviromentBlockReader world) {
        if (!(Config.renderSmoothTerrain && iblockstate.nocubes_isTerrainSmoothable() || Config.renderSmoothLeaves && iblockstate.nocubes_isLeavesSmoothable())) {
            return false;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        RenderDispatcher.renderSmoothBlockDamage(tessellator, tessellator.func_178180_c(), blockpos, iblockstate, world, textureatlassprite);
        return true;
    }

    public static IFluidState getFluidState(World world, BlockPos pos) {
        return ModUtil.getFluidState(world, pos);
    }

    public static Stream<VoxelShape> getCollisionShapes(IWorldReader _this, Entity p_217352_1_, AxisAlignedBB p_217352_2_, int i, int j, int k, int l, int i1, int j1, ISelectionContext iselectioncontext) {
        return CollisionHandler.getCollisionShapes(_this, p_217352_1_, p_217352_2_, i, j, k, l, i1, j1, iselectioncontext);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canBlockStateRender(BlockState blockstate) {
        if (Config.renderSmoothTerrain && blockstate.nocubes_isTerrainSmoothable()) {
            return false;
        }
        return !Config.renderSmoothLeaves || !blockstate.nocubes_isLeavesSmoothable();
    }

    public static boolean doesNotCauseSuffocation(BlockState blockState, IBlockReader reader, BlockPos pos) {
        if (Config.terrainCollisions) {
            if (!blockState.nocubes_isTerrainSmoothable()) {
                return false;
            }
            return ModUtil.doesTerrainCauseSuffocation(reader, pos);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initChunkRenderCache(ChunkRenderCache _this, int chunkStartX, int chunkStartZ, Chunk[][] chunks, BlockPos start, BlockPos end) {
        ClientUtil.setupChunkRenderCache(_this, chunkStartX, chunkStartZ, chunks, start, end);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void markForRerender(BlockPos pos, WorldRenderer worldRenderer) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        int maxX = posX + 2;
        int maxY = posY + 2;
        int maxZ = posZ + 2;
        for (int z = posZ - 2; z <= maxZ; ++z) {
            for (int y = posY - 2; y <= maxY; ++y) {
                for (int x = posX - 2; x <= maxX; ++x) {
                    worldRenderer.func_215328_b(x >> 4, y >> 4, z >> 4);
                }
            }
        }
    }
}

