/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.config.ConfigHolder;
import io.github.cadiboo.nocubes.mesh.MeshGeneratorType;
import io.github.cadiboo.nocubes.util.ExtendFluidsRange;
import io.github.cadiboo.nocubes.util.SmoothLeavesType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.MyceliumBlock;
import net.minecraft.block.RedstoneOreBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.block.material.Material;
import net.minecraft.command.arguments.BlockStateArgument;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public final class ConfigHelper {
    public static ModConfig clientConfig;
    public static ModConfig serverConfig;

    public static void bakeClient(ModConfig config) {
        clientConfig = config;
        Config.renderSmoothTerrain = (Boolean)ConfigHolder.CLIENT.renderSmoothTerrain.get();
        Config.renderSmoothLeaves = (Boolean)ConfigHolder.CLIENT.renderSmoothLeaves.get();
        Config.leavesMeshGenerator = (MeshGeneratorType)((Object)ConfigHolder.CLIENT.leavesMeshGenerator.get());
        Config.leavesSmoothable = Sets.newHashSet((Iterable)((Iterable)ConfigHolder.CLIENT.leavesSmoothable.get()));
        ConfigHelper.initLeavesSmoothable();
        Config.smoothLeavesType = (SmoothLeavesType)((Object)ConfigHolder.CLIENT.smoothLeavesType.get());
        Config.applyDiffuseLighting = (Boolean)ConfigHolder.CLIENT.applyDiffuseLighting.get();
        Config.betterTextures = (Boolean)ConfigHolder.CLIENT.betterTextures.get();
        Config.shortGrass = (Boolean)ConfigHolder.CLIENT.shortGrass.get();
        Config.smoothFluidLighting = (Boolean)ConfigHolder.CLIENT.smoothFluidLighting.get();
        Config.smoothFluidColors = (Boolean)ConfigHolder.CLIENT.smoothFluidColors.get();
        Config.naturalFluidTextures = (Boolean)ConfigHolder.CLIENT.naturalFluidTextures.get();
    }

    public static void bakeServer(ModConfig config) {
        serverConfig = config;
        Config.terrainSmoothable = Sets.newHashSet((Iterable)((Iterable)ConfigHolder.SERVER.terrainSmoothable.get()));
        ConfigHelper.initTerrainSmoothable();
        Config.extendFluidsRange = (ExtendFluidsRange)((Object)ConfigHolder.SERVER.extendFluidsRange.get());
        Config.terrainMeshGenerator = (MeshGeneratorType)((Object)ConfigHolder.SERVER.terrainMeshGenerator.get());
        Config.terrainCollisions = (Boolean)ConfigHolder.SERVER.terrainCollisions.get();
    }

    public static void discoverDefaultTerrainSmoothable() {
    }

    public static void discoverDefaultLeavesSmoothable() {
        ArrayList discoveredStates = new ArrayList();
        ForgeRegistries.BLOCKS.getValues().parallelStream().forEach(block -> {
            BlockState defaultState = block.func_176223_P();
            if (defaultState.func_185904_a() == Material.field_151584_j) {
                Config.LOGGER.debug("Discovered leaves smoothable \"" + block + "\"");
                discoveredStates.add(defaultState);
            }
        });
        ConfigHelper.addLeavesSmoothable(discoveredStates.toArray(new BlockState[0]));
    }

    public static void addTerrainSmoothable(BlockState ... states) {
        if (states.length > 0) {
            for (BlockState state : states) {
                Config.LOGGER.debug("Adding terrain smoothable: " + state);
                state.nocubes_setTerrainSmoothable(true);
                Config.terrainSmoothable.add(ConfigHelper.getStringFromState(state));
            }
            ConfigHelper.setValueAndSave(serverConfig, "general.terrainSmoothable", new ArrayList<String>(Config.terrainSmoothable));
        }
    }

    public static void removeTerrainSmoothable(BlockState ... states) {
        if (states.length > 0) {
            for (BlockState state : states) {
                Config.LOGGER.debug("Removing terrain smoothable: " + state);
                state.nocubes_setTerrainSmoothable(false);
                Config.terrainSmoothable.remove(ConfigHelper.getStringFromState(state));
            }
            ConfigHelper.setValueAndSave(serverConfig, "general.terrainSmoothable", new ArrayList<String>(Config.terrainSmoothable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLeavesSmoothable(BlockState ... states) {
        if (states.length > 0) {
            HashSet<Block> hashSet = Config.leavesSmoothableBlocks;
            synchronized (hashSet) {
                for (BlockState originalState : states) {
                    Block block = originalState.func_177230_c();
                    Config.LOGGER.debug("Adding leaves smoothable block: " + block);
                    for (BlockState state : block.func_176194_O().func_177619_a()) {
                        Config.LOGGER.debug("Adding leaves smoothable state: " + state);
                        state.nocubes_setLeavesSmoothable(true);
                    }
                    Config.leavesSmoothable.add(block.getRegistryName().toString());
                    Config.leavesSmoothableBlocks.add(block);
                }
            }
            ConfigHelper.setValueAndSave(clientConfig, "general.leavesSmoothable", new ArrayList<String>(Config.leavesSmoothable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLeavesSmoothable(BlockState ... states) {
        if (states.length > 0) {
            HashSet<Block> hashSet = Config.leavesSmoothableBlocks;
            synchronized (hashSet) {
                for (BlockState originalState : states) {
                    Block block = originalState.func_177230_c();
                    Config.LOGGER.debug("Removing leaves smoothable block: " + block);
                    for (BlockState state : block.func_176194_O().func_177619_a()) {
                        Config.LOGGER.debug("Removing leaves smoothable state: " + state);
                        state.nocubes_setLeavesSmoothable(false);
                    }
                    Config.leavesSmoothable.remove(block.getRegistryName().toString());
                    Config.leavesSmoothableBlocks.remove(block);
                }
            }
            ConfigHelper.setValueAndSave(clientConfig, "general.leavesSmoothable", new ArrayList<String>(Config.leavesSmoothable));
        }
    }

    private static void initTerrainSmoothable() {
        Config.LOGGER.debug("Initialising terrain smoothable");
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            for (BlockState state : block.func_176194_O().func_177619_a()) {
                state.nocubes_setTerrainSmoothable(false);
            }
        }
        Config.LOGGER.debug("Reset all BlockStates to unsmoothable");
        for (String stateString : Config.terrainSmoothable) {
            Config.LOGGER.debug("Preparing to add \"" + stateString + "\" to terrain smoothable");
            BlockState state = ConfigHelper.getStateFromString(stateString);
            if (state != null) {
                Config.LOGGER.debug("Added \"" + state + "\" to terrain smoothable");
                state.nocubes_setTerrainSmoothable(true);
                continue;
            }
            Config.LOGGER.debug("Cannot add invalid state \"" + stateString + "\" to terrain smoothable");
        }
    }

    private static void initLeavesSmoothable() {
        Config.LOGGER.debug("Initialising leaves smoothable");
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            for (BlockState state : block.func_176194_O().func_177619_a()) {
                state.nocubes_setLeavesSmoothable(false);
            }
        }
        Config.LOGGER.debug("Reset all BlockStates to unsmoothable");
        for (String blockString : Config.leavesSmoothable) {
            Config.LOGGER.debug("Preparing to add block \"" + blockString + "\" to leaves smoothable");
            BlockState defaultState = ConfigHelper.getStateFromString(blockString);
            if (defaultState != null) {
                Block block = defaultState.func_177230_c();
                Config.LOGGER.debug("Added \"" + defaultState + "\" to leaves smoothable");
                for (BlockState state : block.func_176194_O().func_177619_a()) {
                    state.nocubes_setLeavesSmoothable(true);
                }
                Config.leavesSmoothableBlocks.add(block);
                continue;
            }
            Config.LOGGER.debug("Cannot add invalid block \"" + blockString + "\" to leaves smoothable");
        }
    }

    @Nullable
    private static BlockState getStateFromString(@Nonnull String stateString) {
        Preconditions.checkNotNull((Object)stateString, (Object)"String to parse must not be null");
        try {
            return new BlockStateArgument().parse(new StringReader(stateString)).func_197231_a();
        }
        catch (CommandSyntaxException e) {
            Config.LOGGER.error("Failed to parse blockstate \"" + stateString + "\"!", (Throwable)e);
            return null;
        }
    }

    @Nonnull
    private static String getStringFromState(@Nonnull BlockState state) {
        Preconditions.checkNotNull((Object)state, (Object)"State to serialise must not be null");
        String stateString = Objects.requireNonNull(state.func_177230_c().getRegistryName(), "Block registry name cannot be null!").toString();
        ArrayList<String> properties = new ArrayList<String>();
        for (Map.Entry entry : state.func_206871_b().entrySet()) {
            IProperty property = (IProperty)entry.getKey();
            Comparable value = (Comparable)entry.getValue();
            properties.add(property.func_177701_a() + "=" + Util.func_200269_a((IProperty)property, (Object)value));
        }
        if (!properties.isEmpty()) {
            stateString = stateString + "[";
            stateString = stateString + Strings.join(properties, (String)",");
            stateString = stateString + "]";
        }
        return stateString;
    }

    @Nonnull
    public static List<String> getDefaultTerrainSmoothable() {
        List vanillaStates = Lists.newArrayList((Object[])new BlockState[]{(BlockState)Blocks.field_196658_i.func_176223_P().func_206870_a((IProperty)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(false)), (BlockState)Blocks.field_196658_i.func_176223_P().func_206870_a((IProperty)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(true)), Blocks.field_150348_b.func_176223_P(), Blocks.field_196650_c.func_176223_P(), Blocks.field_196654_e.func_176223_P(), Blocks.field_196656_g.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_196660_k.func_176223_P(), (BlockState)Blocks.field_196661_l.func_176223_P().func_206870_a((IProperty)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(false)), (BlockState)Blocks.field_196661_l.func_176223_P().func_206870_a((IProperty)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(true)), Blocks.field_150354_m.func_176223_P(), Blocks.field_196611_F.func_176223_P(), Blocks.field_150322_A.func_176223_P(), Blocks.field_180395_cM.func_176223_P(), Blocks.field_150351_n.func_176223_P(), Blocks.field_150365_q.func_176223_P(), Blocks.field_150366_p.func_176223_P(), Blocks.field_150352_o.func_176223_P(), (BlockState)Blocks.field_150450_ax.func_176223_P().func_206870_a((IProperty)RedstoneOreBlock.field_196501_a, (Comparable)Boolean.valueOf(false)), (BlockState)Blocks.field_150450_ax.func_176223_P().func_206870_a((IProperty)RedstoneOreBlock.field_196501_a, (Comparable)Boolean.valueOf(true)), Blocks.field_150482_ag.func_176223_P(), Blocks.field_150369_x.func_176223_P(), Blocks.field_150412_bA.func_176223_P(), Blocks.field_196766_fg.func_176223_P(), Blocks.field_196686_dc.func_176223_P(), Blocks.field_185774_da.func_176223_P(), Blocks.field_150435_aG.func_176223_P(), Blocks.field_150405_ch.func_176223_P(), Blocks.field_196777_fo.func_176223_P(), Blocks.field_196778_fp.func_176223_P(), Blocks.field_196783_fs.func_176223_P(), Blocks.field_196789_fv.func_176223_P(), Blocks.field_196719_fA.func_176223_P(), Blocks.field_196721_fC.func_176223_P(), Blocks.field_196722_fD.func_176223_P(), Blocks.field_150403_cj.func_176223_P(), Blocks.field_150433_aE.func_176223_P(), Blocks.field_150357_h.func_176223_P(), Blocks.field_150424_aL.func_176223_P(), Blocks.field_150425_aM.func_176223_P(), Blocks.field_196814_hQ.func_176223_P(), Blocks.field_150426_aN.func_176223_P(), Blocks.field_150377_bs.func_176223_P(), (BlockState)Blocks.field_150391_bh.func_176223_P().func_206870_a((IProperty)MyceliumBlock.field_196382_a, (Comparable)Boolean.valueOf(true)), (BlockState)Blocks.field_150391_bh.func_176223_P().func_206870_a((IProperty)MyceliumBlock.field_196382_a, (Comparable)Boolean.valueOf(false))}).stream().map(ConfigHelper::getStringFromState).collect(Collectors.toList());
        ArrayList moddedStates = Lists.newArrayList();
        ArrayList finalStates = Lists.newArrayList();
        finalStates.addAll(vanillaStates);
        finalStates.addAll(moddedStates);
        return finalStates;
    }

    @Nonnull
    public static List<String> getDefaultLeavesSmoothable() {
        List vanillaStates = Lists.newArrayList((Object[])new Block[]{Blocks.field_196642_W, Blocks.field_196645_X, Blocks.field_196647_Y, Blocks.field_196648_Z, Blocks.field_196572_aa, Blocks.field_196574_ab}).stream().map(ForgeRegistryEntry::getRegistryName).map(ResourceLocation::toString).collect(Collectors.toList());
        ArrayList moddedStates = Lists.newArrayList();
        ArrayList finalStates = Lists.newArrayList();
        finalStates.addAll(vanillaStates);
        finalStates.addAll(moddedStates);
        return finalStates;
    }

    public static void setTerrainCollisions(boolean enabled) {
        ConfigHelper.setValueAndSave(serverConfig, "general.terrainCollisions", enabled);
    }

    public static void setRenderSmoothTerrain(boolean enabled) {
        ConfigHelper.setValueAndSave(clientConfig, "general.renderSmoothTerrain", enabled);
    }

    public static void setRenderSmoothLeaves(boolean enabled) {
        ConfigHelper.setValueAndSave(clientConfig, "general.renderSmoothLeaves", enabled);
    }

    public static void setValueAndSave(ModConfig modConfig, String path, Object newValue) {
        modConfig.getConfigData().set(path, newValue);
        modConfig.save();
    }
}

