/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.config;

import io.github.cadiboo.nocubes.config.ConfigHelper;
import io.github.cadiboo.nocubes.mesh.MeshGeneratorType;
import io.github.cadiboo.nocubes.util.SmoothLeavesType;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeConfigSpec;

final class ClientConfig {
    @Nonnull
    final ForgeConfigSpec.BooleanValue renderSmoothTerrain;
    @Nonnull
    final ForgeConfigSpec.BooleanValue renderSmoothLeaves;
    @Nonnull
    final ForgeConfigSpec.ConfigValue<List<? extends String>> leavesSmoothable;
    @Nonnull
    final ForgeConfigSpec.ConfigValue<MeshGeneratorType> leavesMeshGenerator;
    @Nonnull
    final ForgeConfigSpec.ConfigValue<SmoothLeavesType> smoothLeavesType;
    @Nonnull
    final ForgeConfigSpec.BooleanValue applyDiffuseLighting;
    @Nonnull
    final ForgeConfigSpec.BooleanValue betterTextures;
    @Nonnull
    final ForgeConfigSpec.BooleanValue shortGrass;
    @Nonnull
    final ForgeConfigSpec.BooleanValue smoothFluidLighting;
    @Nonnull
    final ForgeConfigSpec.BooleanValue smoothFluidColors;
    @Nonnull
    final ForgeConfigSpec.BooleanValue naturalFluidTextures;

    ClientConfig(@Nonnull ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.renderSmoothTerrain = builder.comment("If smooth terrain should be rendered").translation("nocubes.config.renderSmoothTerrain").define("renderSmoothTerrain", true);
        this.renderSmoothLeaves = builder.comment("If smooth leaves should be rendered").translation("nocubes.config.renderSmoothLeaves").define("renderSmoothLeaves", false);
        this.leavesSmoothable = builder.comment("The list of leaves smoothable blocks").translation("nocubes.config.leavesSmoothable").defineList("leavesSmoothable", ConfigHelper.getDefaultLeavesSmoothable(), o -> o instanceof String);
        this.leavesMeshGenerator = builder.comment("The mesh generator that generates leaves").translation("nocubes.config.leavesMeshGenerator").defineEnum("leavesMeshGenerator", (Enum)MeshGeneratorType.SurfaceNets);
        this.smoothLeavesType = builder.comment("How leaves should be rendered").translation("nocubes.config.smoothLeavesType").defineEnum("smoothLeavesType", (Enum)SmoothLeavesType.TOGETHER);
        this.applyDiffuseLighting = builder.comment("If diffuse lighting should be applied when rendering. Accentuates differences between heights").translation("nocubes.config.applyDiffuseLighting").define("applyDiffuseLighting", true);
        this.betterTextures = builder.comment("If better textures should be searched for when rendering").translation("nocubes.config.betterTextures").define("betterTextures", true);
        this.shortGrass = builder.comment("If short grass should be rendered").translation("nocubes.config.shortGrass").define("shortGrass", true);
        this.smoothFluidLighting = builder.comment("If fluids should be rendered with smooth lighting").translation("nocubes.config.smoothFluidLighting").define("smoothFluidLighting", true);
        this.smoothFluidColors = builder.comment("If fluids should be rendered with smooth biome blending").translation("nocubes.config.smoothFluidColors").define("smoothFluidColors", true);
        this.naturalFluidTextures = builder.comment("If fluids should be rendered with flipped and rotated variants of their textures").translation("nocubes.config.naturalFluidTextures").define("naturalFluidTextures", false);
        builder.pop();
    }
}

