/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.collision;

import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.pooled.Face;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public final class MeshCollisionUtil {
    private static int roundAvg(double d0, double d1, double d2, double d3) {
        return (int)((double)(Math.round(d0) + Math.round(d1) + Math.round(d2) + Math.round(d3)) / 4.0);
    }

    static int floorAvg(double d0, double d1, double d2, double d3) {
        return MathHelper.func_76128_c((double)((d0 + d1 + d2 + d3) / 4.0));
    }

    private static int average(double d0, double d1, double d2, double d3) {
        return (int)((d0 + d1 + d2 + d3) / 4.0);
    }

    static void addIntersectingFaceShapesToList(List<VoxelShape> outShapes, Face face, ModProfiler profiler, double maxYLevel, float shapeRadius, Predicate<VoxelShape> doesShapeIntersect, boolean ignoreIntersects) {
        VoxelShape v3v0v0v1shape;
        VoxelShape v2v3v3v0shape;
        VoxelShape v1v2v2v3shape;
        VoxelShape v0v1v1v2shape;
        VoxelShape v3v0shape;
        VoxelShape v2v3shape;
        VoxelShape v1v2shape;
        VoxelShape v0v1shape;
        Vec3 v3v0v0v1;
        Vec3 v2v3v3v0;
        Vec3 v1v2v2v3;
        Vec3 v0v1v1v2;
        Vec3 v3v0;
        Vec3 v2v3;
        Vec3 v1v2;
        Vec3 v0v1;
        try (ModProfiler ignored = profiler.start("interpolate");){
            Vec3 v0 = face.getVertex0();
            Vec3 v1 = face.getVertex1();
            Vec3 v2 = face.getVertex2();
            Vec3 v3 = face.getVertex3();
            v0v1 = MeshCollisionUtil.interp(v0, v1, 0.5f);
            v1v2 = MeshCollisionUtil.interp(v1, v2, 0.5f);
            v2v3 = MeshCollisionUtil.interp(v2, v3, 0.5f);
            v3v0 = MeshCollisionUtil.interp(v3, v0, 0.5f);
            v0v1v1v2 = MeshCollisionUtil.interp(v0v1, v1v2, 0.5f);
            v1v2v2v3 = MeshCollisionUtil.interp(v1v2, v2v3, 0.5f);
            v2v3v3v0 = MeshCollisionUtil.interp(v2v3, v3v0, 0.5f);
            v3v0v0v1 = MeshCollisionUtil.interp(v3v0, v0v1, 0.5f);
        }
        try (ModProfiler ignored = profiler.start("createVoxelShapes");){
            v0v1shape = MeshCollisionUtil.createVoxelShapeForVertex(v0v1, shapeRadius, maxYLevel);
            v1v2shape = MeshCollisionUtil.createVoxelShapeForVertex(v1v2, shapeRadius, maxYLevel);
            v2v3shape = MeshCollisionUtil.createVoxelShapeForVertex(v2v3, shapeRadius, maxYLevel);
            v3v0shape = MeshCollisionUtil.createVoxelShapeForVertex(v3v0, shapeRadius, maxYLevel);
            v0v1v1v2shape = MeshCollisionUtil.createVoxelShapeForVertex(v0v1v1v2, shapeRadius, maxYLevel);
            v1v2v2v3shape = MeshCollisionUtil.createVoxelShapeForVertex(v1v2v2v3, shapeRadius, maxYLevel);
            v2v3v3v0shape = MeshCollisionUtil.createVoxelShapeForVertex(v2v3v3v0, shapeRadius, maxYLevel);
            v3v0v0v1shape = MeshCollisionUtil.createVoxelShapeForVertex(v3v0v0v1, shapeRadius, maxYLevel);
        }
        ignored = profiler.start("addVoxelShapes");
        var29_29 = null;
        try {
            MeshCollisionUtil.addCollisionShapeToList(outShapes, v0v1shape, doesShapeIntersect, ignoreIntersects);
            MeshCollisionUtil.addCollisionShapeToList(outShapes, v1v2shape, doesShapeIntersect, ignoreIntersects);
            MeshCollisionUtil.addCollisionShapeToList(outShapes, v2v3shape, doesShapeIntersect, ignoreIntersects);
            MeshCollisionUtil.addCollisionShapeToList(outShapes, v3v0shape, doesShapeIntersect, ignoreIntersects);
            MeshCollisionUtil.addCollisionShapeToList(outShapes, v0v1v1v2shape, doesShapeIntersect, ignoreIntersects);
            MeshCollisionUtil.addCollisionShapeToList(outShapes, v1v2v2v3shape, doesShapeIntersect, ignoreIntersects);
            MeshCollisionUtil.addCollisionShapeToList(outShapes, v2v3v3v0shape, doesShapeIntersect, ignoreIntersects);
            MeshCollisionUtil.addCollisionShapeToList(outShapes, v3v0v0v1shape, doesShapeIntersect, ignoreIntersects);
        }
        catch (Throwable throwable) {
            var29_29 = throwable;
            throw throwable;
        }
        finally {
            if (ignored != null) {
                if (var29_29 != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable) {
                        var29_29.addSuppressed(throwable);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        v0v1.close();
        v1v2.close();
        v2v3.close();
        v3v0.close();
        v0v1v1v2.close();
        v1v2v2v3.close();
        v2v3v3v0.close();
        v3v0v0v1.close();
    }

    private static void addCollisionShapeToList(List<VoxelShape> collidingShapes, VoxelShape shape, Predicate<VoxelShape> doesShapeIntersect, boolean ignoreIntersects) {
        if (ignoreIntersects || doesShapeIntersect.test(shape)) {
            collidingShapes.add(shape);
        }
    }

    private static Vec3 interp(Vec3 v0, Vec3 v1, float t) {
        return Vec3.retain(v0.x + (double)t * (v1.x - v0.x), v0.y + (double)t * (v1.y - v0.y), v0.z + (double)t * (v1.z - v0.z));
    }

    private static VoxelShape createVoxelShapeForVertex(Vec3 vec3, float boxRadius, double maxY) {
        double vy = vec3.y;
        double vx = vec3.x;
        double vz = vec3.z;
        boolean isOverMax = vy + (double)boxRadius > maxY;
        return VoxelShapes.func_197873_a((double)(vx - (double)boxRadius), (double)(isOverMax ? vy - (double)boxRadius - (double)boxRadius : vy - (double)boxRadius), (double)(vz - (double)boxRadius), (double)(vx + (double)boxRadius), (double)(isOverMax ? vy : vy + (double)boxRadius), (double)(vz + (double)boxRadius));
    }
}

