/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render;

import io.github.cadiboo.nocubes.client.BlockColorInfo;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.LazyBlockColorCache;
import io.github.cadiboo.nocubes.client.LazyPackedLightCache;
import io.github.cadiboo.nocubes.client.LightmapInfo;
import io.github.cadiboo.nocubes.client.ModelHelper;
import io.github.cadiboo.nocubes.client.optifine.OptiFineCompatibility;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.StateHolder;
import io.github.cadiboo.nocubes.util.pooled.Face;
import io.github.cadiboo.nocubes.util.pooled.FaceList;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import io.github.cadiboo.nocubes.util.pooled.Vec3b;
import io.github.cadiboo.nocubes.util.pooled.cache.SmoothableCache;
import io.github.cadiboo.nocubes.util.pooled.cache.StateCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.chunk.ChunkRenderTask;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MeshRenderer {
    private static final Logger LOGGER = LogManager.getLogger((String)"NoCubes MeshRenderer");

    public static void renderMesh(@Nonnull ChunkRender chunkRender, @Nonnull ChunkRenderTask chunkRenderTask, @Nonnull CompiledChunk compiledChunk, @Nonnull BlockPos chunkRenderPos, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, @Nonnull IEnviromentBlockReader reader, @Nonnull StateCache stateCache, @Nonnull BlockRendererDispatcher blockRendererDispatcher, @Nonnull Random random, @Nonnull LazyPackedLightCache lazyPackedLightCache, @Nonnull LazyBlockColorCache lazyBlockColorCache, @Nonnull Map<Vec3b, FaceList> chunkData, @Nonnull SmoothableCache smoothableCache, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos, @Nonnull BlockPos.PooledMutableBlockPos texturePooledMutableBlockPos, @Nonnull boolean[] usedBlockRenderLayers, boolean renderOppositeSides, boolean tryForBetterTexturesSnow, boolean tryForBetterTexturesGrass) {
        try (ModProfiler ignored = ModProfiler.get().start("renderMesh");){
            Map<IRegistryDelegate<Block>, IBlockColor> blockColorsRegistry = ClientUtil.getBlockColorsRegistry(Minecraft.func_71410_x().func_184125_al());
            for (Map.Entry<Vec3b, FaceList> entry : chunkData.entrySet()) {
                Vec3b pos = entry.getKey();
                Throwable throwable = null;
                try {
                    FaceList faces = entry.getValue();
                    Throwable throwable2 = null;
                    try {
                        if (faces.isEmpty()) continue;
                        ModProfiler.get().end();
                        ModProfiler.get().start("prepareRenderFaces");
                        int initialPosX = chunkRenderPosX + pos.x;
                        int initialPosY = chunkRenderPosY + pos.y;
                        int initialPosZ = chunkRenderPosZ + pos.z;
                        byte relativePosX = ModUtil.getRelativePos(chunkRenderPosX, initialPosX);
                        byte relativePosY = ModUtil.getRelativePos(chunkRenderPosY, initialPosY);
                        byte relativePosZ = ModUtil.getRelativePos(chunkRenderPosZ, initialPosZ);
                        ModProfiler.get().end();
                        BlockState textureState = ClientUtil.getTexturePosAndState(initialPosX, initialPosY, initialPosZ, texturePooledMutableBlockPos, stateCache, smoothableCache, relativePosX, relativePosY, relativePosZ, tryForBetterTexturesSnow, tryForBetterTexturesGrass);
                        ModProfiler.get().start("renderMesh");
                        try {
                            MeshRenderer.renderFaces(chunkRender, chunkRenderTask, compiledChunk, chunkRenderPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, reader, blockRendererDispatcher, random, usedBlockRenderLayers, lazyPackedLightCache, lazyBlockColorCache, blockColorsRegistry, pos, faces, pooledMutableBlockPos, (BlockPos)texturePooledMutableBlockPos, textureState, renderOppositeSides);
                        }
                        catch (Exception e) {
                            CrashReport crashReport = new CrashReport("Rendering faces for smooth block in world", (Throwable)e);
                            CrashReportCategory realBlockCrashReportCategory = crashReport.func_85058_a("Block being rendered");
                            BlockPos blockPos = new BlockPos(chunkRenderPosX + pos.x, chunkRenderPosX + pos.y, chunkRenderPosX + pos.z);
                            CrashReportCategory.func_175750_a((CrashReportCategory)realBlockCrashReportCategory, (BlockPos)blockPos, (BlockState)reader.func_180495_p(new BlockPos(initialPosX, initialPosY, initialPosZ)));
                            CrashReportCategory textureBlockCrashReportCategory = crashReport.func_85058_a("TextureBlock of Block being rendered");
                            CrashReportCategory.func_175750_a((CrashReportCategory)textureBlockCrashReportCategory, (BlockPos)texturePooledMutableBlockPos.func_185334_h(), (BlockState)textureState);
                            throw new ReportedException(crashReport);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (faces == null) continue;
                        if (throwable2 != null) {
                            try {
                                faces.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        faces.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (pos == null) continue;
                    if (throwable != null) {
                        try {
                            pos.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    pos.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderFaces(@Nonnull ChunkRender chunkRender, @Nonnull ChunkRenderTask chunkRenderTask, @Nonnull CompiledChunk compiledChunk, @Nonnull BlockPos chunkRenderPos, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, @Nonnull IEnviromentBlockReader reader, @Nonnull BlockRendererDispatcher blockRendererDispatcher, @Nonnull Random random, @Nonnull boolean[] usedBlockRenderLayers, @Nonnull LazyPackedLightCache lazyPackedLightCache, @Nonnull LazyBlockColorCache lazyBlockColorCache, @Nonnull Map<IRegistryDelegate<Block>, IBlockColor> blockColorsRegistry, @Nonnull Vec3b pos, @Nonnull FaceList faces, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos, @Nonnull BlockPos texturePos, @Nonnull BlockState textureState, boolean renderOppositeSides) {
        IModelData modelData = chunkRenderTask.getModelData(texturePos);
        long posRand = MathHelper.func_180186_a((Vec3i)texturePos);
        boolean applyDiffuseLighting = Config.applyDiffuseLighting;
        boolean shortGrass = Config.shortGrass;
        boolean colorsCacheApplicableToTextureState = lazyBlockColorCache.shouldApply.test(textureState);
        int[] lazyBlockColorCacheCache = lazyBlockColorCache.cache;
        int lazyBlockColorCacheSizeX = lazyBlockColorCache.sizeX;
        int lazyBlockColorCacheSizeY = lazyBlockColorCache.sizeY;
        int biomeBlendRadius = Minecraft.func_71410_x().field_71474_y.field_205217_U;
        int d = biomeBlendRadius * 2 + 1;
        int lazyBlockColorCacheArea = d * d;
        int lazyBlockColorCacheMax = biomeBlendRadius + 1;
        BiomeColors.IColorResolver colorResolver = lazyBlockColorCache.colorResolver;
        IBlockColor textureColorGetter = blockColorsRegistry.get(textureState.func_177230_c().delegate);
        boolean textureColorGetterIsNonNull = textureColorGetter != null;
        ModProfiler profiler = ModProfiler.get();
        int facesSize = faces.size();
        for (int faceIndex = 0; faceIndex < facesSize; ++faceIndex) {
            try (Face face = (Face)faces.get(faceIndex);){
                try (Vec3 v0 = face.getVertex0();
                     Vec3 v1 = face.getVertex1();
                     Vec3 v2 = face.getVertex2();
                     Vec3 v3 = face.getVertex3();){
                    int lightmapBlockLight3;
                    int lightmapBlockLight2;
                    int lightmapBlockLight1;
                    int lightmapBlockLight0;
                    int lightmapSkyLight3;
                    int lightmapSkyLight2;
                    int lightmapSkyLight1;
                    int lightmapSkyLight0;
                    float diffuse0;
                    float diffuse1;
                    float diffuse2;
                    float diffuse3;
                    if (!applyDiffuseLighting) {
                        diffuse3 = 1.0f;
                        diffuse2 = 1.0f;
                        diffuse1 = 1.0f;
                        diffuse0 = 1.0f;
                    } else {
                        profiler.end();
                        profiler.start("calculateDiffuseLighting");
                        diffuse0 = MeshRenderer.diffuseLight(MeshRenderer.toSide(v0.x - (double)chunkRenderPosX - (double)pos.x, v0.y - (double)chunkRenderPosY - (double)pos.y, v0.z - (double)chunkRenderPosZ - (double)pos.z));
                        diffuse1 = MeshRenderer.diffuseLight(MeshRenderer.toSide(v1.x - (double)chunkRenderPosX - (double)pos.x, v1.y - (double)chunkRenderPosY - (double)pos.y, v1.z - (double)chunkRenderPosZ - (double)pos.z));
                        diffuse2 = MeshRenderer.diffuseLight(MeshRenderer.toSide(v2.x - (double)chunkRenderPosX - (double)pos.x, v2.y - (double)chunkRenderPosY - (double)pos.y, v2.z - (double)chunkRenderPosZ - (double)pos.z));
                        diffuse3 = MeshRenderer.diffuseLight(MeshRenderer.toSide(v3.x - (double)chunkRenderPosX - (double)pos.x, v3.y - (double)chunkRenderPosY - (double)pos.y, v3.z - (double)chunkRenderPosZ - (double)pos.z));
                        profiler.end();
                        profiler.start("renderMesh");
                    }
                    profiler.end();
                    try (LightmapInfo lightmapInfo = LightmapInfo.generateLightmapInfo(lazyPackedLightCache, v0, v1, v2, v3, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, pooledMutableBlockPos);){
                        lightmapSkyLight0 = lightmapInfo.skylight0;
                        lightmapSkyLight1 = lightmapInfo.skylight1;
                        lightmapSkyLight2 = lightmapInfo.skylight2;
                        lightmapSkyLight3 = lightmapInfo.skylight3;
                        lightmapBlockLight0 = lightmapInfo.blocklight0;
                        lightmapBlockLight1 = lightmapInfo.blocklight1;
                        lightmapBlockLight2 = lightmapInfo.blocklight2;
                        lightmapBlockLight3 = lightmapInfo.blocklight3;
                    }
                    profiler.start("renderMesh");
                    boolean hasSetColors = false;
                    float colorRed0 = -1.0f;
                    float colorGreen0 = -1.0f;
                    float colorBlue0 = -1.0f;
                    float colorRed1 = -1.0f;
                    float colorGreen1 = -1.0f;
                    float colorBlue1 = -1.0f;
                    float colorRed2 = -1.0f;
                    float colorGreen2 = -1.0f;
                    float colorBlue2 = -1.0f;
                    float colorRed3 = -1.0f;
                    float colorGreen3 = -1.0f;
                    float colorBlue3 = -1.0f;
                    if (shortGrass) {
                        profiler.end();
                        profiler.start("shortGrass");
                        if (textureState == StateHolder.GRASS_BLOCK_DEFAULT && MeshRenderer.areVerticesCloseToFlat(v0, v1, v2, v3)) {
                            MeshRenderer.renderShortGrass(chunkRender, chunkRenderTask, compiledChunk, chunkRenderPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, reader, blockRendererDispatcher, random, usedBlockRenderLayers, pooledMutableBlockPos, texturePos, v0, v1, v2, v3, lightmapSkyLight0, lightmapSkyLight1, lightmapSkyLight2, lightmapSkyLight3, lightmapBlockLight0, lightmapBlockLight1, lightmapBlockLight2, lightmapBlockLight3);
                        }
                        profiler.end();
                        profiler.start("renderMesh");
                    }
                    for (int i = 0; i < ClientUtil.BLOCK_RENDER_LAYER_VALUES_LENGTH; ++i) {
                        BlockRenderLayer initialBlockRenderLayer = ClientUtil.BLOCK_RENDER_LAYER_VALUES[i];
                        if (!textureState.canRenderInLayer(initialBlockRenderLayer)) continue;
                        BlockRenderLayer correctedBlockRenderLayer = ClientUtil.getCorrectRenderLayer(initialBlockRenderLayer);
                        int correctedBlockRenderLayerOrdinal = correctedBlockRenderLayer.ordinal();
                        ForgeHooksClient.setRenderLayer((BlockRenderLayer)correctedBlockRenderLayer);
                        BufferBuilder bufferBuilder = ClientUtil.startOrContinueBufferBuilder(chunkRenderTask, correctedBlockRenderLayerOrdinal, compiledChunk, correctedBlockRenderLayer, chunkRender, chunkRenderPos);
                        boolean wasAnythingRendered = false;
                        OptiFineCompatibility.pushShaderThing(textureState, texturePos, reader, bufferBuilder);
                        try {
                            List<BakedQuad> quads;
                            try (ModProfiler ignored12 = profiler.start("getQuads");){
                                random.setSeed(posRand);
                                quads = ModelHelper.getQuads(textureState, texturePos, bufferBuilder, (IBlockReader)reader, blockRendererDispatcher, modelData, random, correctedBlockRenderLayer);
                                if (quads == null) {
                                    LOGGER.warn("Got null quads for " + textureState.func_177230_c() + " at " + texturePos);
                                    quads = new ArrayList<BakedQuad>();
                                    quads.add((BakedQuad)blockRendererDispatcher.func_175023_a().func_178126_b().func_174951_a().getQuads(null, Direction.DOWN, random, modelData).get(0));
                                }
                            }
                            int quadsSize = quads.size();
                            for (int quadIndex = 0; quadIndex < quadsSize; ++quadIndex) {
                                float blue3;
                                float green3;
                                float red3;
                                float blue2;
                                float green2;
                                float red2;
                                float blue1;
                                float green1;
                                float red1;
                                float blue0;
                                float green0;
                                float red0;
                                Throwable throwable;
                                BlockColorInfo blockColorInfo2;
                                Throwable throwable2;
                                ModProfiler ignored;
                                float v3v;
                                float v3u;
                                float v2v;
                                float v2u;
                                float v1v;
                                float v1u;
                                float v0v;
                                float v0u;
                                BakedQuad quad = quads.get(quadIndex);
                                wasAnythingRendered = true;
                                int formatSize = quad.getFormat().func_181719_f();
                                int[] vertexData = quad.func_178209_a();
                                try (ModProfiler ignored13 = profiler.start("getUVs");){
                                    v0u = Float.intBitsToFloat(vertexData[4]);
                                    v0v = Float.intBitsToFloat(vertexData[5]);
                                    v1u = Float.intBitsToFloat(vertexData[formatSize + 4]);
                                    v1v = Float.intBitsToFloat(vertexData[formatSize + 5]);
                                    v2u = Float.intBitsToFloat(vertexData[formatSize * 2 + 4]);
                                    v2v = Float.intBitsToFloat(vertexData[formatSize * 2 + 5]);
                                    v3u = Float.intBitsToFloat(vertexData[formatSize * 3 + 4]);
                                    v3v = Float.intBitsToFloat(vertexData[formatSize * 3 + 5]);
                                }
                                int quadPackedLight0 = vertexData[6];
                                int quadPackedLight1 = vertexData[formatSize + 6];
                                int quadPackedLight2 = vertexData[formatSize * 2 + 6];
                                int quadPackedLight3 = vertexData[formatSize * 3 + 6];
                                int quadSkyLight0 = quadPackedLight0 >> 16 & 0xFF;
                                int quadSkyLight1 = quadPackedLight1 >> 16 & 0xFF;
                                int quadSkyLight2 = quadPackedLight2 >> 16 & 0xFF;
                                int quadSkyLight3 = quadPackedLight3 >> 16 & 0xFF;
                                int quadBlockLight0 = quadPackedLight0 & 0xFF;
                                int quadBlockLight1 = quadPackedLight1 & 0xFF;
                                int quadBlockLight2 = quadPackedLight2 & 0xFF;
                                int quadBlockLight3 = quadPackedLight3 & 0xFF;
                                boolean hasTintIndex = quad.func_178212_b();
                                if (BlockColorInfo.RAINBOW || BlockColorInfo.BLACK) {
                                    if (!hasSetColors) {
                                        profiler.end();
                                        ignored = ModProfiler.get().start("generateBlockColorInfo");
                                        throwable2 = null;
                                        try {
                                            blockColorInfo2 = BlockColorInfo.generateBlockColorInfo(lazyBlockColorCache, v0, v1, v2, v3, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyBlockColorCacheCache, lazyBlockColorCacheSizeX, lazyBlockColorCacheSizeY, biomeBlendRadius, lazyBlockColorCacheArea, lazyBlockColorCacheMax, reader, colorResolver, true, pooledMutableBlockPos);
                                            throwable = null;
                                            try {
                                                colorRed0 = blockColorInfo2.red0;
                                                colorGreen0 = blockColorInfo2.green0;
                                                colorBlue0 = blockColorInfo2.blue0;
                                                colorRed1 = blockColorInfo2.red1;
                                                colorGreen1 = blockColorInfo2.green1;
                                                colorBlue1 = blockColorInfo2.blue1;
                                                colorRed2 = blockColorInfo2.red2;
                                                colorGreen2 = blockColorInfo2.green2;
                                                colorBlue2 = blockColorInfo2.blue2;
                                                colorRed3 = blockColorInfo2.red3;
                                                colorGreen3 = blockColorInfo2.green3;
                                                colorBlue3 = blockColorInfo2.blue3;
                                            }
                                            catch (Throwable throwable3) {
                                                throwable = throwable3;
                                                throw throwable3;
                                            }
                                            finally {
                                                if (blockColorInfo2 != null) {
                                                    if (throwable != null) {
                                                        try {
                                                            blockColorInfo2.close();
                                                        }
                                                        catch (Throwable throwable4) {
                                                            throwable.addSuppressed(throwable4);
                                                        }
                                                    } else {
                                                        blockColorInfo2.close();
                                                    }
                                                }
                                            }
                                        }
                                        catch (Throwable blockColorInfo2) {
                                            throwable2 = blockColorInfo2;
                                            throw blockColorInfo2;
                                        }
                                        finally {
                                            if (ignored != null) {
                                                if (throwable2 != null) {
                                                    try {
                                                        ignored.close();
                                                    }
                                                    catch (Throwable blockColorInfo2) {
                                                        throwable2.addSuppressed(blockColorInfo2);
                                                    }
                                                } else {
                                                    ignored.close();
                                                }
                                            }
                                        }
                                        hasSetColors = true;
                                        profiler.start("renderMesh");
                                    }
                                    red0 = colorRed0;
                                    green0 = colorGreen0;
                                    blue0 = colorBlue0;
                                    red1 = colorRed1;
                                    green1 = colorGreen1;
                                    blue1 = colorBlue1;
                                    red2 = colorRed2;
                                    green2 = colorGreen2;
                                    blue2 = colorBlue2;
                                    red3 = colorRed3;
                                    green3 = colorGreen3;
                                    blue3 = colorBlue3;
                                } else if (hasTintIndex) {
                                    if (colorsCacheApplicableToTextureState) {
                                        if (!hasSetColors) {
                                            profiler.end();
                                            ignored = ModProfiler.get().start("generateBlockColorInfo");
                                            throwable2 = null;
                                            try {
                                                blockColorInfo2 = BlockColorInfo.generateBlockColorInfo(lazyBlockColorCache, v0, v1, v2, v3, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyBlockColorCacheCache, lazyBlockColorCacheSizeX, lazyBlockColorCacheSizeY, biomeBlendRadius, lazyBlockColorCacheArea, lazyBlockColorCacheMax, reader, colorResolver, true, pooledMutableBlockPos);
                                                throwable = null;
                                                try {
                                                    colorRed0 = blockColorInfo2.red0;
                                                    colorGreen0 = blockColorInfo2.green0;
                                                    colorBlue0 = blockColorInfo2.blue0;
                                                    colorRed1 = blockColorInfo2.red1;
                                                    colorGreen1 = blockColorInfo2.green1;
                                                    colorBlue1 = blockColorInfo2.blue1;
                                                    colorRed2 = blockColorInfo2.red2;
                                                    colorGreen2 = blockColorInfo2.green2;
                                                    colorBlue2 = blockColorInfo2.blue2;
                                                    colorRed3 = blockColorInfo2.red3;
                                                    colorGreen3 = blockColorInfo2.green3;
                                                    colorBlue3 = blockColorInfo2.blue3;
                                                }
                                                catch (Throwable throwable5) {
                                                    throwable = throwable5;
                                                    throw throwable5;
                                                }
                                                finally {
                                                    if (blockColorInfo2 != null) {
                                                        if (throwable != null) {
                                                            try {
                                                                blockColorInfo2.close();
                                                            }
                                                            catch (Throwable throwable6) {
                                                                throwable.addSuppressed(throwable6);
                                                            }
                                                        } else {
                                                            blockColorInfo2.close();
                                                        }
                                                    }
                                                }
                                            }
                                            catch (Throwable throwable7) {
                                                throwable2 = throwable7;
                                                throw throwable7;
                                            }
                                            finally {
                                                if (ignored != null) {
                                                    if (throwable2 != null) {
                                                        try {
                                                            ignored.close();
                                                        }
                                                        catch (Throwable throwable8) {
                                                            throwable2.addSuppressed(throwable8);
                                                        }
                                                    } else {
                                                        ignored.close();
                                                    }
                                                }
                                            }
                                            hasSetColors = true;
                                            profiler.start("renderMesh");
                                        }
                                        red0 = colorRed0;
                                        green0 = colorGreen0;
                                        blue0 = colorBlue0;
                                        red1 = colorRed1;
                                        green1 = colorGreen1;
                                        blue1 = colorBlue1;
                                        red2 = colorRed2;
                                        green2 = colorGreen2;
                                        blue2 = colorBlue2;
                                        red3 = colorRed3;
                                        green3 = colorGreen3;
                                        blue3 = colorBlue3;
                                    } else if (textureColorGetterIsNonNull) {
                                        int tintIndex = quad.func_178211_c();
                                        profiler.end();
                                        try (ModProfiler ignored2 = ModProfiler.get().start("generateBlockColorInfo");
                                             BlockColorInfo blockColorInfo3 = BlockColorInfo.generateBlockColorInfo(lazyBlockColorCache, v0, v1, v2, v3, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyBlockColorCacheCache, lazyBlockColorCacheSizeX, lazyBlockColorCacheSizeY, biomeBlendRadius, lazyBlockColorCacheArea, lazyBlockColorCacheMax, reader, (ignored1, colorPos) -> textureColorGetter.getColor(textureState, reader, colorPos, tintIndex), false, pooledMutableBlockPos);){
                                            red0 = blockColorInfo3.red0;
                                            green0 = blockColorInfo3.green0;
                                            blue0 = blockColorInfo3.blue0;
                                            red1 = blockColorInfo3.red1;
                                            green1 = blockColorInfo3.green1;
                                            blue1 = blockColorInfo3.blue1;
                                            red2 = blockColorInfo3.red2;
                                            green2 = blockColorInfo3.green2;
                                            blue2 = blockColorInfo3.blue2;
                                            red3 = blockColorInfo3.red3;
                                            green3 = blockColorInfo3.green3;
                                            blue3 = blockColorInfo3.blue3;
                                        }
                                        profiler.start("renderMesh");
                                    } else {
                                        red0 = 1.0f;
                                        green0 = 1.0f;
                                        blue0 = 1.0f;
                                        red1 = 1.0f;
                                        green1 = 1.0f;
                                        blue1 = 1.0f;
                                        red2 = 1.0f;
                                        green2 = 1.0f;
                                        blue2 = 1.0f;
                                        red3 = 1.0f;
                                        green3 = 1.0f;
                                        blue3 = 1.0f;
                                    }
                                } else {
                                    red0 = 1.0f;
                                    green0 = 1.0f;
                                    blue0 = 1.0f;
                                    red1 = 1.0f;
                                    green1 = 1.0f;
                                    blue1 = 1.0f;
                                    red2 = 1.0f;
                                    green2 = 1.0f;
                                    blue2 = 1.0f;
                                    red3 = 1.0f;
                                    green3 = 1.0f;
                                    blue3 = 1.0f;
                                }
                                throwable2 = null;
                                try (ModProfiler ignored14 = profiler.start("renderSide");){
                                    bufferBuilder.func_181662_b(v0.x, v0.y, v0.z).func_181666_a(red0 * diffuse0, green0 * diffuse0, blue0 * diffuse0, 1.0f).func_187315_a((double)v0u, (double)v0v).func_187314_a(quadSkyLight0 >= lightmapSkyLight0 ? quadSkyLight0 : lightmapSkyLight0, quadBlockLight0 >= lightmapBlockLight0 ? quadBlockLight0 : lightmapBlockLight0).func_181675_d();
                                    bufferBuilder.func_181662_b(v1.x, v1.y, v1.z).func_181666_a(red1 * diffuse1, green1 * diffuse1, blue1 * diffuse1, 1.0f).func_187315_a((double)v1u, (double)v1v).func_187314_a(quadSkyLight1 >= lightmapSkyLight1 ? quadSkyLight1 : lightmapSkyLight1, quadBlockLight1 >= lightmapBlockLight1 ? quadBlockLight1 : lightmapBlockLight1).func_181675_d();
                                    bufferBuilder.func_181662_b(v2.x, v2.y, v2.z).func_181666_a(red2 * diffuse2, green2 * diffuse2, blue2 * diffuse2, 1.0f).func_187315_a((double)v2u, (double)v2v).func_187314_a(quadSkyLight2 >= lightmapSkyLight2 ? quadSkyLight2 : lightmapSkyLight2, quadBlockLight2 >= lightmapBlockLight2 ? quadBlockLight2 : lightmapBlockLight2).func_181675_d();
                                    bufferBuilder.func_181662_b(v3.x, v3.y, v3.z).func_181666_a(red3 * diffuse3, green3 * diffuse3, blue3 * diffuse3, 1.0f).func_187315_a((double)v3u, (double)v3v).func_187314_a(quadSkyLight3 >= lightmapSkyLight3 ? quadSkyLight3 : lightmapSkyLight3, quadBlockLight3 >= lightmapBlockLight3 ? quadBlockLight3 : lightmapBlockLight3).func_181675_d();
                                }
                                catch (Throwable throwable9) {
                                    throwable2 = throwable9;
                                    throw throwable9;
                                }
                                if (!renderOppositeSides) continue;
                                ignored14 = profiler.start("renderOppositeSide");
                                throwable2 = null;
                                try {
                                    bufferBuilder.func_181662_b(v3.x, v3.y, v3.z).func_181666_a(red3 * diffuse3, green3 * diffuse3, blue3 * diffuse3, 1.0f).func_187315_a((double)v0u, (double)v0v).func_187314_a(quadSkyLight3 >= lightmapSkyLight3 ? quadSkyLight3 : lightmapSkyLight3, quadBlockLight3 >= lightmapBlockLight3 ? quadBlockLight3 : lightmapBlockLight3).func_181675_d();
                                    bufferBuilder.func_181662_b(v2.x, v2.y, v2.z).func_181666_a(red2 * diffuse2, green2 * diffuse2, blue2 * diffuse2, 1.0f).func_187315_a((double)v1u, (double)v1v).func_187314_a(quadSkyLight2 >= lightmapSkyLight2 ? quadSkyLight2 : lightmapSkyLight2, quadBlockLight2 >= lightmapBlockLight2 ? quadBlockLight2 : lightmapBlockLight2).func_181675_d();
                                    bufferBuilder.func_181662_b(v1.x, v1.y, v1.z).func_181666_a(red1 * diffuse1, green1 * diffuse1, blue1 * diffuse1, 1.0f).func_187315_a((double)v2u, (double)v2v).func_187314_a(quadSkyLight1 >= lightmapSkyLight1 ? quadSkyLight1 : lightmapSkyLight1, quadBlockLight1 >= lightmapBlockLight1 ? quadBlockLight1 : lightmapBlockLight1).func_181675_d();
                                    bufferBuilder.func_181662_b(v0.x, v0.y, v0.z).func_181666_a(red0 * diffuse0, green0 * diffuse0, blue0 * diffuse0, 1.0f).func_187315_a((double)v3u, (double)v3v).func_187314_a(quadSkyLight0 >= lightmapSkyLight0 ? quadSkyLight0 : lightmapSkyLight0, quadBlockLight0 >= lightmapBlockLight0 ? quadBlockLight0 : lightmapBlockLight0).func_181675_d();
                                    continue;
                                }
                                catch (Throwable throwable10) {
                                    throwable2 = throwable10;
                                    throw throwable10;
                                }
                                finally {
                                    if (ignored14 != null) {
                                        if (throwable2 != null) {
                                            try {
                                                ignored14.close();
                                            }
                                            catch (Throwable throwable11) {
                                                throwable2.addSuppressed(throwable11);
                                            }
                                        } else {
                                            ignored14.close();
                                        }
                                    }
                                }
                            }
                        }
                        finally {
                            OptiFineCompatibility.popShaderThing(bufferBuilder);
                        }
                        int n = correctedBlockRenderLayerOrdinal;
                        usedBlockRenderLayers[n] = usedBlockRenderLayers[n] | wasAnythingRendered;
                    }
                }
                ForgeHooksClient.setRenderLayer(null);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderShortGrass(@Nonnull ChunkRender chunkRender, @Nonnull ChunkRenderTask chunkRenderTask, @Nonnull CompiledChunk compiledChunk, @Nonnull BlockPos chunkRenderPos, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, @Nonnull IEnviromentBlockReader reader, @Nonnull BlockRendererDispatcher blockRendererDispatcher, @Nonnull Random random, @Nonnull boolean[] usedBlockRenderLayers, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos, @Nonnull BlockPos texturePos, Vec3 v0, Vec3 v1, Vec3 v2, Vec3 v3, int lightmapSkyLight0, int lightmapSkyLight1, int lightmapSkyLight2, int lightmapSkyLight3, int lightmapBlockLight0, int lightmapBlockLight1, int lightmapBlockLight2, int lightmapBlockLight3) {
        BlockState grassPlantState = StateHolder.GRASS_PLANT_DEFAULT;
        pooledMutableBlockPos.func_189533_g((Vec3i)texturePos).func_189536_c(Direction.UP);
        if (pooledMutableBlockPos.func_177958_n() > chunkRenderPosX + 16 || pooledMutableBlockPos.func_177956_o() > chunkRenderPosY + 16 || pooledMutableBlockPos.func_177952_p() > chunkRenderPosZ + 16) {
            return;
        }
        BlockState blockStateUp = reader.func_180495_p((BlockPos)pooledMutableBlockPos);
        if (blockStateUp == grassPlantState || blockStateUp == StateHolder.TALL_GRASS_PLANT_BOTTOM) {
            return;
        }
        if (blockStateUp.func_200015_d((IBlockReader)reader, (BlockPos)pooledMutableBlockPos)) {
            return;
        }
        if (blockStateUp.func_185904_a().func_76224_d()) {
            return;
        }
        double shortGrassHeight = 0.25;
        Vec3d offset = grassPlantState.func_191059_e((IBlockReader)reader, texturePos);
        double offX = offset.field_72450_a;
        double offY = 0.0;
        double offZ = offset.field_72449_c;
        double v0x = v0.x;
        double v0y = v0.y;
        double v0z = v0.z;
        double v1x = v1.x;
        double v1y = v1.y;
        double v1z = v1.z;
        double v2x = v2.x;
        double v2y = v2.y;
        double v2z = v2.z;
        double v3x = v3.x;
        double v3y = v3.y;
        double v3z = v3.z;
        IBakedModel model = blockRendererDispatcher.func_184389_a(grassPlantState);
        long posRand = MathHelper.func_180186_a((Vec3i)texturePos);
        int color = BiomeColors.field_180291_a.getColor(reader.func_180494_b(texturePos), texturePos);
        int red = (color & 0xFF0000) >> 16;
        int green = (color & 0xFF00) >> 8;
        int blue = color & 0xFF;
        for (int i = 0; i < ClientUtil.BLOCK_RENDER_LAYER_VALUES_LENGTH; ++i) {
            BlockRenderLayer initialBlockRenderLayer = ClientUtil.BLOCK_RENDER_LAYER_VALUES[i];
            if (!grassPlantState.func_177230_c().canRenderInLayer(grassPlantState, initialBlockRenderLayer)) continue;
            BlockRenderLayer correctedBlockRenderLayer = ClientUtil.getCorrectRenderLayer(initialBlockRenderLayer);
            int correctedBlockRenderLayerOrdinal = correctedBlockRenderLayer.ordinal();
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)correctedBlockRenderLayer);
            BufferBuilder bufferBuilder = ClientUtil.startOrContinueBufferBuilder(chunkRenderTask, correctedBlockRenderLayerOrdinal, compiledChunk, correctedBlockRenderLayer, chunkRender, chunkRenderPos);
            boolean wasAnythingRendered = false;
            OptiFineCompatibility.pushShaderThing(grassPlantState, texturePos, reader, bufferBuilder);
            try {
                for (int directionIndex = 0; directionIndex < ModelHelper.DIRECTION_QUADS_ORDERED_LENGTH; ++directionIndex) {
                    Direction direction = ModelHelper.DIRECTION_QUADS_ORDERED[directionIndex];
                    random.setSeed(posRand);
                    List quads = model.func_200117_a(grassPlantState, direction, random);
                    int quadsSize = quads.size();
                    for (int quadIndex = 0; quadIndex < quadsSize; ++quadIndex) {
                        double r3z;
                        double r3y;
                        double r3x;
                        double r2z;
                        double r2y;
                        double r2x;
                        double r1z;
                        double r1y;
                        double r1x;
                        double r0z;
                        double r0y;
                        double r0x;
                        boolean qr3z;
                        BakedQuad quad = (BakedQuad)quads.get(quadIndex);
                        wasAnythingRendered = true;
                        int formatSize = quad.getFormat().func_181719_f();
                        int[] vertexData = quad.func_178209_a();
                        float qv0x = Float.intBitsToFloat(vertexData[0]);
                        float qv0y = Float.intBitsToFloat(vertexData[1]);
                        float qv0z = Float.intBitsToFloat(vertexData[2]);
                        float qv1x = Float.intBitsToFloat(vertexData[formatSize]);
                        float qv1y = Float.intBitsToFloat(vertexData[formatSize + 1]);
                        float qv1z = Float.intBitsToFloat(vertexData[formatSize + 2]);
                        float qv2x = Float.intBitsToFloat(vertexData[formatSize * 2]);
                        float qv2y = Float.intBitsToFloat(vertexData[formatSize * 2 + 1]);
                        float qv2z = Float.intBitsToFloat(vertexData[formatSize * 2 + 2]);
                        float qv3x = Float.intBitsToFloat(vertexData[formatSize * 3]);
                        float qv3y = Float.intBitsToFloat(vertexData[formatSize * 3 + 1]);
                        float qv3z = Float.intBitsToFloat(vertexData[formatSize * 3 + 2]);
                        boolean qr0x = qv0x > 0.5f;
                        boolean qr0y = qv0y > 0.5f;
                        boolean qr0z = qv0z > 0.5f;
                        boolean qr1x = qv1x > 0.5f;
                        boolean qr1y = qv1y > 0.5f;
                        boolean qr1z = qv1z > 0.5f;
                        boolean qr2x = qv2x > 0.5f;
                        boolean qr2y = qv2y > 0.5f;
                        boolean qr2z = qv2z > 0.5f;
                        boolean qr3x = qv3x > 0.5f;
                        boolean qr3y = qv3y > 0.5f;
                        boolean bl = qr3z = qv3z > 0.5f;
                        if (qr0x && qr0y && qr0z) {
                            r0x = v1x;
                            r0y = v1y + 0.25;
                            r0z = v1z;
                        } else if (qr0x && qr0y && !qr0z) {
                            r0x = v0x;
                            r0y = v0y + 0.25;
                            r0z = v0z;
                        } else if (qr0x && !qr0y && qr0z) {
                            r0x = v1x;
                            r0y = v1y;
                            r0z = v1z;
                        } else if (qr0x && !qr0y && !qr0z) {
                            r0x = v0x;
                            r0y = v0y;
                            r0z = v0z;
                        } else if (!qr0x && qr0y && qr0z) {
                            r0x = v2x;
                            r0y = v2y + 0.25;
                            r0z = v2z;
                        } else if (!qr0x && qr0y && !qr0z) {
                            r0x = v3x;
                            r0y = v3y + 0.25;
                            r0z = v3z;
                        } else if (!qr0x && !qr0y && qr0z) {
                            r0x = v2x;
                            r0y = v2y;
                            r0z = v2z;
                        } else {
                            r0x = v3x;
                            r0y = v3y;
                            r0z = v3z;
                        }
                        if (qr1x && qr1y && qr1z) {
                            r1x = v1x;
                            r1y = v1y + 0.25;
                            r1z = v1z;
                        } else if (qr1x && qr1y && !qr1z) {
                            r1x = v0x;
                            r1y = v0y + 0.25;
                            r1z = v0z;
                        } else if (qr1x && !qr1y && qr1z) {
                            r1x = v1x;
                            r1y = v1y;
                            r1z = v1z;
                        } else if (qr1x && !qr1y && !qr1z) {
                            r1x = v0x;
                            r1y = v0y;
                            r1z = v0z;
                        } else if (!qr1x && qr1y && qr1z) {
                            r1x = v2x;
                            r1y = v2y + 0.25;
                            r1z = v2z;
                        } else if (!qr1x && qr1y && !qr1z) {
                            r1x = v3x;
                            r1y = v3y + 0.25;
                            r1z = v3z;
                        } else if (!qr1x && !qr1y && qr1z) {
                            r1x = v2x;
                            r1y = v2y;
                            r1z = v2z;
                        } else {
                            r1x = v3x;
                            r1y = v3y;
                            r1z = v3z;
                        }
                        if (qr2x && qr2y && qr2z) {
                            r2x = v1x;
                            r2y = v1y + 0.25;
                            r2z = v1z;
                        } else if (qr2x && qr2y && !qr2z) {
                            r2x = v0x;
                            r2y = v0y + 0.25;
                            r2z = v0z;
                        } else if (qr2x && !qr2y && qr2z) {
                            r2x = v1x;
                            r2y = v1y;
                            r2z = v1z;
                        } else if (qr2x && !qr2y && !qr2z) {
                            r2x = v0x;
                            r2y = v0y;
                            r2z = v0z;
                        } else if (!qr2x && qr2y && qr2z) {
                            r2x = v2x;
                            r2y = v2y + 0.25;
                            r2z = v2z;
                        } else if (!qr2x && qr2y && !qr2z) {
                            r2x = v3x;
                            r2y = v3y + 0.25;
                            r2z = v3z;
                        } else if (!qr2x && !qr2y && qr2z) {
                            r2x = v2x;
                            r2y = v2y;
                            r2z = v2z;
                        } else {
                            r2x = v3x;
                            r2y = v3y;
                            r2z = v3z;
                        }
                        if (qr3x && qr3y && qr3z) {
                            r3x = v1x;
                            r3y = v1y + 0.25;
                            r3z = v1z;
                        } else if (qr3x && qr3y && !qr3z) {
                            r3x = v0x;
                            r3y = v0y + 0.25;
                            r3z = v0z;
                        } else if (qr3x && !qr3y && qr3z) {
                            r3x = v1x;
                            r3y = v1y;
                            r3z = v1z;
                        } else if (qr3x && !qr3y && !qr3z) {
                            r3x = v0x;
                            r3y = v0y;
                            r3z = v0z;
                        } else if (!qr3x && qr3y && qr3z) {
                            r3x = v2x;
                            r3y = v2y + 0.25;
                            r3z = v2z;
                        } else if (!qr3x && qr3y && !qr3z) {
                            r3x = v3x;
                            r3y = v3y + 0.25;
                            r3z = v3z;
                        } else if (!qr3x && !qr3y && qr3z) {
                            r3x = v2x;
                            r3y = v2y;
                            r3z = v2z;
                        } else {
                            r3x = v3x;
                            r3y = v3y;
                            r3z = v3z;
                        }
                        float v0u = Float.intBitsToFloat(vertexData[4]);
                        float v0v = Float.intBitsToFloat(vertexData[5]);
                        float v1u = Float.intBitsToFloat(vertexData[formatSize + 4]);
                        float v1v = Float.intBitsToFloat(vertexData[formatSize + 5]);
                        float v2u = Float.intBitsToFloat(vertexData[formatSize * 2 + 4]);
                        float v2v = Float.intBitsToFloat(vertexData[formatSize * 2 + 5]);
                        float v3u = Float.intBitsToFloat(vertexData[formatSize * 3 + 4]);
                        float v3v = Float.intBitsToFloat(vertexData[formatSize * 3 + 5]);
                        boolean quadSkyLight0 = false;
                        boolean quadSkyLight1 = false;
                        boolean quadSkyLight2 = false;
                        boolean quadSkyLight3 = false;
                        boolean quadBlockLight0 = false;
                        boolean quadBlockLight1 = false;
                        boolean quadBlockLight2 = false;
                        boolean quadBlockLight3 = false;
                        bufferBuilder.func_181662_b(offX + r0x, 0.0 + r0y, offZ + r0z).func_181669_b(red, green, blue, 255).func_187315_a((double)v0u, (double)v0v).func_187314_a(0 >= lightmapSkyLight0 ? 0 : lightmapSkyLight0, 0 >= lightmapBlockLight0 ? 0 : lightmapBlockLight0).func_181675_d();
                        bufferBuilder.func_181662_b(offX + r1x, 0.0 + r1y, offZ + r1z).func_181669_b(red, green, blue, 255).func_187315_a((double)v1u, (double)v1v).func_187314_a(0 >= lightmapSkyLight1 ? 0 : lightmapSkyLight1, 0 >= lightmapBlockLight1 ? 0 : lightmapBlockLight1).func_181675_d();
                        bufferBuilder.func_181662_b(offX + r2x, 0.0 + r2y, offZ + r2z).func_181669_b(red, green, blue, 255).func_187315_a((double)v2u, (double)v2v).func_187314_a(0 >= lightmapSkyLight2 ? 0 : lightmapSkyLight2, 0 >= lightmapBlockLight2 ? 0 : lightmapBlockLight2).func_181675_d();
                        bufferBuilder.func_181662_b(offX + r3x, 0.0 + r3y, offZ + r3z).func_181669_b(red, green, blue, 255).func_187315_a((double)v3u, (double)v3v).func_187314_a(0 >= lightmapSkyLight3 ? 0 : lightmapSkyLight3, 0 >= lightmapBlockLight3 ? 0 : lightmapBlockLight3).func_181675_d();
                    }
                }
            }
            finally {
                OptiFineCompatibility.popShaderThing(bufferBuilder);
            }
            int n = correctedBlockRenderLayerOrdinal;
            usedBlockRenderLayers[n] = usedBlockRenderLayers[n] | wasAnythingRendered;
        }
        ForgeHooksClient.setRenderLayer(null);
    }

    private static boolean areVerticesCloseToFlat(Vec3 v0, Vec3 v1, Vec3 v2, Vec3 v3) {
        double v0y = v0.y;
        double v1y = v1.y;
        double v2y = v2.y;
        double v3y = v3.y;
        return MeshRenderer.max(v0y, v1y, v2y, v3y) - MeshRenderer.min(v0y, v1y, v2y, v3y) <= 0.25;
    }

    private static double max(double d0, double d1, double d2, double d3) {
        if (d0 < d1) {
            d0 = d1;
        }
        if (d0 < d2) {
            d0 = d2;
        }
        return d0 < d3 ? d3 : d0;
    }

    private static double min(double d0, double d1, double d2, double d3) {
        if (d0 > d1) {
            d0 = d1;
        }
        if (d0 > d2) {
            d0 = d2;
        }
        return d0 > d3 ? d3 : d0;
    }

    private static Direction toSide(double x, double y, double z) {
        if (Math.abs(x) > Math.abs(y)) {
            if (Math.abs(x) > Math.abs(z)) {
                if (x < 0.0) {
                    return Direction.WEST;
                }
                return Direction.EAST;
            }
            if (z < 0.0) {
                return Direction.NORTH;
            }
            return Direction.SOUTH;
        }
        if (Math.abs(y) > Math.abs(z)) {
            if (y < 0.0) {
                return Direction.DOWN;
            }
            return Direction.UP;
        }
        if (z < 0.0) {
            return Direction.NORTH;
        }
        return Direction.SOUTH;
    }

    private static float diffuseLight(Direction side) {
        if (side == Direction.UP) {
            return 1.0f;
        }
        return 0.97f;
    }
}

