/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.StateHolder;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.IModelData;

public final class ModelHelper {
    public static final Direction[] DIRECTION_QUADS_ORDERED = new Direction[]{Direction.UP, null, Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public static final int DIRECTION_QUADS_ORDERED_LENGTH = DIRECTION_QUADS_ORDERED.length;

    @Nullable
    public static List<BakedQuad> getQuads(BlockState state, BlockPos pos, BufferBuilder bufferBuilder, IBlockReader reader, BlockRendererDispatcher blockRendererDispatcher, IModelData modelData, Random posRand, BlockRenderLayer blockRenderLayer) {
        IBakedModel model = ModelHelper.getModel(state, blockRendererDispatcher);
        for (int facingIndex = 0; facingIndex < DIRECTION_QUADS_ORDERED_LENGTH; ++facingIndex) {
            Direction facing = DIRECTION_QUADS_ORDERED[facingIndex];
            List quads = model.getQuads(state, facing, posRand, modelData);
            if (quads.isEmpty()) continue;
            return quads;
        }
        return null;
    }

    @Nonnull
    public static IBakedModel getModel(BlockState state, BlockRendererDispatcher blockRendererDispatcher) {
        try (ModProfiler ignored = ModProfiler.get().start("getModel");){
            if (ClientUtil.isStateSnow(state)) {
                IBakedModel iBakedModel = blockRendererDispatcher.func_184389_a(StateHolder.SNOW_LAYER_DEFAULT);
                return iBakedModel;
            }
            IBakedModel iBakedModel = blockRendererDispatcher.func_184389_a(state);
            return iBakedModel;
        }
    }
}

