/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.util.pooled.cache.XYZCache;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import org.apache.logging.log4j.LogManager;

public final class LazyBlockColorCache
extends XYZCache
implements AutoCloseable {
    private static final ThreadLocal<LazyBlockColorCache> POOL = ThreadLocal.withInitial(() -> new LazyBlockColorCache(0, 0, 0, 0, 0, 0));
    private static final ThreadLocal<BlockPos.MutableBlockPos> MUTABLE_BLOCK_POS = ThreadLocal.withInitial(BlockPos.MutableBlockPos::new);
    public int chunkRenderPosX;
    public int chunkRenderPosY;
    public int chunkRenderPosZ;
    @Nonnull
    public IEnviromentBlockReader reader;
    @Nonnull
    public int[] cache;
    @Nonnull
    public BiomeColors.IColorResolver colorResolver;
    @Nonnull
    public Predicate<BlockState> shouldApply;
    private boolean inUse;

    private LazyBlockColorCache(int startPaddingX, int startPaddingY, int startPaddingZ, int sizeX, int sizeY, int sizeZ) {
        super(startPaddingX, startPaddingY, startPaddingZ, sizeX, sizeY, sizeZ);
        int size = sizeX * sizeY * sizeZ;
        this.cache = new int[size];
        System.arraycopy(ClientUtil.NEGATIVE_1_8000, 0, this.cache, 0, size);
        this.inUse = false;
    }

    @Nonnull
    public static LazyBlockColorCache retain(int startPaddingX, int startPaddingY, int startPaddingZ, int sizeX, int sizeY, int sizeZ, @Nonnull IEnviromentBlockReader reader, @Nonnull BiomeColors.IColorResolver colorResolver, @Nonnull Predicate<BlockState> shouldApply, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ) {
        LazyBlockColorCache pooled = POOL.get();
        if (pooled.inUse) {
            throw new IllegalStateException("LazyBlockColorCache is already in use!");
        }
        pooled.inUse = true;
        pooled.reader = reader;
        pooled.colorResolver = colorResolver;
        pooled.shouldApply = shouldApply;
        pooled.chunkRenderPosX = chunkRenderPosX;
        pooled.chunkRenderPosY = chunkRenderPosY;
        pooled.chunkRenderPosZ = chunkRenderPosZ;
        pooled.startPaddingX = startPaddingX;
        pooled.startPaddingY = startPaddingY;
        pooled.startPaddingZ = startPaddingZ;
        int size = sizeX * sizeY * sizeZ;
        if (pooled.sizeX == sizeX && pooled.sizeY == sizeY && pooled.sizeZ == sizeZ) {
            System.arraycopy(ClientUtil.NEGATIVE_1_8000, 0, pooled.cache, 0, size);
            return pooled;
        }
        pooled.sizeX = sizeX;
        pooled.sizeY = sizeY;
        pooled.sizeZ = sizeZ;
        if (pooled.cache.length < size || (float)pooled.cache.length > (float)size * 1.25f) {
            pooled.cache = new int[size];
        }
        System.arraycopy(ClientUtil.NEGATIVE_1_8000, 0, pooled.cache, 0, size);
        return pooled;
    }

    public static int get(int xIn, int yIn, int zIn, int[] cache, int index, int radius, int area, int max, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, BlockPos.MutableBlockPos pos, IEnviromentBlockReader reader, BiomeColors.IColorResolver colorResolver, boolean useCache) {
        try {
            if (useCache) {
                int color = cache[index];
                if (color == -1) {
                    cache[index] = color = LazyBlockColorCache.getColor(xIn, yIn, zIn, radius, area, max, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, pos, reader, colorResolver);
                    if (color == -1) {
                        LogManager.getLogger().error("Color = -1. wtf");
                    }
                }
                return color;
            }
            return LazyBlockColorCache.getColor(xIn, yIn, zIn, radius, area, max, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, pos, reader, colorResolver);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new CustomArrayIndexOutOfBoundsException(xIn, yIn, zIn, cache, index, radius, area, max, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, pos, reader, colorResolver, e);
        }
    }

    public static int getColor(int xIn, int yIn, int zIn, int radius, int area, int max, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, BlockPos.MutableBlockPos pos, IEnviromentBlockReader reader, BiomeColors.IColorResolver colorResolver) {
        int red = 0;
        int green = 0;
        int blue = 0;
        int posX = chunkRenderPosX + xIn - 2;
        int posY = chunkRenderPosY + yIn - 2;
        int posZ = chunkRenderPosZ + zIn - 2;
        int currentChunkPosX = posX >> 4;
        int currentChunkPosZ = posZ >> 4;
        Biome[] currentChunkBiomes = ClientUtil.getChunk(currentChunkPosX, currentChunkPosZ, reader).func_201590_e();
        for (int zOffset = -radius; zOffset < max; ++zOffset) {
            for (int xOffset = -radius; xOffset < max; ++xOffset) {
                int x = posX + xOffset;
                int z = posZ + zOffset;
                if (currentChunkPosX != x >> 4 || currentChunkPosZ != z >> 4) {
                    currentChunkPosX = x >> 4;
                    currentChunkPosZ = z >> 4;
                    currentChunkBiomes = ClientUtil.getChunk(currentChunkPosX, currentChunkPosZ, reader).func_201590_e();
                }
                pos.func_181079_c(x, posY, z);
                int resolvedColor = colorResolver.getColor(currentChunkBiomes[(z & 0xF) << 4 | x & 0xF], (BlockPos)pos);
                red += (resolvedColor & 0xFF0000) >> 16;
                green += (resolvedColor & 0xFF00) >> 8;
                blue += resolvedColor & 0xFF;
            }
        }
        return (red / area & 0xFF) << 16 | (green / area & 0xFF) << 8 | blue / area & 0xFF;
    }

    @Override
    public void close() {
        this.inUse = false;
    }

    @Deprecated
    public int get(int xIn, int yIn, int zIn) {
        int biomeBlendRadius = Minecraft.func_71410_x().field_71474_y.field_205217_U;
        int d = biomeBlendRadius * 2 + 1;
        return LazyBlockColorCache.get(xIn, yIn, zIn, this.cache, this.getIndex(xIn, yIn, zIn, this.sizeX, this.sizeY), biomeBlendRadius, d * d, biomeBlendRadius + 1, this.chunkRenderPosX, this.chunkRenderPosY, this.chunkRenderPosZ, MUTABLE_BLOCK_POS.get(), this.reader, this.colorResolver, true);
    }

    @Deprecated
    public int get(int xIn, int yIn, int zIn, int[] cache, int radius, int area, int max, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, BlockPos.MutableBlockPos pos, IEnviromentBlockReader reader, BiomeColors.IColorResolver colorResolver, boolean useCache) {
        return LazyBlockColorCache.get(xIn, yIn, zIn, cache, this.getIndex(xIn, yIn, zIn, this.sizeX, this.sizeY), radius, area, max, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, pos, reader, colorResolver, useCache);
    }

    private static class CustomArrayIndexOutOfBoundsException
    extends EnhancedRuntimeException {
        private final int xIn;
        private final int yIn;
        private final int zIn;
        private final int[] cache;
        private final int index;
        private final int radius;
        private final int area;
        private final int max;
        private final int chunkRenderPosX;
        private final int chunkRenderPosY;
        private final int chunkRenderPosZ;
        private final BlockPos.MutableBlockPos pos;
        private final IEnviromentBlockReader reader;
        private final BiomeColors.IColorResolver colorResolver;

        CustomArrayIndexOutOfBoundsException(int xIn, int yIn, int zIn, int[] cache, int index, int radius, int area, int max, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, BlockPos.MutableBlockPos pos, IEnviromentBlockReader reader, BiomeColors.IColorResolver colorResolver, ArrayIndexOutOfBoundsException e) {
            super((Throwable)e);
            this.xIn = xIn;
            this.yIn = yIn;
            this.zIn = zIn;
            this.cache = cache;
            this.index = index;
            this.radius = radius;
            this.area = area;
            this.max = max;
            this.chunkRenderPosX = chunkRenderPosX;
            this.chunkRenderPosY = chunkRenderPosY;
            this.chunkRenderPosZ = chunkRenderPosZ;
            this.pos = pos;
            this.reader = reader;
            this.colorResolver = colorResolver;
        }

        protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
            stream.println("xIn: " + this.xIn);
            stream.println("yIn: " + this.yIn);
            stream.println("zIn: " + this.zIn);
            stream.println("cache: " + this.cache);
            stream.println("index: " + this.index);
            stream.println("radius: " + this.radius);
            stream.println("area: " + this.area);
            stream.println("max: " + this.max);
            stream.println("chunkRenderPosX: " + this.chunkRenderPosX);
            stream.println("chunkRenderPosY: " + this.chunkRenderPosY);
            stream.println("chunkRenderPosZ: " + this.chunkRenderPosZ);
            stream.println("pos: " + this.pos);
            stream.println("reader: " + this.reader);
            stream.println("colorResolver: " + this.colorResolver);
        }
    }
}

