/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import cpw.mods.modlauncher.api.INameMappingService;
import io.github.cadiboo.nocubes.client.optifine.OptiFineCompatibility;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.StateHolder;
import io.github.cadiboo.nocubes.util.pooled.cache.SmoothableCache;
import io.github.cadiboo.nocubes.util.pooled.cache.StateCache;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.renderer.chunk.ChunkRenderTask;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.Region;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IRegistryDelegate;

public final class ClientUtil {
    public static final BlockRenderLayer[] BLOCK_RENDER_LAYER_VALUES = BlockRenderLayer.values();
    public static final int BLOCK_RENDER_LAYER_VALUES_LENGTH = BLOCK_RENDER_LAYER_VALUES.length;
    static final int[] NEGATIVE_1_8000 = new int[8000];
    private static final Field BLOCK_COLORS_REGISTRY = ClientUtil.findBlockColorsRegistryField();
    private static final int[][] OFFSETS_ORDERED = new int[][]{{0, -1, 0}, {0, 1, 0}, {-1, 0, 0}, {1, 0, 0}, {0, 0, -1}, {0, 0, 1}, {-1, -1, 0}, {-1, 0, -1}, {-1, 0, 1}, {-1, 1, 0}, {0, -1, -1}, {0, -1, 1}, {0, 1, -1}, {0, 1, 1}, {1, -1, 0}, {1, 0, -1}, {1, 0, 1}, {1, 1, 0}, {1, 1, 1}, {1, 1, -1}, {-1, 1, 1}, {-1, 1, -1}, {1, -1, 1}, {1, -1, -1}, {-1, -1, 1}, {-1, -1, -1}};

    @Nonnull
    public static BlockState getTexturePosAndState(int posX, int posY, int posZ, @Nonnull BlockPos.PooledMutableBlockPos texturePooledMutablePos, @Nonnull StateCache stateCache, @Nonnull SmoothableCache smoothableCache, byte relativePosX, byte relativePosY, byte relativePosZ, boolean tryForBetterTexturesSnow, boolean tryForBetterTexturesGrass) {
        boolean[] smoothableCacheArray = smoothableCache.getSmoothableCache();
        BlockState[] blockCacheArray = stateCache.getBlockStates();
        int stateCacheStartPaddingX = stateCache.startPaddingX;
        int stateCacheStartPaddingY = stateCache.startPaddingY;
        int stateCacheStartPaddingZ = stateCache.startPaddingZ;
        int stateCacheSizeX = stateCache.sizeX;
        int stateCacheSizeY = stateCache.sizeY;
        if (Config.betterTextures) {
            Throwable throwable;
            ModProfiler ignored;
            if (tryForBetterTexturesSnow) {
                ignored = ModProfiler.get().start("getTexturePosAndState-tryForBetterTextures-snow");
                throwable = null;
                try {
                    BlockState betterTextureState2 = blockCacheArray[stateCache.getIndex(relativePosX + stateCacheStartPaddingX, relativePosY + stateCacheStartPaddingY, relativePosZ + stateCacheStartPaddingZ, stateCacheSizeX, stateCacheSizeY)];
                    if (ClientUtil.isStateSnow(betterTextureState2)) {
                        texturePooledMutablePos.func_181079_c(posX, posY, posZ);
                        BlockState blockState = betterTextureState2;
                        return blockState;
                    }
                    for (int[] offset : OFFSETS_ORDERED) {
                        betterTextureState2 = blockCacheArray[stateCache.getIndex(relativePosX + offset[0] + stateCacheStartPaddingX, relativePosY + offset[1] + stateCacheStartPaddingY, relativePosZ + offset[2] + stateCacheStartPaddingZ, stateCacheSizeX, stateCacheSizeY)];
                        if (!ClientUtil.isStateSnow(betterTextureState2)) continue;
                        texturePooledMutablePos.func_181079_c(posX + offset[0], posY + offset[1], posZ + offset[2]);
                        BlockState blockState = betterTextureState2;
                        return blockState;
                    }
                }
                catch (Throwable betterTextureState2) {
                    throwable = betterTextureState2;
                    throw betterTextureState2;
                }
                finally {
                    if (ignored != null) {
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                }
            }
            if (tryForBetterTexturesGrass) {
                ignored = ModProfiler.get().start("getTexturePosAndState-tryForBetterTextures-grass");
                throwable = null;
                try {
                    BlockState betterTextureState3 = blockCacheArray[stateCache.getIndex(relativePosX + stateCacheStartPaddingX, relativePosY + stateCacheStartPaddingY, relativePosZ + stateCacheStartPaddingZ, stateCacheSizeX, stateCacheSizeY)];
                    if (ClientUtil.isStateGrass(betterTextureState3)) {
                        texturePooledMutablePos.func_181079_c(posX, posY, posZ);
                        BlockState blockState = betterTextureState3;
                        return blockState;
                    }
                    for (int[] offset : OFFSETS_ORDERED) {
                        betterTextureState3 = blockCacheArray[stateCache.getIndex(relativePosX + offset[0] + stateCacheStartPaddingX, relativePosY + offset[1] + stateCacheStartPaddingY, relativePosZ + offset[2] + stateCacheStartPaddingZ, stateCacheSizeX, stateCacheSizeY)];
                        if (!ClientUtil.isStateGrass(betterTextureState3)) continue;
                        texturePooledMutablePos.func_181079_c(posX + offset[0], posY + offset[1], posZ + offset[2]);
                        BlockState blockState = betterTextureState3;
                        return blockState;
                    }
                }
                catch (Throwable betterTextureState3) {
                    throwable = betterTextureState3;
                    throw betterTextureState3;
                }
                finally {
                    if (ignored != null) {
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                }
            }
        }
        int smoothableCacheStartPaddingX = smoothableCache.startPaddingX;
        int smoothableCacheStartPaddingY = smoothableCache.startPaddingY;
        int smoothableCacheStartPaddingZ = smoothableCache.startPaddingZ;
        int n = smoothableCache.sizeX;
        int smoothableCacheSizeY = smoothableCache.sizeY;
        try (ModProfiler ignored = ModProfiler.get().start("getTexturePosAndState");){
            if (smoothableCacheArray[smoothableCache.getIndex(relativePosX + smoothableCacheStartPaddingX, relativePosY + smoothableCacheStartPaddingY, relativePosZ + smoothableCacheStartPaddingZ, n, smoothableCacheSizeY)]) {
                texturePooledMutablePos.func_181079_c(posX, posY, posZ);
                BlockState blockState = blockCacheArray[stateCache.getIndex(relativePosX + stateCacheStartPaddingX, relativePosY + stateCacheStartPaddingY, relativePosZ + stateCacheStartPaddingZ, stateCacheSizeX, stateCacheSizeY)];
                return blockState;
            }
            BlockState state = blockCacheArray[stateCache.getIndex(relativePosX + stateCacheStartPaddingX, relativePosY + stateCacheStartPaddingY, relativePosZ + stateCacheStartPaddingZ, stateCacheSizeX, stateCacheSizeY)];
            for (int[] offset : OFFSETS_ORDERED) {
                if (!smoothableCacheArray[smoothableCache.getIndex(relativePosX + offset[0] + smoothableCacheStartPaddingX, relativePosY + offset[1] + smoothableCacheStartPaddingY, relativePosZ + offset[2] + smoothableCacheStartPaddingZ, n, smoothableCacheSizeY)]) continue;
                texturePooledMutablePos.func_181079_c(posX + offset[0], posY + offset[1], posZ + offset[2]);
                state = blockCacheArray[stateCache.getIndex(relativePosX + offset[0] + stateCacheStartPaddingX, relativePosY + offset[1] + stateCacheStartPaddingY, relativePosZ + offset[2] + stateCacheStartPaddingZ, stateCacheSizeX, stateCacheSizeY)];
                break;
            }
            BlockState blockState = state;
            return blockState;
        }
    }

    public static boolean isStateSnow(BlockState checkState) {
        if (checkState == StateHolder.SNOW_LAYER_DEFAULT) {
            return true;
        }
        if (checkState == StateHolder.GRASS_BLOCK_SNOWY) {
            return true;
        }
        return checkState == StateHolder.PODZOL_SNOWY;
    }

    private static boolean isStateGrass(BlockState checkState) {
        return checkState == StateHolder.GRASS_BLOCK_DEFAULT;
    }

    @Nonnull
    @Deprecated
    public static BlockRenderLayer getCorrectRenderLayer(@Nonnull BlockState state) {
        return ClientUtil.getCorrectRenderLayer(state.func_177230_c().func_180664_k());
    }

    @Nonnull
    @Deprecated
    public static BlockRenderLayer getCorrectRenderLayer(@Nonnull IFluidState state) {
        return ClientUtil.getCorrectRenderLayer(state.func_180664_k());
    }

    @Nonnull
    public static BlockRenderLayer getCorrectRenderLayer(@Nonnull BlockRenderLayer blockRenderLayer) {
        switch (blockRenderLayer) {
            default: {
                return blockRenderLayer;
            }
            case CUTOUT_MIPPED: {
                return Minecraft.func_71410_x().field_71474_y.field_151442_I == 0 ? BlockRenderLayer.CUTOUT : BlockRenderLayer.CUTOUT_MIPPED;
            }
            case CUTOUT: 
        }
        return Minecraft.func_71410_x().field_71474_y.field_151442_I != 0 ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.CUTOUT;
    }

    public static BufferBuilder startOrContinueBufferBuilder(ChunkRenderTask generator, int blockRenderLayerOrdinal, CompiledChunk compiledChunk, BlockRenderLayer blockRenderLayer, ChunkRender chunkRender, BlockPos renderChunkPosition) {
        BufferBuilder bufferBuilder = generator.func_178545_d().func_179039_a(blockRenderLayerOrdinal);
        if (!compiledChunk.func_178492_d(blockRenderLayer)) {
            compiledChunk.func_178493_c(blockRenderLayer);
            chunkRender.func_178573_a(bufferBuilder, renderChunkPosition);
        }
        return bufferBuilder;
    }

    public static void tryReloadRenderers() {
        WorldRenderer worldRenderer = Minecraft.func_71410_x().field_71438_f;
        if (worldRenderer != null) {
            worldRenderer.func_72712_a();
        }
    }

    public static IChunk getChunk(int currentChunkPosX, int currentChunkPosZ, IEnviromentBlockReader reader) {
        if (reader instanceof ChunkRenderCache) {
            ChunkRenderCache renderChunkCache = (ChunkRenderCache)reader;
            int x = currentChunkPosX - renderChunkCache.field_212400_a;
            int z = currentChunkPosZ - renderChunkCache.field_212401_b;
            return renderChunkCache.field_212406_g[x][z];
        }
        if (OptiFineCompatibility.isChunkCacheOF(reader)) {
            Region region = OptiFineCompatibility.getRegion(reader);
            int x = currentChunkPosX - region.field_72818_a;
            int z = currentChunkPosZ - region.field_72816_b;
            return region.field_72817_c[x][z];
        }
        throw new IllegalStateException("Should Not Reach Here!");
    }

    public static void setupChunkRenderCache(ChunkRenderCache _this, int chunkStartX, int chunkStartZ, Chunk[][] chunks, BlockPos start, BlockPos end) {
        int startX = start.func_177958_n();
        int startY = start.func_177956_o();
        int startZ = start.func_177952_p();
        int cacheSizeX = end.func_177958_n() - startX + 1;
        int cacheSizeY = end.func_177956_o() - startY + 1;
        int cacheSizeZ = end.func_177952_p() - startZ + 1;
        int size = cacheSizeX * cacheSizeY * cacheSizeZ;
        BlockState[] blockStates = new BlockState[size];
        IFluidState[] fluidStates = new IFluidState[size];
        int cx = (startX >> 4) - chunkStartX;
        int cz = (startZ >> 4) - chunkStartZ;
        Chunk currentChunk = chunks[cx][cz];
        try (BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            int index = 0;
            for (int z = 0; z < cacheSizeZ; ++z) {
                for (int y = 0; y < cacheSizeY; ++y) {
                    int x = 0;
                    while (x < cacheSizeX) {
                        BlockState blockState;
                        int posX = startX + x;
                        int posY = startY + y;
                        int posZ = startZ + z;
                        int ccx = (startX + x >> 4) - chunkStartX;
                        int ccz = (startZ + z >> 4) - chunkStartZ;
                        boolean changed = false;
                        if (cx != ccx) {
                            cx = ccx;
                            changed = true;
                        }
                        if (cz != ccz) {
                            cz = ccz;
                            changed = true;
                        }
                        if (changed) {
                            currentChunk = chunks[cx][cz];
                        }
                        pooledMutableBlockPos.func_181079_c(posX, posY, posZ);
                        blockStates[index] = blockState = currentChunk.func_180495_p((BlockPos)pooledMutableBlockPos);
                        fluidStates[index] = blockState.func_204520_s();
                        ++x;
                        ++index;
                    }
                }
            }
        }
        _this.field_212403_d = cacheSizeX;
        _this.field_212404_e = cacheSizeY;
        _this.field_212405_f = cacheSizeZ;
        _this.field_217340_h = blockStates;
        _this.field_217341_i = fluidStates;
    }

    private static Field findBlockColorsRegistryField() {
        String fieldName = ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)"field_186725_a");
        try {
            Field field = BlockColors.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            CrashReport crashReport = new CrashReport("Unable to find field \"" + fieldName + "\". Field does not exist!", (Throwable)e);
            crashReport.func_85058_a("Finding Field");
            throw new ReportedException(crashReport);
        }
    }

    public static Map<IRegistryDelegate<Block>, IBlockColor> getBlockColorsRegistry(BlockColors blockColors) {
        try {
            return (Map)BLOCK_COLORS_REGISTRY.get(blockColors);
        }
        catch (IllegalAccessException e) {
            CrashReport crashReport = new CrashReport("Unable to access field!", (Throwable)e);
            crashReport.func_85058_a("Accessing Field");
            throw new ReportedException(crashReport);
        }
    }

    static {
        Arrays.fill(NEGATIVE_1_8000, -1);
    }
}

