/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import com.mojang.blaze3d.platform.GlStateManager;
import io.github.cadiboo.nocubes.client.ClientProxy;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.gui.toast.BlockStateToast;
import io.github.cadiboo.nocubes.client.gui.widget.IngameModListButton;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.config.ConfigHelper;
import io.github.cadiboo.nocubes.mesh.MeshDispatcher;
import io.github.cadiboo.nocubes.mesh.MeshGeneratorType;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.pooled.Face;
import io.github.cadiboo.nocubes.util.pooled.FaceList;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.PlayerSPPushOutOfBlocksEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.network.ConnectionType;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;

@Mod.EventBusSubscriber(modid="nocubes", value={Dist.CLIENT})
public final class ClientEventSubscriber {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        RayTraceResult objectMouseOver;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayNetHandler connection = minecraft.func_147114_u();
        if (connection != null) {
            if (NetworkHooks.getConnectionType(() -> ((ClientPlayNetHandler)connection).func_147298_b()) != ConnectionType.MODDED) {
                Config.terrainCollisions = false;
            }
        }
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (ClientProxy.toggleRenderSmoothTerrain.func_151468_f()) {
            boolean newRenderSmoothTerrain = !Config.renderSmoothTerrain;
            ConfigHelper.setRenderSmoothTerrain(newRenderSmoothTerrain);
            Config.renderSmoothTerrain = newRenderSmoothTerrain;
            ClientUtil.tryReloadRenderers();
            return;
        }
        if (ClientProxy.toggleRenderSmoothLeaves.func_151468_f()) {
            boolean newRenderSmoothLeaves = !Config.renderSmoothLeaves;
            ConfigHelper.setRenderSmoothLeaves(newRenderSmoothLeaves);
            Config.renderSmoothLeaves = newRenderSmoothLeaves;
            ClientUtil.tryReloadRenderers();
            return;
        }
        if (ClientProxy.tempToggleTerrainCollisions.func_151468_f()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("nocubes.collisionsBroken114", new Object[0]));
        }
        boolean terrainPressed = ClientProxy.toggleTerrainSmoothableBlockState.func_151468_f();
        boolean leavesPressed = ClientProxy.toggleLeavesSmoothableBlockState.func_151468_f();
        if ((terrainPressed || leavesPressed) && (objectMouseOver = minecraft.field_71476_x).func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockStateToast toast;
            BlockPos blockPos = ((BlockRayTraceResult)objectMouseOver).func_216350_a();
            BlockState state = minecraft.field_71441_e.func_180495_p(blockPos);
            if (terrainPressed) {
                if (!minecraft.func_71356_B()) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("nocubes.terrainSmoothableNotSingleplayer", new Object[0]));
                }
                if (!state.nocubes_isTerrainSmoothable()) {
                    ConfigHelper.addTerrainSmoothable(state);
                    toast = new BlockStateToast.AddTerrain(state, blockPos);
                } else {
                    ConfigHelper.removeTerrainSmoothable(state);
                    toast = new BlockStateToast.RemoveTerrain(state, blockPos);
                }
                minecraft.func_193033_an().func_192988_a((IToast)toast);
                if (Config.renderSmoothTerrain) {
                    ClientUtil.tryReloadRenderers();
                }
            }
            if (leavesPressed) {
                if (!state.nocubes_isLeavesSmoothable()) {
                    ConfigHelper.addLeavesSmoothable(state);
                    toast = new BlockStateToast.AddLeaves(state, blockPos);
                } else {
                    ConfigHelper.removeLeavesSmoothable(state);
                    toast = new BlockStateToast.RemoveLeaves(state, blockPos);
                }
                minecraft.func_193033_an().func_192988_a((IToast)toast);
                if (Config.renderSmoothLeaves) {
                    ClientUtil.tryReloadRenderers();
                }
            }
        }
        if (ClientProxy.toggleProfilers.func_151468_f()) {
            HashMap<Thread, ModProfiler> hashMap = ModProfiler.PROFILERS;
            synchronized (hashMap) {
                if (ModProfiler.profilersEnabled) {
                    ModProfiler.disableProfiling();
                } else {
                    ModProfiler.enableProfiling();
                }
            }
        }
    }

    private static boolean canEnableTerrainCollisions(Minecraft minecraft, ClientPlayerEntity player) {
        boolean topAllSolid = true;
        boolean topAllNonSolid = true;
        boolean bottomAllSolid = true;
        boolean bottomAllNonSolid = true;
        BlockPos playerPos = player.func_180425_c();
        int playerPosX = playerPos.func_177958_n();
        int playerPosY = playerPos.func_177956_o();
        int playerPosZ = playerPos.func_177952_p();
        ClientWorld world = minecraft.field_71441_e;
        try (BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (int x = -2; x < 3; ++x) {
                for (int z = -2; z < 3; ++z) {
                    pooledMutableBlockPos.func_181079_c(playerPosX + x, playerPosY, playerPosZ + z);
                    boolean topIsSolid = !world.func_180495_p((BlockPos)pooledMutableBlockPos).func_196952_d((IBlockReader)world, (BlockPos)pooledMutableBlockPos).func_197766_b();
                    topAllSolid &= topIsSolid;
                    topAllNonSolid &= !topIsSolid;
                    pooledMutableBlockPos.func_181079_c(playerPosX + x, playerPosY - 1, playerPosZ + z);
                    boolean bottomIsSolid = !world.func_180495_p((BlockPos)pooledMutableBlockPos).func_196952_d((IBlockReader)world, (BlockPos)pooledMutableBlockPos).func_197766_b();
                    bottomAllSolid &= bottomIsSolid;
                    bottomAllNonSolid &= !bottomIsSolid;
                }
            }
        }
        if (topAllNonSolid && bottomAllSolid) {
            return true;
        }
        return topAllNonSolid && bottomAllNonSolid;
    }

    @SubscribeEvent
    public static void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (!ModProfiler.profilersEnabled) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71441_e == null || minecraft.field_71439_g == null || minecraft.func_175606_aa() == null) {
            return;
        }
        IProfiler profiler = minecraft.func_213239_aq();
        profiler.func_76320_a("debugNoCubes");
        GlStateManager.pushMatrix();
        try {
            ClientEventSubscriber.renderProfilers();
        }
        catch (Exception e) {
            LogManager.getLogger((String)"NoCubes Profile Renderer").error("Error Rendering Profilers.", (Throwable)e);
        }
        GlStateManager.popMatrix();
        profiler.func_76319_b();
    }

    private static void renderProfilers() {
    }

    @SubscribeEvent
    public static void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        GameSettings gameSettings = minecraft.field_71474_y;
        if (!gameSettings.field_74330_P || !gameSettings.field_74329_Q || gameSettings.field_74319_N) {
            return;
        }
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        ActiveRenderInfo activeRenderInfo = minecraft.field_71460_t.func_215316_n();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.lineWidth((float)Math.max(2.5f, (float)minecraft.field_195558_d.func_198109_k() / 1920.0f * 2.5f));
        GlStateManager.disableTexture();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.matrixMode((int)5889);
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)1.0f, (float)1.0f, (float)0.999f);
        Vec3d projectedView = activeRenderInfo.func_216785_c();
        double d0 = projectedView.field_72450_a;
        double d1 = projectedView.field_72448_b;
        double d2 = projectedView.field_72449_c;
        for (VoxelShape voxelShape : world.func_223438_b((Entity)player, new AxisAlignedBB(player.func_180425_c()).func_186662_g(3.0)).collect(Collectors.toList())) {
            WorldRenderer.func_195463_b((VoxelShape)voxelShape, (double)(-d0), (double)(-d1), (double)(-d2), (float)0.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        }
        for (VoxelShape voxelShape : world.func_223438_b((Entity)player, new AxisAlignedBB(player.func_180425_c())).collect(Collectors.toList())) {
            WorldRenderer.func_195463_b((VoxelShape)voxelShape, (double)(-d0), (double)(-d1), (double)(-d2), (float)1.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        }
        GlStateManager.popMatrix();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
    }

    @SubscribeEvent
    public static void drawBlockHighlightEvent(DrawBlockHighlightEvent event) {
        MeshGeneratorType meshGeneratorType;
        IsSmoothable isSmoothable;
        if (!Config.renderSmoothTerrain && !Config.renderSmoothLeaves) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        RayTraceResult rayTraceResult = event.getTarget();
        if (rayTraceResult == null || rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        BlockPos pos = blockRayTraceResult.func_216350_a();
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.func_185904_a() == Material.field_151579_a || !world.func_175723_af().func_177746_a(pos)) {
            return;
        }
        if (Config.renderSmoothTerrain && blockState.nocubes_isTerrainSmoothable()) {
            isSmoothable = IsSmoothable.TERRAIN_SMOOTHABLE;
            meshGeneratorType = Config.terrainMeshGenerator;
            event.setCanceled(true);
        } else if (Config.renderSmoothLeaves && blockState.nocubes_isLeavesSmoothable()) {
            isSmoothable = IsSmoothable.LEAVES_SMOOTHABLE;
            meshGeneratorType = Config.leavesMeshGenerator;
            event.setCanceled(true);
        } else {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_178969_c(-TileEntityRendererDispatcher.field_147554_b, -TileEntityRendererDispatcher.field_147555_c, -TileEntityRendererDispatcher.field_147552_d);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.lineWidth((float)3.0f);
        GlStateManager.disableTexture();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        try (FaceList faces = MeshDispatcher.generateBlockMeshOffset(pos, (IBlockReader)world, isSmoothable, meshGeneratorType);){
            int facesSize = faces.size();
            for (int i = 0; i < facesSize; ++i) {
                try (Face face = (Face)faces.get(i);
                     Vec3 v0 = face.getVertex0();
                     Vec3 v1 = face.getVertex1();
                     Vec3 v2 = face.getVertex2();
                     Vec3 v3 = face.getVertex3();){
                    double v0x = v0.x;
                    double v0y = v0.y;
                    double v0z = v0.z;
                    bufferbuilder.func_181662_b(v0x, v0y, v0z).func_181666_a(0.0f, 0.0f, 0.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_181662_b(v1.x, v1.y, v1.z).func_181666_a(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                    bufferbuilder.func_181662_b(v2.x, v2.y, v2.z).func_181666_a(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                    bufferbuilder.func_181662_b(v3.x, v3.y, v3.z).func_181666_a(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                    bufferbuilder.func_181662_b(v0x, v0y, v0z).func_181666_a(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                    continue;
                }
            }
        }
        tessellator.func_78381_a();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
        bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
    }

    @SubscribeEvent
    public static void onPlayerSPPushOutOfBlocksEvent(PlayerSPPushOutOfBlocksEvent event) {
        if (Config.terrainCollisions) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onInitGuiEvent(GuiScreenEvent.InitGuiEvent event) {
        Screen gui = event.getGui();
        if (gui instanceof IngameMenuScreen) {
            int maxY = 0;
            for (Widget button : event.getWidgetList()) {
                maxY = Math.max(button.y, maxY);
            }
            event.addWidget((Widget)new IngameModListButton(gui, maxY + 24));
        }
    }
}

