/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.blocks.logic.drawbridge;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.FakePlayer;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.tmechworks.blocks.logic.IPlaceDirection;
import slimeknights.tmechworks.blocks.logic.RedstoneMachineLogicBase;
import slimeknights.tmechworks.integration.IInformationProvider;
import slimeknights.tmechworks.library.Util;

public abstract class DrawbridgeLogicBase
extends RedstoneMachineLogicBase
implements ITickable,
IInventoryGui,
IPlaceDirection {
    private static final float TICK_TIME = 0.05f;
    private FakePlayer fakePlayer;
    private DrawbridgeStats statistics = new DrawbridgeStats();
    private int extendState;
    private boolean isExtended;
    private boolean isExtending;
    private float cooldown;
    private EnumFacing rawPlaceDirection = null;
    private EnumFacing placeDirection = null;
    private Angle placeAngle = Angle.NEUTRAL;
    private long lastWorldTime;

    public DrawbridgeLogicBase(String name, int inventorySize) {
        super(name, inventorySize);
    }

    @Override
    public void onRedstoneUpdate() {
        if (this.getExtended() && this.getRedstoneState() <= 0) {
            this.isExtended = false;
            this.isExtending = true;
        } else if (!this.getExtended() && this.getRedstoneState() > 0) {
            this.isExtended = true;
            this.isExtending = true;
        }
        this.func_70296_d();
    }

    public void playExtendSound() {
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.25f, Util.rand.nextFloat() * 0.25f + 0.6f);
    }

    public void playRetractSound() {
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.25f, Util.rand.nextFloat() * 0.15f + 0.6f);
    }

    public int getExtendState() {
        return this.extendState;
    }

    public boolean getExtended() {
        return this.isExtended;
    }

    public boolean getExtending() {
        return this.isExtending;
    }

    public Angle getPlaceAngle() {
        return this.placeAngle;
    }

    public void setPlaceAngle(Angle angle) {
        this.placeAngle = angle;
        this.func_70296_d();
    }

    public EnumFacing getRawPlaceDirection() {
        return this.rawPlaceDirection;
    }

    public EnumFacing getPlaceDirection() {
        return this.placeDirection;
    }

    public void setPlaceDirection(EnumFacing direction) {
        this.placeDirection = direction;
        this.func_70296_d();
    }

    public void setPlaceDirectionRelativeToBlock(EnumFacing direction) {
        this.rawPlaceDirection = direction;
        block0 : switch (direction) {
            case UP: {
                switch (this.getFacingDirection()) {
                    case UP: {
                        this.setPlaceDirection(EnumFacing.SOUTH);
                        break block0;
                    }
                    case DOWN: {
                        this.setPlaceDirection(EnumFacing.NORTH);
                        break block0;
                    }
                }
                this.setPlaceDirection(EnumFacing.UP);
                break;
            }
            case DOWN: {
                switch (this.getFacingDirection()) {
                    case UP: {
                        this.setPlaceDirection(EnumFacing.NORTH);
                        break block0;
                    }
                    case DOWN: {
                        this.setPlaceDirection(EnumFacing.SOUTH);
                        break block0;
                    }
                }
                this.setPlaceDirection(EnumFacing.DOWN);
                break;
            }
            case NORTH: {
                this.setPlaceDirection(this.getFacingDirection());
                break;
            }
            case SOUTH: {
                this.setPlaceDirection(this.getFacingDirection().func_176734_d());
                break;
            }
            case EAST: {
                switch (this.getFacingDirection()) {
                    case UP: 
                    case DOWN: {
                        this.setPlaceDirection(direction);
                        break block0;
                    }
                }
                this.setPlaceDirection(this.getFacingDirection().func_176746_e());
                break;
            }
            case WEST: {
                switch (this.getFacingDirection()) {
                    case UP: 
                    case DOWN: {
                        this.setPlaceDirection(direction);
                        break block0;
                    }
                }
                this.setPlaceDirection(this.getFacingDirection().func_176735_f());
            }
        }
    }

    @Override
    public void setPlaceDirection(int direction) {
        if (direction < EnumFacing.values().length) {
            this.setPlaceDirectionRelativeToBlock(EnumFacing.values()[direction]);
        } else if (direction - EnumFacing.values().length < Angle.values().length) {
            this.setPlaceAngle(Angle.values()[direction - EnumFacing.values().length]);
        } else {
            throw new IllegalArgumentException("Direction " + direction + " cannot be mapped to any direction or angle.");
        }
    }

    public DrawbridgeStats getStats() {
        return this.statistics;
    }

    @Override
    public void loadData() {
        super.loadData();
        if (this.rawPlaceDirection == null) {
            this.rawPlaceDirection = EnumFacing.NORTH;
        }
        if (this.placeDirection == null) {
            this.setPlaceDirectionRelativeToBlock(this.rawPlaceDirection);
        }
        if (this.placeAngle == null) {
            this.setPlaceAngle(Angle.NEUTRAL);
        }
        this.setupStatistics(this.statistics);
        this.lastWorldTime = this.field_145850_b.func_72820_D();
    }

    public void updateFakePlayer(int x, int y, int z) {
        if (this.fakePlayer == null) {
            this.fakePlayer = Util.createFakePlayer(this.field_145850_b);
        }
        if (this.fakePlayer == null) {
            return;
        }
        this.fakePlayer.field_70177_z = 0.0f;
        this.fakePlayer.field_70125_A = 0.0f;
        this.fakePlayer.field_70165_t = x;
        this.fakePlayer.field_70163_u = y;
        this.fakePlayer.field_70161_v = z;
        switch (this.placeDirection) {
            case NORTH: {
                this.fakePlayer.field_70177_z = 0.0f;
                this.fakePlayer.field_70161_v += 2.0;
                break;
            }
            case SOUTH: {
                this.fakePlayer.field_70177_z = 180.0f;
                this.fakePlayer.field_70161_v -= 2.0;
            }
            case UP: {
                this.fakePlayer.field_70125_A = 90.0f;
                this.fakePlayer.field_70163_u += 2.0;
                break;
            }
            case DOWN: {
                this.fakePlayer.field_70125_A = -90.0f;
                this.fakePlayer.field_70163_u -= 2.0;
                break;
            }
            case EAST: {
                this.fakePlayer.field_70177_z = 90.0f;
                this.fakePlayer.field_70165_t -= 2.0;
                break;
            }
            case WEST: {
                this.fakePlayer.field_70177_z = -90.0f;
                this.fakePlayer.field_70165_t += 2.0;
            }
        }
        switch (this.placeAngle) {
            case HIGH: {
                this.fakePlayer.field_70125_A -= 45.0f;
                break;
            }
            case LOW: {
                this.fakePlayer.field_70125_A += 45.0f;
            }
        }
    }

    public FakePlayer getFakePlayer() {
        BlockPos pos = this.func_174877_v();
        return this.getFakePlayer(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public FakePlayer getFakePlayer(int x, int y, int z) {
        this.updateFakePlayer(x, y, z);
        return this.fakePlayer;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.onBlockUpdate();
        if (this.placeDirection == null) {
            this.setPlaceDirectionRelativeToBlock(EnumFacing.NORTH);
        }
        if (this.getExtending()) {
            if (this.cooldown > 0.0f) {
                this.cooldown -= (float)(this.field_145850_b.func_82737_E() - this.lastWorldTime) * 0.05f;
            } else if (this.isExtended) {
                if (this.getExtendState() == this.getStats().extendLength) {
                    this.isExtending = false;
                } else if (this.extendNext()) {
                    ++this.extendState;
                    this.cooldown = this.getStats().extendDelay;
                    this.playExtendSound();
                } else {
                    this.isExtending = false;
                }
            } else if (this.getExtendState() <= 0) {
                this.isExtending = false;
            } else if (this.retractNext()) {
                --this.extendState;
                this.cooldown = this.getStats().extendDelay;
                this.playRetractSound();
            } else {
                this.isExtending = false;
                this.extendState = 0;
            }
            this.func_70296_d();
        }
        this.lastWorldTime = this.field_145850_b.func_82737_E();
    }

    public int func_70297_j_() {
        return this.getStats().extendLength;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.fakePlayer != null) {
            this.field_145850_b.func_72900_e((Entity)this.fakePlayer);
            this.fakePlayer = null;
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    @Override
    public void readItemData(NBTTagCompound tags) {
        super.readItemData(tags);
        this.rawPlaceDirection = EnumFacing.values()[tags.func_74762_e("PlaceDirectionRaw")];
        this.placeAngle = Angle.values()[tags.func_74762_e("PlaceAngle")];
    }

    @Override
    public NBTTagCompound writeItemData(NBTTagCompound tags) {
        tags = super.writeItemData(tags);
        if (this.rawPlaceDirection == null) {
            this.rawPlaceDirection = EnumFacing.NORTH;
        }
        tags.func_74768_a("PlaceDirectionRaw", this.rawPlaceDirection.ordinal());
        tags.func_74768_a("PlaceAngle", this.placeAngle.ordinal());
        return tags;
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.extendState = tags.func_74762_e("ExtendState");
        this.isExtended = tags.func_74767_n("IsExtended");
        this.isExtending = tags.func_74767_n("IsExtending");
        this.cooldown = tags.func_74760_g("Cooldown");
        this.placeDirection = EnumFacing.values()[tags.func_74762_e("PlaceDirection")];
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags = super.func_189515_b(tags);
        tags.func_74768_a("ExtendState", this.extendState);
        tags.func_74757_a("IsExtended", this.isExtended);
        tags.func_74757_a("IsExtending", this.isExtending);
        tags.func_74776_a("Cooldown", this.cooldown);
        if (this.placeDirection == null) {
            this.setPlaceDirectionRelativeToBlock(this.rawPlaceDirection);
        }
        tags.func_74768_a("PlaceDirection", this.placeDirection.ordinal());
        return tags;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return super.func_70005_c_();
        }
        return super.func_70005_c_() + "." + this.getVariantName();
    }

    @Override
    public boolean canEditDisguise() {
        return !this.getExtended();
    }

    public abstract void setupStatistics(DrawbridgeStats var1);

    public abstract boolean extendNext();

    public abstract boolean retractNext();

    public abstract String getVariantName();

    @Override
    public void getInformation(@Nonnull List<String> info, IInformationProvider.InformationType type) {
        super.getInformation(info, type);
        if (type != IInformationProvider.InformationType.BODY) {
            return;
        }
        info.add(I18n.func_135052_a((String)"tmechworks.machine.stats", (Object[])new Object[0]));
        info.add(I18n.func_135052_a((String)"tmechworks.drawbridge.stats.length", (Object[])new Object[]{this.getStats().extendLength}));
        info.add(I18n.func_135052_a((String)"tmechworks.drawbridge.stats.delay", (Object[])new Object[]{Float.valueOf(this.getStats().extendDelay)}));
    }

    public static enum Angle {
        HIGH,
        NEUTRAL,
        LOW;

    }

    public static final class DrawbridgeStats {
        public int extendLength = 16;
        public float extendDelay = 0.5f;
    }
}

