/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.blocks.logic.drawbridge;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tmechworks.blocks.Drawbridge;
import slimeknights.tmechworks.blocks.logic.drawbridge.DrawbridgeLogicBase;
import slimeknights.tmechworks.client.gui.GuiDrawbridge;
import slimeknights.tmechworks.inventory.ContainerDrawbridge;
import slimeknights.tmechworks.library.Util;

public class DrawbridgeLogic
extends DrawbridgeLogicBase {
    protected static final ItemStack SILKTOUCH_PICKAXE = new ItemStack(Items.field_151046_w, 1, 0);
    protected IBlockState placedState;
    protected ItemStack setStack = ItemStack.field_190927_a;

    public DrawbridgeLogic() {
        this(1);
    }

    public DrawbridgeLogic(int inventorySize) {
        super(Util.prefix("inventory.drawbridge"), inventorySize);
    }

    @Override
    public void setupStatistics(DrawbridgeLogicBase.DrawbridgeStats ds) {
    }

    public ItemStack getNextBlock() {
        return this.func_70301_a(this.getNextIndex());
    }

    public ItemStack getLastBlock() {
        return this.func_70301_a(this.getLastIndex());
    }

    public void subtractNextBlock() {
        this.func_70298_a(this.getNextIndex(), 1);
        ItemStack stack = this.func_70301_a(this.getNextIndex());
        if (!stack.func_190926_b() && stack.func_190916_E() <= 0) {
            super.func_70299_a(this.getNextIndex(), ItemStack.field_190927_a);
        }
    }

    public void addLastBlock() {
        if (!this.func_70301_a(this.getLastIndex()).func_190926_b()) {
            this.func_70298_a(this.getLastIndex(), -1);
        } else {
            this.func_70299_a(this.getLastIndex(), this.setStack);
            this.setStack = ItemStack.field_190927_a;
        }
    }

    public int getNextIndex() {
        return 0;
    }

    public int getLastIndex() {
        return 0;
    }

    @Override
    public boolean extendNext() {
        EnumFacing face = this.getFacingDirection();
        int extend = this.getExtendState() + 1;
        BlockPos nextPos = new BlockPos(this.field_174879_c.func_177958_n() + face.func_82601_c() * extend, this.field_174879_c.func_177956_o() + face.func_96559_d() * extend, this.field_174879_c.func_177952_p() + face.func_82599_e() * extend);
        if (this.placeBlock(nextPos)) {
            this.subtractNextBlock();
            return true;
        }
        return false;
    }

    @Override
    public boolean retractNext() {
        EnumFacing face = this.getFacingDirection();
        int extend = this.getExtendState();
        BlockPos nextPos = new BlockPos(this.field_174879_c.func_177958_n() + face.func_82601_c() * extend, this.field_174879_c.func_177956_o() + face.func_96559_d() * extend, this.field_174879_c.func_177952_p() + face.func_82599_e() * extend);
        if (this.breakBlock(nextPos)) {
            this.addLastBlock();
            return true;
        }
        this.func_70299_a(0, this.func_70301_a(0));
        return false;
    }

    @Override
    public String getVariantName() {
        return "normal";
    }

    public boolean placeBlock(BlockPos position) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        FakePlayer fakePlayer = this.getFakePlayer(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        ItemStack stack = this.getNextBlock();
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            Block block = itemBlock.func_179223_d();
            EnumFacing hitFace = this.getPlaceDirection().func_176734_d();
            if (this.field_145850_b.func_180495_p(position).func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, position) && fakePlayer.func_175151_a(position, hitFace, stack) && this.field_145850_b.func_190527_a(block, position, false, hitFace, null)) {
                this.field_145850_b.captureBlockSnapshots = true;
                fakePlayer.field_71071_by.func_70299_a(0, stack);
                float hitY = this.getPlaceAngle() == DrawbridgeLogicBase.Angle.HIGH ? 1.0f : (this.getPlaceAngle() == DrawbridgeLogicBase.Angle.LOW ? 0.0f : 0.5f);
                IBlockState state = itemBlock.func_179223_d().getStateForPlacement(this.field_145850_b, position, hitFace, 0.5f, hitY, 0.5f, itemBlock.getMetadata(stack), (EntityLivingBase)fakePlayer, EnumHand.MAIN_HAND);
                boolean placed = itemBlock.placeBlockAt(stack, (EntityPlayer)fakePlayer, this.field_145850_b, position, hitFace, 0.5f, hitY, 0.5f, state);
                if (placed) {
                    state.func_177230_c().func_180633_a(this.field_145850_b, position, state, (EntityLivingBase)fakePlayer, stack);
                }
                this.field_145850_b.captureBlockSnapshots = false;
                List blockSnapshots = (List)this.field_145850_b.capturedBlockSnapshots.clone();
                this.field_145850_b.capturedBlockSnapshots.clear();
                BlockEvent.PlaceEvent placeEvent = null;
                if (blockSnapshots.size() == 1) {
                    placeEvent = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)fakePlayer, (BlockSnapshot)((BlockSnapshot)blockSnapshots.get(0)), (EnumFacing)hitFace, (EnumHand)EnumHand.MAIN_HAND);
                }
                if (placeEvent != null && placeEvent.isCanceled()) {
                    placed = false;
                    for (BlockSnapshot blocksnapshot : Lists.reverse((List)blockSnapshots)) {
                        this.field_145850_b.restoringBlockSnapshots = true;
                        blocksnapshot.restore(true, false);
                        this.field_145850_b.restoringBlockSnapshots = false;
                    }
                } else {
                    for (BlockSnapshot snap : blockSnapshots) {
                        int updateFlag = snap.getFlag();
                        IBlockState oldBlock = snap.getReplacedBlock();
                        IBlockState newBlock = this.field_145850_b.func_180495_p(snap.getPos());
                        if (!newBlock.func_177230_c().hasTileEntity(newBlock)) {
                            newBlock.func_177230_c().func_176213_c(this.field_145850_b, snap.getPos(), newBlock);
                        }
                        this.field_145850_b.markAndNotifyBlock(snap.getPos(), null, oldBlock, newBlock, updateFlag);
                    }
                    this.placedState = state;
                }
                return placed;
            }
        }
        return false;
    }

    public boolean breakBlock(BlockPos position) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        this.setStack = ItemStack.field_190927_a;
        ItemStack stack = this.getLastBlock();
        NonNullList<ItemStack> drops = this.getBlockDrops(position);
        if (stack.func_190926_b() && this.placedState != null) {
            ItemStack foundDrop = ItemStack.field_190927_a;
            for (ItemStack drop2 : drops) {
                if (drop2.func_190916_E() != 1 || drop2.func_77973_b() != Item.func_150898_a((Block)this.placedState.func_177230_c())) continue;
                foundDrop = drop2;
                break;
            }
            if (foundDrop.func_190926_b()) {
                return false;
            }
            drops.remove((Object)foundDrop);
            this.setStack = foundDrop;
        } else if (!stack.func_190926_b() && !drops.removeIf(drop -> drop.func_190916_E() == 1 && ItemStack.func_77970_a((ItemStack)drop, (ItemStack)stack) && ItemStack.func_179545_c((ItemStack)drop, (ItemStack)stack))) {
            return false;
        }
        drops.forEach(drop -> Block.func_180635_a((World)this.field_145850_b, (BlockPos)position, (ItemStack)drop));
        return this.field_145850_b.func_175698_g(position);
    }

    public Container createContainer(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new ContainerDrawbridge(this, inventoryplayer);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new GuiDrawbridge(new ContainerDrawbridge(this, inventoryplayer));
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        if (tags.func_150297_b("placedState", 10)) {
            this.placedState = NBTUtil.func_190008_d((NBTTagCompound)tags.func_74775_l("placedState"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags = super.func_189515_b(tags);
        if (this.placedState != null) {
            NBTTagCompound stateCompound = new NBTTagCompound();
            NBTUtil.func_190009_a((NBTTagCompound)stateCompound, (IBlockState)this.placedState);
            tags.func_74782_a("placedState", (NBTBase)stateCompound);
        }
        return tags;
    }

    public NonNullList<ItemStack> getBlockDrops(BlockPos position) {
        Drawbridge.dropCapture(true);
        IBlockState state = this.field_145850_b.func_180495_p(position);
        state.func_177230_c().func_180657_a(this.field_145850_b, (EntityPlayer)this.getFakePlayer(), position, state, this.field_145850_b.func_175625_s(position), SILKTOUCH_PICKAXE);
        return Drawbridge.dropCapture(false);
    }

    static {
        EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)Enchantments.field_185306_r, (Object)1), (ItemStack)SILKTOUCH_PICKAXE);
    }
}

