/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IConduitRenderer;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.conduits.render.BakedQuadBuilder;
import crazypants.enderio.conduits.render.ConduitBundleRenderManager;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;

public class DefaultConduitRenderer
implements IConduitRenderer {
    static final Vector3d[] verts = new Vector3d[8];
    protected float transmissionScaleFactor;
    @Nonnull
    private static final Vector4f COLOR_ERROR;
    @Nonnull
    private static final Vector4f NONE;

    @Override
    public boolean isRendererForConduit(@Nonnull IConduit conduit) {
        return true;
    }

    protected boolean renderComponent(CollidableComponent component) {
        return true;
    }

    @Override
    public void addBakedQuads(@Nonnull TileEntitySpecialRenderer<?> conduitBundleRenderer, @Nonnull IConduitBundle bundle, @Nonnull IClientConduit.WithDefaultRendering conduit, float brightness, @Nullable BlockRenderLayer layer, @Nonnull List<BakedQuad> quads) {
        Collection<CollidableComponent> components = conduit.getCollidableComponents();
        this.transmissionScaleFactor = conduit.getTransmitionGeometryScale();
        for (CollidableComponent component : components) {
            if (component == null || !this.renderComponent(component)) continue;
            float selfIllum = Math.max(brightness, conduit.getSelfIlluminationForState(component));
            IConduitTexture transmitionTextureForState = conduit.getTransmitionTextureForState(component);
            if (layer != null && component.isDirectional() && transmitionTextureForState != null && component.data == null) {
                Vector4f color = conduit.getTransmitionTextureColorForState(component);
                this.addTransmissionQuads(transmitionTextureForState, color, layer, conduit, component, selfIllum, quads);
            }
            IConduitTexture tex = conduit.getTextureForState(component);
            this.addConduitQuads(bundle, conduit, tex, component, selfIllum, layer, quads);
        }
    }

    @Nonnull
    protected BlockRenderLayer getConduitQuadsLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    protected BlockRenderLayer getTransmissionQuadsLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @Nonnull
    public BlockRenderLayer getCoreLayer() {
        return this.getConduitQuadsLayer();
    }

    @Override
    public boolean canRenderInLayer(@Nonnull IClientConduit.WithDefaultRendering con, @Nonnull BlockRenderLayer layer) {
        return layer == this.getConduitQuadsLayer() || layer == this.getTransmissionQuadsLayer();
    }

    protected void addConduitQuads(@Nonnull IConduitBundle bundle, @Nonnull IClientConduit conduit, @Nonnull IConduitTexture tex, @Nonnull CollidableComponent component, float selfIllum, BlockRenderLayer layer, @Nonnull List<BakedQuad> quads) {
        if (component.isDirectional()) {
            if (layer != this.getConduitQuadsLayer()) {
                return;
            }
            if (component.data != null) {
                return;
            }
            float shrink = 0.03125f;
            EnumFacing componentDirection = component.getDirection();
            float xLen = Math.abs(componentDirection.func_82601_c()) == 1 ? 0.0f : shrink;
            float yLen = Math.abs(componentDirection.func_96559_d()) == 1 ? 0.0f : shrink;
            float zLen = Math.abs(componentDirection.func_82599_e()) == 1 ? 0.0f : shrink;
            BoundingBox cube = component.bound;
            BoundingBox bb = cube.expand((double)(-xLen), (double)(-yLen), (double)(-zLen));
            this.addQuadsForSection(bb, tex, componentDirection, quads, (Vector4f)(conduit.renderError() ? COLOR_ERROR : null));
            if (conduit.getConnectionMode(componentDirection) == ConnectionMode.DISABLED) {
                TextureAtlasSprite tex2 = ConduitBundleRenderManager.instance.getConnectorIcon(component.data);
                BakedQuadBuilder.addBakedQuadForFace(quads, bb, tex2, componentDirection);
            }
        } else {
            BakedQuadBuilder.addBakedQuads(quads, component.bound, tex.getSprite());
        }
    }

    protected void addQuadsForSection(@Nonnull BoundingBox bb, @Nonnull IConduitTexture tex, @Nonnull EnumFacing dir, @Nonnull List<BakedQuad> quads, @Nullable Vector4f color) {
        boolean rotateSides = dir == EnumFacing.UP || dir == EnumFacing.DOWN;
        boolean rotateTopBottom = dir == EnumFacing.DOWN || dir == EnumFacing.EAST || dir == EnumFacing.SOUTH;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (face == dir || face.func_176734_d() == dir) continue;
            boolean doRotSides = rotateSides;
            boolean doRotateTopBottom = rotateTopBottom;
            if (face == EnumFacing.UP || face == EnumFacing.DOWN) {
                boolean bl = doRotSides = dir == EnumFacing.SOUTH || dir == EnumFacing.NORTH;
            }
            if (dir.func_176740_k().func_176720_b() && (face == EnumFacing.NORTH || face == EnumFacing.EAST)) {
                boolean bl = doRotateTopBottom = !doRotateTopBottom;
            }
            if (dir.func_176740_k() == EnumFacing.Axis.Z && face == EnumFacing.DOWN) {
                doRotateTopBottom = !doRotateTopBottom;
            }
            BakedQuadBuilder.addBakedQuadForFace(quads, bb, tex.getSprite(), face, tex.getUv(), doRotSides, doRotateTopBottom, color);
        }
    }

    protected void addTransmissionQuads(@Nonnull IConduitTexture tex, Vector4f color, @Nonnull BlockRenderLayer layer, @Nonnull IConduit conduit, @Nonnull CollidableComponent component, float selfIllum, @Nonnull List<BakedQuad> quads) {
        if (layer != this.getTransmissionQuadsLayer()) {
            return;
        }
        float shrink = 0.03125f;
        EnumFacing componentDirection = component.getDirection();
        float xLen = Math.abs(componentDirection.func_82601_c()) == 1 ? 0.0f : shrink;
        float yLen = Math.abs(componentDirection.func_96559_d()) == 1 ? 0.0f : shrink;
        float zLen = Math.abs(componentDirection.func_82599_e()) == 1 ? 0.0f : shrink;
        BoundingBox cube = component.bound;
        BoundingBox bb = cube.expand((double)(-xLen), (double)(-yLen), (double)(-zLen));
        this.addQuadsForSection(bb, tex, componentDirection, quads, color);
    }

    @Override
    public void renderDynamicEntity(@Nonnull TileEntitySpecialRenderer<?> conduitBundleRenderer, @Nonnull IConduitBundle te, @Nonnull IClientConduit.WithDefaultRendering conduit, double x, double y, double z, float partialTick, float worldLight) {
        Collection<CollidableComponent> components = conduit.getCollidableComponents();
        this.transmissionScaleFactor = conduit.getTransmitionGeometryScale();
        for (CollidableComponent component : components) {
            if (component == null || !this.renderComponent(component)) continue;
            float selfIllum = Math.max(worldLight, conduit.getSelfIlluminationForState(component));
            IConduitTexture transmitionTextureForState = conduit.getTransmitionTextureForState(component);
            if (component.isDirectional() && transmitionTextureForState != null) {
                Vector4f color = conduit.getTransmitionTextureColorForState(component);
                this.renderTransmissionDynamic(conduit, transmitionTextureForState, color, component, selfIllum);
            }
            IConduitTexture tex = conduit.getTextureForState(component);
            this.renderConduitDynamic(tex, conduit, component, selfIllum);
        }
    }

    protected void renderConduitDynamic(@Nonnull IConduitTexture tex, @Nonnull IClientConduit.WithDefaultRendering conduit, @Nonnull CollidableComponent component, float brightness) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (component.isDirectional() && component.data == null) {
            EnumFacing componentDirection = component.getDirection();
            float scaleFactor = 0.75f;
            float xLen = Math.abs(componentDirection.func_82601_c()) == 1 ? 1.0f : scaleFactor;
            float yLen = Math.abs(componentDirection.func_96559_d()) == 1 ? 1.0f : scaleFactor;
            float zLen = Math.abs(componentDirection.func_82599_e()) == 1 ? 1.0f : scaleFactor;
            BoundingBox cube = component.bound;
            BoundingBox bb = cube.scale(xLen, yLen, zLen);
            TextureAtlasSprite sprite = tex.getSprite();
            this.drawDynamicSection(bb, sprite.func_94214_a((double)(tex.getUv().x * 16.0f)), sprite.func_94214_a((double)(tex.getUv().z * 16.0f)), sprite.func_94207_b((double)(tex.getUv().y * 16.0f)), sprite.func_94207_b((double)(tex.getUv().w * 16.0f)), componentDirection, false, conduit.shouldMirrorTexture());
            if (conduit.getConnectionMode(componentDirection) == ConnectionMode.DISABLED) {
                TextureAtlasSprite tex2 = ConduitBundleRenderManager.instance.getConnectorIcon(component.data);
                NNList corners = component.bound.getCornersWithUvForFace(componentDirection, tex2.func_94209_e(), tex2.func_94212_f(), tex2.func_94206_g(), tex2.func_94210_h());
                RenderUtil.addVerticesToTessellator((List)corners, (VertexFormat)DefaultVertexFormats.field_181707_g, (boolean)false);
            }
        }
    }

    protected void renderTransmissionDynamic(@Nonnull IConduit conduit, @Nonnull IConduitTexture tex, @Nullable Vector4f color, @Nonnull CollidableComponent component, float selfIllum) {
        float scaleFactor = 0.6f;
        EnumFacing componentDirection = component.getDirection();
        float xLen = Math.abs(componentDirection.func_82601_c()) == 1 ? 1.0f : scaleFactor;
        float yLen = Math.abs(componentDirection.func_96559_d()) == 1 ? 1.0f : scaleFactor;
        float zLen = Math.abs(componentDirection.func_82599_e()) == 1 ? 1.0f : scaleFactor;
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        BoundingBox cube = component.bound;
        BoundingBox bb = cube.scale(xLen, yLen, zLen);
        TextureAtlasSprite sprite = tex.getSprite();
        this.drawDynamicSection(bb, sprite.func_94214_a((double)(tex.getUv().x * 16.0f)), sprite.func_94214_a((double)(tex.getUv().z * 16.0f)), sprite.func_94207_b((double)(tex.getUv().y * 16.0f)), sprite.func_94207_b((double)(tex.getUv().w * 16.0f)), color, componentDirection, false);
    }

    protected void drawDynamicSection(@Nonnull BoundingBox bound, float minU, float maxU, float minV, float maxV, @Nonnull EnumFacing dir, boolean isTransmission) {
        this.drawDynamicSection(bound, minU, maxU, minV, maxV, null, dir, isTransmission, true);
    }

    protected void drawDynamicSection(@Nonnull BoundingBox bound, float minU, float maxU, float minV, float maxV, @Nonnull EnumFacing dir, boolean isTransmission, boolean mirrorTexture) {
        this.drawDynamicSection(bound, minU, maxU, minV, maxV, null, dir, isTransmission, mirrorTexture);
    }

    protected void drawDynamicSection(@Nonnull BoundingBox bound, float minU, float maxU, float minV, float maxV, @Nullable Vector4f color, @Nonnull EnumFacing dir, boolean isTransmission) {
        this.drawDynamicSection(bound, minU, maxU, minV, maxV, color, dir, isTransmission, true);
    }

    protected void drawDynamicSection(@Nonnull BoundingBox bound, float minU, float maxU, float minV, float maxV, @Nullable Vector4f color, @Nonnull EnumFacing dir, boolean isTransmission, boolean mirrorTexture) {
        boolean rotateTopBottom;
        if (isTransmission) {
            this.setVerticesForTransmission(bound, dir);
        } else {
            this.setupVertices(bound);
        }
        if (mirrorTexture && (dir == EnumFacing.NORTH || dir == EnumFacing.UP || dir == EnumFacing.EAST)) {
            float tmp = minU;
            minU = maxU;
            maxU = tmp;
        }
        if (color == null) {
            color = NONE;
        }
        boolean rotateSides = dir == EnumFacing.UP || dir == EnumFacing.DOWN;
        boolean bl = rotateTopBottom = dir == EnumFacing.NORTH || dir == EnumFacing.SOUTH;
        if (dir != EnumFacing.NORTH && dir != EnumFacing.SOUTH) {
            float tmp;
            if (!isTransmission) {
                // empty if block
            }
            if (rotateSides) {
                this.addVecWithUV(verts[1], maxU, maxV, color);
                this.addVecWithUV(verts[0], maxU, minV, color);
                this.addVecWithUV(verts[3], minU, minV, color);
                this.addVecWithUV(verts[2], minU, maxV, color);
            } else {
                this.addVecWithUV(verts[1], minU, minV, color);
                this.addVecWithUV(verts[0], maxU, minV, color);
                this.addVecWithUV(verts[3], maxU, maxV, color);
                this.addVecWithUV(verts[2], minU, maxV, color);
            }
            if (dir == EnumFacing.WEST || dir == EnumFacing.EAST) {
                tmp = minU;
                minU = maxU;
                maxU = tmp;
            }
            if (!isTransmission) {
                // empty if block
            }
            if (rotateSides) {
                this.addVecWithUV(verts[4], maxU, maxV, color);
                this.addVecWithUV(verts[5], maxU, minV, color);
                this.addVecWithUV(verts[6], minU, minV, color);
                this.addVecWithUV(verts[7], minU, maxV, color);
            } else {
                this.addVecWithUV(verts[4], minU, minV, color);
                this.addVecWithUV(verts[5], maxU, minV, color);
                this.addVecWithUV(verts[6], maxU, maxV, color);
                this.addVecWithUV(verts[7], minU, maxV, color);
            }
            if (dir == EnumFacing.WEST || dir == EnumFacing.EAST) {
                tmp = minU;
                minU = maxU;
                maxU = tmp;
            }
        }
        if (dir != EnumFacing.UP && dir != EnumFacing.DOWN) {
            if (!isTransmission) {
                // empty if block
            }
            if (rotateTopBottom) {
                this.addVecWithUV(verts[6], maxU, maxV, color);
                this.addVecWithUV(verts[2], minU, maxV, color);
                this.addVecWithUV(verts[3], minU, minV, color);
                this.addVecWithUV(verts[7], maxU, minV, color);
            } else {
                this.addVecWithUV(verts[6], minU, minV, color);
                this.addVecWithUV(verts[2], minU, maxV, color);
                this.addVecWithUV(verts[3], maxU, maxV, color);
                this.addVecWithUV(verts[7], maxU, minV, color);
            }
            if (!isTransmission) {
                // empty if block
            }
            if (rotateTopBottom) {
                this.addVecWithUV(verts[0], minU, minV, color);
                this.addVecWithUV(verts[1], minU, maxV, color);
                this.addVecWithUV(verts[5], maxU, maxV, color);
                this.addVecWithUV(verts[4], maxU, minV, color);
            } else {
                this.addVecWithUV(verts[0], maxU, maxV, color);
                this.addVecWithUV(verts[1], minU, maxV, color);
                this.addVecWithUV(verts[5], minU, minV, color);
                this.addVecWithUV(verts[4], maxU, minV, color);
            }
        }
        if (dir != EnumFacing.EAST && dir != EnumFacing.WEST) {
            if (!isTransmission) {
                // empty if block
            }
            if (rotateSides) {
                this.addVecWithUV(verts[2], minU, maxV, color);
                this.addVecWithUV(verts[6], minU, minV, color);
                this.addVecWithUV(verts[5], maxU, minV, color);
                this.addVecWithUV(verts[1], maxU, maxV, color);
            } else {
                this.addVecWithUV(verts[2], minU, maxV, color);
                this.addVecWithUV(verts[6], maxU, maxV, color);
                this.addVecWithUV(verts[5], maxU, minV, color);
                this.addVecWithUV(verts[1], minU, minV, color);
            }
            if (!isTransmission) {
                // empty if block
            }
            if (rotateSides) {
                this.addVecWithUV(verts[0], maxU, maxV, color);
                this.addVecWithUV(verts[4], maxU, minV, color);
                this.addVecWithUV(verts[7], minU, minV, color);
                this.addVecWithUV(verts[3], minU, maxV, color);
            } else {
                this.addVecWithUV(verts[0], minU, minV, color);
                this.addVecWithUV(verts[4], maxU, minV, color);
                this.addVecWithUV(verts[7], maxU, maxV, color);
                this.addVecWithUV(verts[3], minU, maxV, color);
            }
        }
    }

    public BoundingBox[] toCubes(BoundingBox bb) {
        double width = bb.field_72336_d - bb.field_72340_a;
        double height = bb.field_72337_e - bb.field_72338_b;
        double depth = bb.field_72334_f - bb.field_72339_c;
        if (width > 0.0 && height > 0.0 && depth > 0.0) {
            if (width / depth > 1.5 || depth / width > 1.5) {
                if (width > depth) {
                    int numSplits = (int)Math.round(width / depth);
                    double newWidth = width / (double)numSplits;
                    BoundingBox[] result = new BoundingBox[numSplits];
                    double lastMax = bb.field_72340_a;
                    for (int i = 0; i < numSplits; ++i) {
                        double max = lastMax + newWidth;
                        result[i] = new BoundingBox(lastMax, bb.field_72338_b, bb.field_72339_c, max, bb.field_72337_e, bb.field_72334_f);
                        lastMax = max;
                    }
                    return result;
                }
                int numSplits = (int)Math.round(depth / width);
                double newWidth = depth / (double)numSplits;
                BoundingBox[] result = new BoundingBox[numSplits];
                double lastMax = bb.field_72339_c;
                for (int i = 0; i < numSplits; ++i) {
                    double max = lastMax + newWidth;
                    result[i] = new BoundingBox(bb.field_72340_a, bb.field_72338_b, lastMax, bb.field_72336_d, bb.field_72337_e, max);
                    lastMax = max;
                }
                return result;
            }
            if (height / width > 1.5) {
                int numSplits = (int)Math.round(height / width);
                double newWidth = height / (double)numSplits;
                BoundingBox[] result = new BoundingBox[numSplits];
                double lastMax = bb.field_72338_b;
                for (int i = 0; i < numSplits; ++i) {
                    double max = lastMax + newWidth;
                    result[i] = new BoundingBox(bb.field_72340_a, lastMax, bb.field_72339_c, bb.field_72336_d, max, bb.field_72334_f);
                    lastMax = max;
                }
                return result;
            }
        }
        return new BoundingBox[]{bb};
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    protected void setVerticesForTransmission(@Nonnull BoundingBox bound, @Nonnull EnumFacing dir) {
        float xs = dir.func_82601_c() == 0 ? this.transmissionScaleFactor : 1.0f;
        float ys = dir.func_96559_d() == 0 ? this.transmissionScaleFactor : 1.0f;
        float zs = dir.func_82599_e() == 0 ? this.transmissionScaleFactor : 1.0f;
        this.setupVertices(bound.scale(xs, ys, zs));
    }

    protected void addVecWithUV(@Nullable Vector3d vec, double u, double v, @Nonnull Vector4f color) {
        if (vec != null) {
            BufferBuilder tes = Tessellator.func_178181_a().func_178180_c();
            tes.func_181662_b(vec.x, vec.y, vec.z).func_187315_a(u, v).func_181666_a(color.x, color.y, color.z, color.w).func_181675_d();
        }
    }

    protected void setupVertices(@Nonnull BoundingBox bound) {
        this.setupVertices(bound, null);
    }

    protected void setupVertices(@Nonnull BoundingBox bound, @Nullable VertexTransform xForm) {
        verts[0].set(bound.field_72340_a, bound.field_72338_b, bound.field_72339_c);
        verts[1].set(bound.field_72336_d, bound.field_72338_b, bound.field_72339_c);
        verts[2].set(bound.field_72336_d, bound.field_72337_e, bound.field_72339_c);
        verts[3].set(bound.field_72340_a, bound.field_72337_e, bound.field_72339_c);
        verts[4].set(bound.field_72340_a, bound.field_72338_b, bound.field_72334_f);
        verts[5].set(bound.field_72336_d, bound.field_72338_b, bound.field_72334_f);
        verts[6].set(bound.field_72336_d, bound.field_72337_e, bound.field_72334_f);
        verts[7].set(bound.field_72340_a, bound.field_72337_e, bound.field_72334_f);
        if (xForm != null) {
            for (Vector3d vec : verts) {
                if (vec == null) continue;
                xForm.apply(vec);
            }
        }
    }

    static {
        for (int i = 0; i < verts.length; ++i) {
            DefaultConduitRenderer.verts[i] = new Vector3d();
        }
        COLOR_ERROR = new Vector4f(1.0f, 0.0f, 0.0f, 1.0f);
        NONE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

