/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.capability.PerkRegistry;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCapClientMessage;
import ovh.corail.tombstone.registry.ModTriggers;

public class UpgradePerkServerMessage
implements IMessage {
    private SyncType syncType;
    private Perk perk;

    public UpgradePerkServerMessage() {
    }

    public UpgradePerkServerMessage(SyncType syncType, Perk perk) {
        this.syncType = syncType;
        this.perk = perk;
    }

    public void fromBytes(ByteBuf buf) {
        this.syncType = SyncType.values()[buf.readShort()];
        this.perk = (Perk)PerkRegistry.perkRegistry.getValue(buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.syncType.ordinal());
        buf.writeInt(PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)this.perk));
    }

    public static class Handler
    implements IMessageHandler<UpgradePerkServerMessage, IMessage> {
        public IMessage onMessage(UpgradePerkServerMessage message, MessageContext ctx) {
            IThreadListener mainThread = (IThreadListener)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
                if (cap != null) {
                    int levelPerk = cap.getPerkLevel((EntityPlayer)player, message.perk);
                    if (message.syncType == SyncType.UPGRADE_PERK && levelPerk < message.perk.getLevelMax() && cap.getTotalPerkPoints() - cap.getUsedPerkPoints((EntityPlayer)player) >= message.perk.getCost(levelPerk + 1)) {
                        cap.setPerk(message.perk, levelPerk + 1);
                        if (levelPerk == 0) {
                            ModTriggers.CHOOSE_KNOWLEDGE.trigger(player);
                        }
                        PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.SET_PERK, message.perk, levelPerk + 1), player);
                    } else if (message.syncType == SyncType.DOWNGRADE_PERK && levelPerk > 0) {
                        cap.setPerk(message.perk, levelPerk - 1);
                        PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.SET_PERK, message.perk, levelPerk - 1), player);
                    }
                }
            });
            return null;
        }
    }

    public static enum SyncType {
        UPGRADE_PERK,
        DOWNGRADE_PERK;

    }
}

