/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import ovh.corail.tombstone.helper.Location;

public class NBTStackHelper {
    private static boolean checkCompound(ItemStack stack, boolean addCompound) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (addCompound && !stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77942_o();
    }

    private static boolean checkCompound(ItemStack stack) {
        return NBTStackHelper.checkCompound(stack, false);
    }

    public static ItemStack setString(ItemStack stack, String keyName, String keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            stack.func_77978_p().func_74778_a(keyName, keyValue);
        }
        return stack;
    }

    public static String getString(ItemStack stack, String keyName) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = stack.func_77978_p()).func_74764_b(keyName)) {
            return compound.func_74779_i(keyName);
        }
        return "";
    }

    public static ItemStack setBoolean(ItemStack stack, String keyName, boolean keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            stack.func_77978_p().func_74757_a(keyName, keyValue);
        }
        return stack;
    }

    public static boolean getBoolean(ItemStack stack, String keyName) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = stack.func_77978_p()).func_74764_b(keyName)) {
            return compound.func_74767_n(keyName);
        }
        return false;
    }

    public static ItemStack setInteger(ItemStack stack, String keyName, int keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            stack.func_77978_p().func_74768_a(keyName, keyValue);
        }
        return stack;
    }

    public static int getInteger(ItemStack stack, String keyName) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = stack.func_77978_p()).func_74764_b(keyName)) {
            return compound.func_74762_e(keyName);
        }
        return Integer.MIN_VALUE;
    }

    public static ItemStack setLong(ItemStack stack, String keyName, long keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            stack.func_77978_p().func_74772_a(keyName, keyValue);
        }
        return stack;
    }

    @Deprecated
    public static long getLong(ItemStack stack, String keyName) {
        return NBTStackHelper.getLong(stack, keyName, Long.MIN_VALUE);
    }

    public static long getLong(ItemStack stack, String keyName, long fallback) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = stack.func_77978_p()).func_74764_b(keyName)) {
            return compound.func_74763_f(keyName);
        }
        return fallback;
    }

    public static ItemStack setBlockPos(ItemStack stack, String keyName, BlockPos keyValue) {
        NBTStackHelper.setInteger(stack, keyName + "X", keyValue.func_177958_n());
        NBTStackHelper.setInteger(stack, keyName + "Y", keyValue.func_177956_o());
        NBTStackHelper.setInteger(stack, keyName + "Z", keyValue.func_177952_p());
        return stack;
    }

    public static BlockPos getBlockPos(ItemStack stack, String keyName) {
        int intValueX = NBTStackHelper.getInteger(stack, keyName + "X");
        int intValueY = NBTStackHelper.getInteger(stack, keyName + "Y");
        int intValueZ = NBTStackHelper.getInteger(stack, keyName + "Z");
        return intValueX != Integer.MIN_VALUE && intValueY != Integer.MIN_VALUE && intValueZ != Integer.MIN_VALUE ? new BlockPos(intValueX, intValueY, intValueZ) : BlockPos.field_177992_a;
    }

    public static ItemStack setLocation(ItemStack stack, String keyName, Location position) {
        NBTStackHelper.setBlockPos(stack, keyName, position.getPos());
        NBTStackHelper.setInteger(stack, keyName + "D", position.dim);
        return stack;
    }

    public static Location getLocation(ItemStack stack, String keyName) {
        BlockPos pos = NBTStackHelper.getBlockPos(stack, keyName);
        int dim = NBTStackHelper.getInteger(stack, keyName + "D");
        return pos.equals((Object)BlockPos.field_177992_a) || dim == Integer.MIN_VALUE ? Location.ORIGIN : new Location(pos, dim);
    }

    public static boolean removeKeyName(ItemStack stack, String keyName) {
        if (NBTStackHelper.hasKeyName(stack, keyName)) {
            stack.func_77978_p().func_82580_o(keyName);
            return true;
        }
        return false;
    }

    public static boolean hasKeyName(ItemStack stack, String keyName) {
        return NBTStackHelper.checkCompound(stack) && stack.func_77978_p().func_74764_b(keyName);
    }
}

