/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.capability.PerkRegistry;
import ovh.corail.tombstone.gui.GuiInfo;
import ovh.corail.tombstone.gui.TBGuiButton;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TextureHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpgradePerkServerMessage;

@SideOnly(value=Side.CLIENT)
public class GuiKnowledge
extends GuiScreen {
    private final ITBCapability cap;
    private final int guiWidth = 166;
    private final int guiHeight = 166;
    private final int iconSize = 16;
    private int posX;
    private int posY;
    private final List<PerkIcon> icons = new ArrayList<PerkIcon>();
    private final int borderColor = -15524569;
    private final int textColor = -1980292;
    private PerkIcon hoveredIcon;
    private int leftPerkPoints;
    private int hoveredPerkLevel = 0;

    public GuiKnowledge(ITBCapability cap) {
        this.cap = cap;
        for (Perk perk : PerkRegistry.perkRegistry.getValuesCollection()) {
            if (Helper.isDisabledPerk(perk)) continue;
            this.icons.add(new PerkIcon(perk));
        }
    }

    public void func_73866_w_() {
        ((Object)((Object)this)).getClass();
        this.posX = (this.field_146294_l - 166) / 2;
        ((Object)((Object)this)).getClass();
        this.posY = (this.field_146295_m - 166) / 2;
        int x = this.posX + 15;
        int y = this.posY + 58;
        int i = 0;
        int spaceForIcon = this.icons.size() > 10 ? 20 : 30;
        int maxIconByLine = this.icons.size() > 10 ? 7 : 5;
        for (PerkIcon icon : this.icons) {
            int caseX = i % maxIconByLine;
            icon.setPosition(x + caseX * spaceForIcon, y);
            if (caseX == maxIconByLine - 1) {
                y += 30;
            }
            ++i;
        }
        this.field_146292_n.add(new TBGuiButton(0, (this.field_146294_l - 70) / 2, this.posY + 146, 70, 15, I18n.func_135052_a((String)"tombstone.compendium.main.title", (Object[])new Object[0])));
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        boolean clicked = false;
        if (this.hoveredIcon != null) {
            if (mouseButton == 0) {
                int perkLevel = this.cap.getPerkLevel((EntityPlayer)this.field_146297_k.field_71439_g, this.hoveredIcon.perk);
                if (perkLevel < this.hoveredIcon.perk.getLevelMax() && this.leftPerkPoints >= this.hoveredIcon.perk.getCost(perkLevel + 1)) {
                    clicked = true;
                    PacketHandler.INSTANCE.sendToServer((IMessage)new UpgradePerkServerMessage(UpgradePerkServerMessage.SyncType.UPGRADE_PERK, this.hoveredIcon.perk));
                }
            } else if (mouseButton == 1 && Minecraft.func_71410_x().field_71439_g.func_184812_l_() && this.cap.getPerkLevel((EntityPlayer)this.field_146297_k.field_71439_g, this.hoveredIcon.perk) > 0) {
                clicked = true;
                PacketHandler.INSTANCE.sendToServer((IMessage)new UpgradePerkServerMessage(UpgradePerkServerMessage.SyncType.DOWNGRADE_PERK, this.hoveredIcon.perk));
            }
        }
        if (!clicked) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiInfo(null));
        }
    }

    public void func_146276_q_() {
        super.func_146276_q_();
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        GuiKnowledge.func_73734_a((int)(this.posX - 3), (int)(this.posY - 3), (int)(this.posX + 166 + 3), (int)(this.posY + 166 + 3), (int)this.borderColor);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureHelper.GUI_BACKGROUND.bindTexture();
        GuiKnowledge.func_146110_a((int)this.posX, (int)this.posY, (float)0.0f, (float)0.0f, (int)166, (int)166, (float)166.0f, (float)166.0f);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        this.func_146276_q_();
        this.hoveredIcon = this.icons.stream().filter(p -> p.contains(mouseX, mouseY)).findFirst().orElse(null);
        int totalPerkPoints = this.cap.getTotalPerkPoints();
        int usedPerkPoints = this.cap.getUsedPerkPoints((EntityPlayer)this.field_146297_k.field_71439_g);
        this.leftPerkPoints = totalPerkPoints - usedPerkPoints;
        GlStateManager.func_179094_E();
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((Object)((Object)this)).getClass();
        this.func_73730_a(this.posX + 5, this.posX + 166 - 5, this.posY + 4, this.textColor);
        ((Object)((Object)this)).getClass();
        this.func_73730_a(this.posX + 5, this.posX + 166 - 5, this.posY + 6, this.textColor);
        String titleName = LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getClientTranslation(new Object[0]);
        this.field_146289_q.func_175065_a(titleName, (float)(this.field_146294_l / 2 - this.field_146289_q.func_78256_a(titleName) / 2), (float)(this.posY + 9), this.textColor, false);
        ((Object)((Object)this)).getClass();
        this.func_73730_a(this.posX + 5, this.posX + 166 - 5, this.posY + 18, this.textColor);
        ((Object)((Object)this)).getClass();
        this.func_73730_a(this.posX + 5, this.posX + 166 - 5, this.posY + 20, this.textColor);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureHelper.GUI_BAR.bindTexture();
        GuiKnowledge.func_146110_a((int)(this.posX + 20), (int)(this.posY + 30), (float)0.0f, (float)40.0f, (int)182, (int)5, (float)182.0f, (float)256.0f);
        GuiKnowledge.func_146110_a((int)(this.posX + 20), (int)(this.posY + 30), (float)0.0f, (float)45.0f, (int)((int)(129.22 * (double)(this.cap.getKnowledge() - this.cap.getKnowledgeForLevel(totalPerkPoints)) / (double)this.cap.getKnowledgeToReachNextLevel(totalPerkPoints + 1))), (int)5, (float)182.0f, (float)256.0f);
        GuiKnowledge.func_146110_a((int)(this.posX + 20), (int)(this.posY + 31), (float)0.0f, (float)101.0f, (int)182, (int)3, (float)182.0f, (float)256.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureHelper.GUI_PERK.bindTexture();
        GuiKnowledge.func_152125_a((int)(this.posX + 35), (int)(this.posY + 42), (float)0.0f, (float)0.0f, (int)64, (int)64, (int)8, (int)8, (float)64.0f, (float)64.0f);
        this.field_146289_q.func_175065_a(this.leftPerkPoints + " / " + totalPerkPoints, (float)(this.posX + 50), (float)(this.posY + 43), -7769547, false);
        for (PerkIcon icon : this.icons) {
            this.drawPerk(icon);
        }
        int currentY = this.posY + 110;
        if (Helper.isContributor((EntityPlayer)this.field_146297_k.field_71439_g)) {
            this.field_146289_q.func_175065_a("- Contributor", (float)(this.posX + 20), (float)(currentY += 10), 8858573, false);
        }
        if (Helper.isDateAroundHalloween()) {
            this.field_146289_q.func_175065_a("- Halloween", (float)(this.posX + 20), (float)(currentY += 10), 8858573, false);
        }
        super.func_73863_a(mouseX, mouseY, partialTick);
        this.drawPerkTooltip();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        GlStateManager.func_179091_B();
        GlStateManager.func_179121_F();
    }

    private void drawPerk(PerkIcon icon) {
        int levelWithBonus = this.cap.getPerkLevelWithBonus((EntityPlayer)this.field_146297_k.field_71439_g, icon.perk);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiKnowledge.func_73734_a((int)(icon.getMinX() - 1), (int)(icon.getMinY() - 1), (int)(icon.getMaxX() + 1), (int)(icon.getMaxY() + 1 + 10), (int)this.borderColor);
        if (levelWithBonus == 0 && (this.hoveredIcon == null || icon != this.hoveredIcon)) {
            this.func_73733_a(icon.getMinX(), icon.getMinY(), icon.getMaxX(), icon.getMaxY(), -13421773, -13421773);
            GlStateManager.func_179131_c((float)0.13f, (float)0.13f, (float)0.13f, (float)0.5f);
        } else {
            this.func_73733_a(icon.getMinX(), icon.getMinY(), icon.getMaxX(), icon.getMaxY(), -16703669, -7096363);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        ResourceLocation texture = icon.perk.getIcon();
        if (texture != null) {
            this.field_146297_k.func_110434_K().func_110577_a(texture);
            GuiKnowledge.func_152125_a((int)icon.getMinX(), (int)icon.getMinY(), (float)0.0f, (float)0.0f, (int)64, (int)64, (int)this.iconSize, (int)this.iconSize, (float)64.0f, (float)64.0f);
        }
        boolean hasBonus = icon.perk.getLevelBonus((EntityPlayer)this.field_146297_k.field_71439_g) != 0;
        this.field_146289_q.func_175065_a("" + levelWithBonus, (float)icon.getMinX() + (levelWithBonus > 9 ? 2.5f : 5.5f), (float)(icon.getMinY() + 18), levelWithBonus == 0 ? -7769547 : (hasBonus ? 8858573 : this.textColor), false);
        GlStateManager.func_179121_F();
    }

    private void drawPerkTooltip() {
        if (this.hoveredIcon != null) {
            this.hoveredPerkLevel = this.cap.getPerkLevel((EntityPlayer)this.field_146297_k.field_71439_g, this.hoveredIcon.perk);
            int levelWithBonus = this.cap.getPerkLevelWithBonus((EntityPlayer)this.field_146297_k.field_71439_g, this.hoveredIcon.perk);
            ArrayList<String> list = new ArrayList<String>(){
                {
                    this.add(((GuiKnowledge)GuiKnowledge.this).hoveredIcon.perk.getClientTranslation());
                }
            };
            String specialInfo = this.hoveredIcon.perk.getSpecialInfo(levelWithBonus);
            if (!specialInfo.isEmpty()) {
                list.add(specialInfo);
            }
            IntStream.rangeClosed(1, this.hoveredIcon.perk.getLevelMax()).forEach(i -> {
                String info = this.hoveredIcon.perk.getTooltip(i, this.hoveredPerkLevel, levelWithBonus);
                if (!info.isEmpty()) {
                    list.add((this.hoveredPerkLevel >= i ? TextFormatting.WHITE : ((this.hoveredIcon.perk.isEncrypted() ? levelWithBonus >= i : levelWithBonus == i) ? TextFormatting.DARK_PURPLE : TextFormatting.DARK_GRAY)).toString() + i + " -> " + info);
                }
            });
            if (this.hoveredPerkLevel < this.hoveredIcon.perk.getLevelMax()) {
                int cost = this.hoveredIcon.perk.getCost(this.hoveredPerkLevel + 1);
                boolean canUpgrade = this.leftPerkPoints >= cost;
                list.add((canUpgrade ? TextFormatting.AQUA : TextFormatting.RED) + LangKey.MESSAGE_COST.getClientTranslation(cost));
                list.add(canUpgrade ? TextFormatting.BLUE + LangKey.MESSAGE_CLICK_TO_UPGRADE.getClientTranslation(new Object[0]) : TextFormatting.RED + LangKey.MESSAGE_CANT_UPGRADE.getClientTranslation(new Object[0]));
            } else {
                list.add(TextFormatting.GOLD + LangKey.MESSAGE_MAX.getClientTranslation(new Object[0]));
            }
            this.drawHoveringText((List<String>)list, this.hoveredIcon.minX + 10, this.hoveredIcon.minY + 10, this.field_146289_q);
        }
    }

    public void drawHoveringText(List<String> textLines, int x, int y, FontRenderer font) {
        int maxTextWidth = 200;
        if (!textLines.isEmpty()) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = font.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = x + 12;
            if (tooltipX + tooltipTextWidth + 4 > this.field_146294_l && (tooltipX = x - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = x > this.field_146294_l / 2 ? x - 12 - 8 : this.field_146294_l - 16 - x;
                needsWrap = true;
            }
            if (tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = x > this.field_146294_l / 2 ? x - 16 - tooltipTextWidth : x + 12;
            }
            int tooltipY = y - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > this.field_146295_m) {
                tooltipY = this.field_146295_m - tooltipHeight - 4;
            }
            int zLevel = 300;
            int backgroundColor = -267386864;
            int borderColorStart = 0x505000FF;
            int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
            int perkLine = 0;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                boolean isPerkLine;
                String line = textLines.get(lineNumber);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                String[] splits = line.split(" -> ");
                boolean bl = isPerkLine = splits.length > 1;
                if (isPerkLine && this.hoveredIcon.perk.isEncrypted() && perkLine > this.cap.getPerkLevelWithBonus((EntityPlayer)this.field_146297_k.field_71439_g, this.hoveredIcon.perk)) {
                    String subString = splits[0] + " -> ";
                    font.func_175065_a(subString, (float)tooltipX, (float)tooltipY, -1980292, false);
                    Minecraft.func_71410_x().field_71464_q.func_175065_a(TextFormatting.DARK_GRAY + splits[1], (float)(tooltipX + font.func_78256_a(subString)), (float)tooltipY, -1980292, false);
                } else {
                    font.func_175065_a(line, (float)tooltipX, (float)tooltipY, -1980292, false);
                }
                if (isPerkLine) {
                    ++perkLine;
                }
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    public boolean func_73868_f() {
        return true;
    }

    public class PerkIcon {
        public final Perk perk;
        public int minX;
        public int minY;
        public int maxX;
        public int maxY;

        public PerkIcon(Perk perk) {
            this.perk = perk;
        }

        public void setPosition(int x, int y) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + 16;
            this.maxY = y + 16;
        }

        public boolean contains(int x, int y) {
            return x >= this.minX && y >= this.minY && x <= this.maxX && y <= this.maxY;
        }

        public int getMinX() {
            return this.minX;
        }

        public int getMinY() {
            return this.minY;
        }

        public int getMaxX() {
            return this.maxX;
        }

        public int getMaxY() {
            return this.maxY;
        }
    }
}

