/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.gui.TBGuiButton;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;

@SideOnly(value=Side.CLIENT)
public class GuiInfo
extends GuiScreen {
    private static final ResourceLocation GUI_BACKGROUND = new ResourceLocation("tombstone", "textures/gui/knowledge.png");
    private final int guiWidth = 166;
    private final int guiHeight = 166;
    private int posX;
    private int posY;
    @Nullable
    private Info currentInfo;
    @Nullable
    private Info lastInfo;
    @Nullable
    private Info hoveredInfo = null;
    private int linesByPage;
    private int pageCount;
    private int currentPage;
    private String title;
    private final List<String> contentLines = new ArrayList<String>();
    private final List<InfoLink> infoLinks = new ArrayList<InfoLink>();
    private final float scaled;
    private final float scaledRev;

    GuiInfo(@Nullable Info currentInfo) {
        this.currentInfo = this.lastInfo = currentInfo;
        this.currentPage = 0;
        this.scaled = Minecraft.func_71410_x().field_71474_y.field_74335_Z == 1 ? 1.0f : 2.0f;
        this.scaledRev = 1.0f / this.scaled;
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0 && this.hoveredInfo != null) {
            this.currentInfo = this.hoveredInfo;
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ((Object)((Object)this)).getClass();
        this.posX = (this.field_146294_l - 166) / 2;
        ((Object)((Object)this)).getClass();
        this.posY = (this.field_146295_m - 166) / 2;
        int centerPos = this.field_146294_l / 2;
        this.field_146292_n.add(new TBGuiButton(0, centerPos - 35, this.posY + 146, 70, 15, I18n.func_135052_a((String)LangKey.MESSAGE_BACK.getKey(), (Object[])new Object[0])));
        this.field_146292_n.add(new TBGuiButton(1, centerPos - 75, this.posY + 146, 20, 15, I18n.func_135052_a((String)"<-", (Object[])new Object[0])));
        this.field_146292_n.add(new TBGuiButton(2, centerPos + 55, this.posY + 146, 20, 15, I18n.func_135052_a((String)"->", (Object[])new Object[0])));
        this.updatePage(this.currentInfo);
    }

    private void updateContent(@Nullable Info currentInfo) {
        List<Info> infos;
        this.contentLines.clear();
        this.infoLinks.clear();
        String content = I18n.func_135052_a((String)(currentInfo == null ? "tombstone.compendium.main.desc" : currentInfo.getContent()), (Object[])new Object[0]);
        Arrays.stream(content.split("[\\r\\n]+")).filter(p -> p.length() > 0).forEach(c -> {
            ((Object)((Object)this)).getClass();
            this.contentLines.addAll(this.field_146289_q.func_78271_c(c, (int)((float)(166 - 15) * this.scaled)));
        });
        ((Object)((Object)this)).getClass();
        int x = this.posX + 166 + 5;
        int y = this.posY + 10;
        if (currentInfo == null) {
            infos = Arrays.stream(Info.values()).filter(p -> ((Info)p).isMainEntry).collect(Collectors.toList());
        } else {
            infos = Info.getRelated(currentInfo);
            infos.sort(Comparator.comparing(p -> Normalizer.normalize(I18n.func_135052_a((String)p.getTitle(), (Object[])new Object[0]), Normalizer.Form.NFD)));
        }
        for (Info info : infos) {
            this.infoLinks.add(new InfoLink(info, x, y));
            y += this.field_146289_q.field_78288_b / (int)this.scaled + 1;
        }
    }

    private void updatePage(@Nullable Info currentInfo) {
        this.lastInfo = currentInfo;
        this.title = I18n.func_135052_a((String)(currentInfo == null ? "tombstone.compendium.main.title" : currentInfo.getTitle()), (Object[])new Object[0]);
        this.updateContent(currentInfo);
        this.linesByPage = (int)Math.floor(9.0f * this.scaled);
        this.pageCount = (int)Math.ceil((float)this.contentLines.size() / (float)this.linesByPage);
        this.currentPage = 0;
        this.updateButtons();
    }

    private void updateButtons() {
        ((GuiButton)this.field_146292_n.get((int)1)).field_146125_m = this.currentPage > 0;
        ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = ((GuiButton)this.field_146292_n.get((int)1)).field_146125_m;
        ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = this.currentPage < this.pageCount - 1;
        ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m;
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                if (this.currentInfo == null) {
                    this.field_146297_k.field_71439_g.func_71053_j();
                    break;
                }
                this.currentInfo = null;
                break;
            }
            case 1: {
                --this.currentPage;
                this.updateButtons();
                break;
            }
            case 2: {
                ++this.currentPage;
                this.updateButtons();
                break;
            }
        }
    }

    public void func_146276_q_() {
        super.func_146276_q_();
        int borderColor = -15524569;
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        GuiInfo.func_73734_a((int)(this.posX - 3), (int)(this.posY - 3), (int)(this.posX + 166 + 3), (int)(this.posY + 166 + 3), (int)borderColor);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_BACKGROUND);
        GuiInfo.func_146110_a((int)this.posX, (int)this.posY, (float)0.0f, (float)0.0f, (int)166, (int)166, (float)166.0f, (float)166.0f);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        this.func_146276_q_();
        this.hoveredInfo = null;
        if (this.currentInfo != this.lastInfo) {
            this.updatePage(this.currentInfo);
        }
        ((Object)((Object)this)).getClass();
        GuiInfo.func_73734_a((int)(this.posX + 5), (int)(this.posY + 5), (int)(this.posX + 166 - 5), (int)(this.posY + 20 + this.field_146289_q.field_78288_b), (int)0x55000000);
        this.field_146289_q.func_78276_b(this.title, this.posX + 30, this.posY + 15, -7769547);
        if (this.currentInfo != null) {
            GlStateManager.func_179152_a((float)this.scaledRev, (float)this.scaledRev, (float)this.scaledRev);
            String string = this.currentPage + 1 + "/" + this.pageCount;
            ((Object)((Object)this)).getClass();
            this.field_146289_q.func_175065_a(string, (float)(this.posX + 166) * this.scaled - 30.0f, (float)(this.posY + 6) * this.scaled, -7769547, false);
            GlStateManager.func_179152_a((float)this.scaled, (float)this.scaled, (float)this.scaled);
        }
        if (this.currentInfo == null) {
            GuiInfo.func_73734_a((int)(this.posX + 7), (int)(this.posY + 7), (int)(this.posX + 18 + this.field_146289_q.field_78288_b), (int)(this.posY + 18 + this.field_146289_q.field_78288_b), (int)-9790778);
            this.field_146296_j.func_180450_b(new ItemStack((Block)ModBlocks.decorative_tombstone), (int)((float)(this.posX + 9) / 1.0f), (int)((float)(this.posY + 9) / 1.0f));
        } else if (!this.currentInfo.icon.func_190926_b()) {
            GuiInfo.func_73734_a((int)(this.posX + 7), (int)(this.posY + 7), (int)(this.posX + 18 + this.field_146289_q.field_78288_b), (int)(this.posY + 18 + this.field_146289_q.field_78288_b), (int)-9790778);
            this.field_146296_j.func_180450_b(this.currentInfo.icon, (int)((float)(this.posX + 9) / 1.0f), (int)((float)(this.posY + 9) / 1.0f));
        }
        GlStateManager.func_179152_a((float)this.scaledRev, (float)this.scaledRev, (float)this.scaledRev);
        int indexStart = Math.min(this.currentPage * this.linesByPage, this.contentLines.size() - 1);
        int indexEnd = Math.min(indexStart + this.linesByPage - 1, this.contentLines.size() - 1);
        if (indexStart >= 0) {
            int n = (int)((float)(this.posX + 5) * this.scaled);
            int n2 = (int)((float)(this.posY + 34) * this.scaled);
            ((Object)((Object)this)).getClass();
            GuiInfo.func_73734_a((int)n, (int)n2, (int)((int)((float)(this.posX + 166 - 5) * this.scaled)), (int)((int)((float)(this.posY + 44 + (this.field_146289_q.field_78288_b / (int)this.scaled + 1) * (indexEnd - indexStart + 1)) * this.scaled)), (int)0x55000000);
            int count = 0;
            for (int i = indexStart; i <= indexEnd; ++i) {
                this.field_146289_q.func_175065_a(this.contentLines.get(i), (float)(this.posX + 10) * this.scaled, (float)(this.posY + 39 + count * (this.field_146289_q.field_78288_b / (int)this.scaled + 1)) * this.scaled, -7769547, false);
                ++count;
            }
        }
        for (InfoLink link : this.infoLinks) {
            if (this.hoveredInfo == null && link.isHovered(mouseX, mouseY)) {
                this.hoveredInfo = link.info;
                this.field_146289_q.func_175065_a(link.title, (float)link.x * this.scaled, (float)link.y * this.scaled, -1, false);
                continue;
            }
            this.field_146289_q.func_175065_a(link.title, (float)link.x * this.scaled, (float)link.y * this.scaled, -7769547, false);
        }
        GlStateManager.func_179152_a((float)this.scaled, (float)this.scaled, (float)this.scaled);
        super.func_73863_a(mouseX, mouseY, partialTick);
    }

    public boolean func_73868_f() {
        return true;
    }

    static enum Info {
        DEATH(new ItemStack(ModItems.advancement, 1, 0), true),
        DECORATIVE_GRAVE(new ItemStack((Block)ModBlocks.decorative_grave_simple), true, "tombstone.config_cat.decorative_grave"),
        MAGIC_ITEMS(new ItemStack(ModItems.advancement, 1, 2), true),
        KNOWLEDGE_OF_DEATH(new ItemStack((Item)ModItems.ankh_of_pray), true, "tombstone.message.knowledge_of_death"),
        SPECIAL_BONUS(ItemStack.field_190927_a, true),
        ANKH_OF_PRAY(new ItemStack((Item)ModItems.ankh_of_pray), false, "tombstone.item.ankh_of_pray.name"),
        BOOK_OF_DISENCHANTMENT(new ItemStack((Item)ModItems.book_of_disenchantment), false, "tombstone.item.book_of_disenchantment.name"),
        CONTRIBUTOR(ItemStack.field_190927_a, false),
        DARK_MARBLE(new ItemStack(ModBlocks.dark_marble), false, "tombstone.tile.dark_marble.name"),
        DUST_OF_VANISHING(new ItemStack((Item)ModItems.dust_of_vanishing), false, "tombstone.item.dust_of_vanishing.name"),
        FAMILIAR_RECEPTACLE(new ItemStack((Item)ModItems.familiar_receptacle), false, "tombstone.item.familiar_receptacle.name"),
        FISHING_ROD_OF_MISADVENTURE(new ItemStack((Item)ModItems.fishing_rod_of_misadventure), false, "tombstone.item.fishing_rod_of_misadventure.name"),
        GHOSTLY_SHAPE(new ItemStack(ModItems.advancement, 1, 1), false, "tombstone.potion.ghostly_shape.name"),
        GRAVE_DUST(ItemCraftingIngredient.IconType.GRAVE_DUST.getStack(), false, "tombstone.item.grave_dust.name"),
        GRAVE_KEY(new ItemStack((Item)ModItems.grave_key), false, "tombstone.item.grave_key.name"),
        HALLOWEEN(new ItemStack(ModItems.advancement, 1, 6), false),
        IMPREGNATED_DIAMOND(ItemCraftingIngredient.IconType.IMPREGNATED_DIAMOND.getStack(), false, "tombstone.item.impregnated_diamond.name"),
        LOLLIPOP(new ItemStack(ModItems.lollypop), false, "tombstone.item.lollypop.name"),
        LOST_TABLET(new ItemStack((Item)ModItems.lost_tablet), false, "tombstone.item.lost_tablet.name"),
        PERK(ItemStack.field_190927_a, false),
        SCROLL_OF_FEATHER_FALL(new ItemStack((Item)ModItems.scroll_buff, 1, 2), false, "tombstone.item.scroll_of_feather_fall.name"),
        SCROLL_OF_KNOWLEDGE(new ItemStack((Item)ModItems.scroll_of_knowledge), false, "tombstone.item.scroll_of_knowledge.name"),
        SCROLL_OF_PRESERVATION(new ItemStack((Item)ModItems.scroll_buff, 1, 0), false, "tombstone.item.scroll_of_preservation.name"),
        SCROLL_OF_PURIFICATION(new ItemStack((Item)ModItems.scroll_buff, 1, 3), false, "tombstone.item.scroll_of_purification.name"),
        SCROLL_OF_TRUE_SIGHT(new ItemStack((Item)ModItems.scroll_buff, 1, 4), false, "tombstone.item.scroll_of_true_sight.name"),
        SCROLL_OF_UNSTABLE_INTANGIBLENESS(new ItemStack((Item)ModItems.scroll_buff, 1, 1), false, "tombstone.item.scroll_of_unstable_intangibleness.name"),
        MAGIC_SCROLLS(ItemCraftingIngredient.IconType.STRANGE_SCROLL.getStack(), false),
        SOUL(new ItemStack(ModItems.advancement, 1, 5), false),
        SOUL_RECEPTACLE(new ItemStack((Item)ModItems.soul_receptacle), false, "tombstone.item.soul_receptacle.name"),
        STRANGE_SCROLL(ItemCraftingIngredient.IconType.STRANGE_SCROLL.getStack(), false, "tombstone.item.strange_scroll.name"),
        STRANGE_TABLET(ItemCraftingIngredient.IconType.STRANGE_TABLET.getStack(), false, "tombstone.item.strange_tablet.name"),
        TABLET_OF_RECALL(new ItemStack((Item)ModItems.tablet_of_recall), false, "tombstone.item.tablet_of_recall.name"),
        TABLET_OF_ASSISTANCE(new ItemStack((Item)ModItems.tablet_of_assistance), false, "tombstone.item.tablet_of_assistance.name"),
        MAGIC_TABLETS(ItemCraftingIngredient.IconType.STRANGE_TABLET.getStack(), false),
        VOODOO_POPPET(new ItemStack((Item)ModItems.voodoo_poppet), false, "tombstone.item.voodoo_poppet.name");

        private final ItemStack icon;
        private final boolean isMainEntry;
        private final String title;

        private Info(ItemStack icon, boolean isMainEntry) {
            this(icon, isMainEntry, null);
        }

        private Info(@Nullable ItemStack icon, boolean isMainEntry, String titleKey) {
            this.icon = icon;
            this.isMainEntry = isMainEntry;
            this.title = titleKey == null ? "tombstone.compendium." + this.name().toLowerCase() + ".title" : titleKey;
        }

        public final String getTitle() {
            return this.title;
        }

        public final String getContent() {
            return "tombstone.compendium." + this.name().toLowerCase() + ".desc";
        }

        public static List<Info> getRelated(Info info) {
            ArrayList<Info> infos = new ArrayList<Info>();
            switch (info) {
                case ANKH_OF_PRAY: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(PERK);
                    infos.add(SOUL);
                    break;
                }
                case BOOK_OF_DISENCHANTMENT: {
                    infos.add(MAGIC_ITEMS);
                    infos.add(PERK);
                    infos.add(SOUL);
                    break;
                }
                case CONTRIBUTOR: {
                    infos.add(LOLLIPOP);
                    infos.add(SPECIAL_BONUS);
                    break;
                }
                case DARK_MARBLE: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(GRAVE_DUST);
                    break;
                }
                case DEATH: {
                    infos.add(GHOSTLY_SHAPE);
                    infos.add(GRAVE_KEY);
                    infos.add(PERK);
                    break;
                }
                case DECORATIVE_GRAVE: {
                    infos.add(DARK_MARBLE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case DUST_OF_VANISHING: {
                    infos.add(GRAVE_DUST);
                    infos.add(MAGIC_ITEMS);
                    break;
                }
                case FAMILIAR_RECEPTACLE: {
                    infos.add(ANKH_OF_PRAY);
                    infos.add(IMPREGNATED_DIAMOND);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case FISHING_ROD_OF_MISADVENTURE: {
                    infos.add(LOST_TABLET);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case GHOSTLY_SHAPE: {
                    infos.add(DEATH);
                    break;
                }
                case GRAVE_DUST: {
                    infos.add(DARK_MARBLE);
                    infos.add(DUST_OF_VANISHING);
                    infos.add(IMPREGNATED_DIAMOND);
                    break;
                }
                case GRAVE_KEY: {
                    infos.add(DEATH);
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case HALLOWEEN: {
                    infos.add(LOLLIPOP);
                    infos.add(SPECIAL_BONUS);
                    break;
                }
                case IMPREGNATED_DIAMOND: {
                    infos.add(GRAVE_DUST);
                    infos.add(FAMILIAR_RECEPTACLE);
                    break;
                }
                case KNOWLEDGE_OF_DEATH: {
                    infos.add(ANKH_OF_PRAY);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(SOUL);
                    infos.add(SOUL_RECEPTACLE);
                    break;
                }
                case LOLLIPOP: {
                    infos.add(CONTRIBUTOR);
                    infos.add(HALLOWEEN);
                    infos.add(MAGIC_ITEMS);
                    break;
                }
                case LOST_TABLET: {
                    infos.add(FISHING_ROD_OF_MISADVENTURE);
                    infos.add(MAGIC_TABLETS);
                    infos.add(PERK);
                    infos.add(SOUL);
                    break;
                }
                case MAGIC_ITEMS: {
                    infos.add(ANKH_OF_PRAY);
                    infos.add(BOOK_OF_DISENCHANTMENT);
                    infos.add(DUST_OF_VANISHING);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(FISHING_ROD_OF_MISADVENTURE);
                    infos.add(GRAVE_KEY);
                    infos.add(LOLLIPOP);
                    infos.add(MAGIC_SCROLLS);
                    infos.add(SOUL_RECEPTACLE);
                    infos.add(MAGIC_TABLETS);
                    infos.add(VOODOO_POPPET);
                    break;
                }
                case MAGIC_SCROLLS: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(SCROLL_OF_FEATHER_FALL);
                    infos.add(SCROLL_OF_KNOWLEDGE);
                    infos.add(SCROLL_OF_PRESERVATION);
                    infos.add(SCROLL_OF_PURIFICATION);
                    infos.add(SCROLL_OF_TRUE_SIGHT);
                    infos.add(SCROLL_OF_UNSTABLE_INTANGIBLENESS);
                    infos.add(SOUL);
                    infos.add(STRANGE_SCROLL);
                    break;
                }
                case STRANGE_SCROLL: {
                    infos.add(GRAVE_DUST);
                    infos.add(MAGIC_SCROLLS);
                    break;
                }
                case STRANGE_TABLET: {
                    infos.add(DARK_MARBLE);
                    infos.add(GRAVE_DUST);
                    infos.add(MAGIC_TABLETS);
                    break;
                }
                case MAGIC_TABLETS: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(PERK);
                    infos.add(LOST_TABLET);
                    infos.add(SOUL);
                    infos.add(STRANGE_TABLET);
                    infos.add(TABLET_OF_ASSISTANCE);
                    infos.add(TABLET_OF_RECALL);
                    break;
                }
                case PERK: {
                    infos.add(DEATH);
                    infos.add(GHOSTLY_SHAPE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    break;
                }
                case SCROLL_OF_FEATHER_FALL: 
                case SCROLL_OF_KNOWLEDGE: 
                case SCROLL_OF_PRESERVATION: 
                case SCROLL_OF_PURIFICATION: 
                case SCROLL_OF_TRUE_SIGHT: 
                case SCROLL_OF_UNSTABLE_INTANGIBLENESS: {
                    infos.add(MAGIC_SCROLLS);
                    infos.add(SOUL);
                    break;
                }
                case SOUL: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL_RECEPTACLE);
                    break;
                }
                case SOUL_RECEPTACLE: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case SPECIAL_BONUS: {
                    infos.add(CONTRIBUTOR);
                    infos.add(HALLOWEEN);
                    break;
                }
                case TABLET_OF_ASSISTANCE: 
                case TABLET_OF_RECALL: {
                    infos.add(MAGIC_TABLETS);
                    infos.add(SOUL);
                    break;
                }
                case VOODOO_POPPET: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                }
            }
            return infos;
        }
    }

    public class InfoLink {
        private final String title;
        private final Info info;
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        InfoLink(Info info, int x, int y) {
            this.title = I18n.func_135052_a((String)info.getTitle(), (Object[])new Object[0]);
            this.info = info;
            this.x = x;
            this.y = y;
            this.width = GuiInfo.this.field_146289_q.func_78256_a(this.title) / (int)GuiInfo.this.scaled;
            this.height = ((GuiInfo)GuiInfo.this).field_146289_q.field_78288_b / (int)GuiInfo.this.scaled + 1;
        }

        boolean isHovered(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseY >= this.y && mouseX <= this.x + this.width & mouseY <= this.y + this.height;
        }
    }
}

