/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;

public class CommandTBRestoreInventory
extends TombstoneCommand {
    public String func_71517_b() {
        return "tbrestoreinventory";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = args.length == 0 ? CommandTBRestoreInventory.func_71521_c((ICommandSender)sender) : CommandTBRestoreInventory.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        this.checkAlive((Entity)player);
        this.checkNotSpectator((EntityPlayer)player);
        if (player.field_70170_p == null) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        Location lastGrave = DeathHandler.instance.getLastGrave(player.func_70005_c_());
        if (lastGrave.isOrigin()) {
            lastGrave = ModItems.grave_key.getTombPos(ModItems.grave_key.findFirstKeyInInventory((EntityPlayer)player));
        }
        if (lastGrave.isOrigin()) throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_GRAVE.getKey(), new Object[0]);
        if (!Helper.isValidDimension(lastGrave.dim)) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_DIMENSION.getKey(), new Object[0]);
        }
        WorldServer world = server.func_71218_a(lastGrave.dim);
        if (world.func_189509_E(lastGrave.getPos())) throw new CommandException(LangKey.COMMAND_EXCEPTION_INVALID_LOCATION.getKey(), new Object[0]);
        TileEntity tile = world.func_175625_s(lastGrave.getPos());
        if (!(tile instanceof TileEntityTombstone)) return;
        ModItems.grave_key.removeKeyForGraveInInventory((EntityPlayer)player, lastGrave);
        ((TileEntityTombstone)tile).giveInventory((EntityPlayer)player);
        LangKey.MESSAGE_RECOVER_LOST_ITEMS.sendSpecialMessage((ICommandSender)player, new Object[0]);
        CommandTBRestoreInventory.func_152373_a((ICommandSender)sender, (ICommand)this, (String)LangKey.MESSAGE_OPEN_GRAVE_SUCCESS.getKey(), (Object[])new Object[0]);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return args.length == 1 ? CommandTBRestoreInventory.func_71530_a((String[])args, (String[])server.func_71213_z()) : Collections.emptyList();
    }
}

