/*
 * Decompiled with CFR 0.152.
 */
package com.codingforcookies.betterrecords.item;

import com.codingforcookies.betterrecords.api.sound.IColorableSoundHolder;
import com.codingforcookies.betterrecords.api.sound.IRepeatableSoundHolder;
import com.codingforcookies.betterrecords.api.sound.IShufflableSoundHolder;
import com.codingforcookies.betterrecords.api.sound.ISoundHolder;
import com.codingforcookies.betterrecords.api.sound.Sound;
import com.codingforcookies.betterrecords.item.ModItem;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/codingforcookies/betterrecords/item/ItemRecord;", "Lcom/codingforcookies/betterrecords/item/ModItem;", "Lcom/codingforcookies/betterrecords/api/sound/ISoundHolder;", "Lcom/codingforcookies/betterrecords/api/sound/IRepeatableSoundHolder;", "Lcom/codingforcookies/betterrecords/api/sound/IShufflableSoundHolder;", "Lcom/codingforcookies/betterrecords/api/sound/IColorableSoundHolder;", "name", "", "(Ljava/lang/String;)V", "maxSounds", "", "getMaxSounds", "()I", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "getItemStackDisplayName", "getUnlocalizedName", "BetterRecords"})
public final class ItemRecord
extends ModItem
implements ISoundHolder,
IRepeatableSoundHolder,
IShufflableSoundHolder,
IColorableSoundHolder {
    private final int maxSounds = 12;

    @Override
    public int getMaxSounds() {
        return this.maxSounds;
    }

    @NotNull
    public String func_77667_c(@NotNull ItemStack stack) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        List<Sound> songs = this.getSounds(stack);
        Collection collection = songs;
        switch (collection.size()) {
            case 0: {
                string = "item.betterrecords:record.blank";
                break;
            }
            default: {
                string = "item.betterrecords:record.multi";
            }
        }
        return string;
    }

    @NotNull
    public String func_77653_i(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        List<Sound> songs = this.getSounds(stack);
        Collection collection = songs;
        if (collection.size() == 1) {
            return ((Sound)CollectionsKt.first(songs)).getName();
        }
        String string = super.func_77653_i(stack);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"super.getItemStackDisplayName(stack)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull(tooltip, (String)"tooltip");
        Intrinsics.checkParameterIsNotNull((Object)flag, (String)"flag");
        List<Sound> songs = this.getSounds(stack);
        Collection collection = songs;
        if (!collection.isEmpty()) {
            Iterable $receiver$iv;
            if (songs.size() > 1) {
                $receiver$iv = songs;
                int index$iv = 0;
                for (Object item$iv : $receiver$iv) {
                    void sound;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n2 = n;
                    Sound sound2 = (Sound)item$iv;
                    int index = n2;
                    Collection collection2 = tooltip;
                    String string = I18n.func_135052_a((String)"item.betterrecords:record.desc.song", (Object[])new Object[]{index + 1, sound.getName()});
                    collection2.add(string);
                }
            } else {
                $receiver$iv = tooltip;
                String index$iv = I18n.func_135052_a((String)"item.betterrecords:record.desc.by", (Object[])new Object[]{((Sound)CollectionsKt.first(songs)).getAuthor()});
                $receiver$iv.add(index$iv);
            }
            Iterable $receiver$iv2 = songs;
            int sum$iv = 0;
            for (Object element$iv : $receiver$iv2) {
                void it;
                Sound sound = (Sound)element$iv;
                int n = sum$iv;
                int n3 = it.getSize();
                sum$iv = n + n3;
            }
            int size = sum$iv;
            Collection collection3 = tooltip;
            String string = I18n.func_135052_a((String)"item.betterrecords:record.desc.size", (Object[])new Object[]{size});
            collection3.add(string);
            if (this.isRepeatable(stack)) {
                collection3 = tooltip;
                string = "\u00a7e" + I18n.func_135052_a((String)"item.betterrecords:record.desc.repeatable", (Object[])new Object[0]);
                collection3.add(string);
            }
            if (this.isShufflable(stack)) {
                collection3 = tooltip;
                string = "\u00a7e" + I18n.func_135052_a((String)"item.betterrecords:record.desc.shufflable", (Object[])new Object[0]);
                collection3.add(string);
            }
        }
    }

    public ItemRecord(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(name);
        this.maxSounds = 12;
        this.field_77777_bU = 1;
    }

    @Override
    public boolean isFullOfSounds(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return ISoundHolder.DefaultImpls.isFullOfSounds(this, stack);
    }

    @Override
    public void addSound(@NotNull ItemStack stack, @NotNull Sound sound) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)sound, (String)"sound");
        ISoundHolder.DefaultImpls.addSound(this, stack, sound);
    }

    @Override
    @NotNull
    public List<Sound> getSounds(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return ISoundHolder.DefaultImpls.getSounds(this, stack);
    }

    @Override
    public boolean isRepeatable(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return IRepeatableSoundHolder.DefaultImpls.isRepeatable(this, stack);
    }

    @Override
    public void setRepeatable(@NotNull ItemStack stack, boolean repeatable) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        IRepeatableSoundHolder.DefaultImpls.setRepeatable(this, stack, repeatable);
    }

    @Override
    public boolean isShufflable(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return IShufflableSoundHolder.DefaultImpls.isShufflable(this, stack);
    }

    @Override
    public void setShufflable(@NotNull ItemStack stack, boolean shufflable) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        IShufflableSoundHolder.DefaultImpls.setShufflable(this, stack, shufflable);
    }

    @Override
    public int getColor(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return IColorableSoundHolder.DefaultImpls.getColor(this, stack);
    }

    @Override
    public void setColor(@NotNull ItemStack stack, int color2) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        IColorableSoundHolder.DefaultImpls.setColor(this, stack, color2);
    }
}

