/*
 * Decompiled with CFR 0.152.
 */
package com.codingforcookies.betterrecords.helper;

import com.codingforcookies.betterrecords.api.connection.RecordConnection;
import com.codingforcookies.betterrecords.api.wire.IRecordWire;
import com.codingforcookies.betterrecords.api.wire.IRecordWireHome;
import com.codingforcookies.betterrecords.item.ModItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0011J*\u0010\u0012\u001a\u00020\u00102\"\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u0014j\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0015`\u0016J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\t\u001a\u00020\u0010J*\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u0014j\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0015`\u00162\u0006\u0010\u0013\u001a\u00020\u0010\u00a8\u0006\u0019"}, d2={"Lcom/codingforcookies/betterrecords/helper/ConnectionHelper;", "", "()V", "addConnection", "", "world", "Lnet/minecraft/world/World;", "iRecordWire", "Lcom/codingforcookies/betterrecords/api/wire/IRecordWire;", "rec", "Lcom/codingforcookies/betterrecords/api/connection/RecordConnection;", "state", "Lnet/minecraft/block/state/IBlockState;", "clearConnections", "removeConnection", "serializeConnections", "", "", "serializeWireSystemInfo", "wireSystemInfo", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "unserializeConnections", "unserializeWireSystemInfo", "BetterRecords"})
public final class ConnectionHelper {
    public static final ConnectionHelper INSTANCE;

    @NotNull
    public final String serializeConnections(@NotNull List<RecordConnection> rec) {
        Intrinsics.checkParameterIsNotNull(rec, (String)"rec");
        if (rec.isEmpty()) {
            return "";
        }
        String ret = "";
        for (RecordConnection recc : rec) {
            ret = ret + recc.toString() + "]";
        }
        String string = ret;
        int n = 0;
        int n2 = ret.length() - 1;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final List<RecordConnection> unserializeConnections(@NotNull String rec) {
        Intrinsics.checkParameterIsNotNull((Object)rec, (String)"rec");
        String string = rec;
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)"")) {
            return CollectionsKt.emptyList();
        }
        List recc = StringsKt.split$default((CharSequence)rec, (String[])new String[]{"]"}, (boolean)false, (int)0, (int)6, null);
        List ret = new ArrayList();
        for (String str : recc) {
            Collection collection = ret;
            RecordConnection recordConnection = new RecordConnection(str);
            collection.add(recordConnection);
        }
        return ret;
    }

    @NotNull
    public final String serializeWireSystemInfo(@NotNull HashMap<String, Integer> wireSystemInfo) {
        Object object;
        Intrinsics.checkParameterIsNotNull(wireSystemInfo, (String)"wireSystemInfo");
        if (wireSystemInfo.isEmpty()) {
            return "";
        }
        String ret = "";
        Map map = wireSystemInfo;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            String key = (String)object2.getKey();
            object2 = object;
            int value = ((Number)object2.getValue()).intValue();
            ret = ret + key + ',' + value + ']';
        }
        object = ret;
        int n = 0;
        int n2 = ret.length() - 1;
        Object object3 = object;
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object3).substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HashMap<String, Integer> unserializeWireSystemInfo(@NotNull String wireSystemInfo) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)wireSystemInfo, (String)"wireSystemInfo");
        String $receiver$iv2 = wireSystemInfo;
        CharSequence $receiver$iv$iv2 = $receiver$iv2;
        int startIndex$iv$iv22 = 0;
        int endIndex$iv$iv22 = $receiver$iv$iv2.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv22 <= endIndex$iv$iv22) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv22 : endIndex$iv$iv22;
            char it = $receiver$iv$iv2.charAt(index$iv$iv);
            boolean bl = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv22;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv22;
        }
        if (Intrinsics.areEqual((Object)((Object)$receiver$iv$iv2.subSequence(startIndex$iv$iv22, endIndex$iv$iv22 + 1)).toString(), (Object)"")) {
            return new HashMap<String, Integer>();
        }
        List wsi = StringsKt.split$default((CharSequence)wireSystemInfo, (String[])new String[]{"]"}, (boolean)false, (int)0, (int)6, null);
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        Iterable startIndex$iv$iv22 = wsi;
        void endIndex$iv$iv22 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String $i$a$1$trim = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            List list = StringsKt.split$default((CharSequence)((CharSequence)it), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            collection.add(list);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            List it = (List)element$iv;
            ret.put((String)CollectionsKt.first((List)it), Integer.parseInt((String)it.get(1)));
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public final void addConnection(@NotNull World world, @NotNull IRecordWire iRecordWire, @NotNull RecordConnection rec, @NotNull IBlockState state) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)iRecordWire, (String)"iRecordWire");
        Intrinsics.checkParameterIsNotNull((Object)rec, (String)"rec");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)iRecordWire.getConnections().size());
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            if (!iRecordWire.getConnections().get(it).same(rec)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        iterator = $receiver$iv.iterator();
        if (iterator.hasNext()) {
            Object element$iv = iterator.next();
            int it = ((Number)element$iv).intValue();
            return;
        }
        iRecordWire.getConnections().add(rec);
        world.func_184138_a(((TileEntity)iRecordWire).func_174877_v(), state, state, 3);
        TileEntity te = world.func_175625_s(new BlockPos(rec.getX1(), rec.getY1(), rec.getZ1()));
        if (te != null && te instanceof IRecordWireHome && Intrinsics.areEqual((Object)te, (Object)iRecordWire) ^ true) {
            ((IRecordWireHome)te).increaseAmount(iRecordWire);
            world.func_184138_a(((TileEntity)iRecordWire).func_174877_v(), state, state, 3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeConnection(@NotNull World world, @NotNull IRecordWire iRecordWire, @NotNull RecordConnection rec) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)iRecordWire, (String)"iRecordWire");
        Intrinsics.checkParameterIsNotNull((Object)rec, (String)"rec");
        int n = 0;
        int n2 = iRecordWire.getConnections().size();
        while (n < n2) {
            void i;
            if (iRecordWire.getConnections().get((int)i).same(rec)) {
                TileEntity te = world.func_175625_s(new BlockPos(iRecordWire.getConnections().get((int)i).getX1(), iRecordWire.getConnections().get((int)i).getY1(), iRecordWire.getConnections().get((int)i).getZ1()));
                if (te != null && te instanceof IRecordWireHome && te != iRecordWire) {
                    ((IRecordWireHome)te).decreaseAmount(iRecordWire);
                    BlockPos pos = ((TileEntity)iRecordWire).func_174877_v();
                    world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
                    Random rand = new Random();
                    float rx = rand.nextFloat() * 0.8f + 0.1f;
                    float ry = rand.nextFloat() * 0.8f + 0.1f;
                    float rz = rand.nextFloat() * 0.8f + 0.1f;
                    BlockPos blockPos = te.func_174877_v();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"te.pos");
                    double d = (float)blockPos.func_177958_n() + rx;
                    BlockPos blockPos2 = te.func_174877_v();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"te.pos");
                    double d2 = (float)blockPos2.func_177956_o() + ry;
                    BlockPos blockPos3 = te.func_174877_v();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"te.pos");
                    EntityItem entityItem = new EntityItem(world, d, d2, (double)((float)blockPos3.func_177952_p() + rz), new ItemStack((Item)ModItems.INSTANCE.getItemWire()));
                    entityItem.field_70159_w = rand.nextGaussian() * (double)0.05f;
                    entityItem.field_70181_x = rand.nextGaussian() * (double)0.05f + (double)0.2f;
                    entityItem.field_70179_y = rand.nextGaussian() * (double)0.05f;
                    world.func_72838_d((Entity)entityItem);
                    this.removeConnection(world, (IRecordWire)te, rec);
                }
                iRecordWire.getConnections().remove((int)i);
                break;
            }
            ++i;
        }
    }

    public final void clearConnections(@NotNull World world, @NotNull IRecordWire iRecordWire) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)iRecordWire, (String)"iRecordWire");
        while (iRecordWire.getConnections().size() != 0) {
            RecordConnection connection = iRecordWire.getConnections().get(0);
            TileEntity te = world.func_175625_s(new BlockPos(connection.getX1(), connection.getY1(), connection.getZ1()));
            if (te != null && te instanceof IRecordWire) {
                this.removeConnection(world, iRecordWire, connection);
                world.func_184138_a(te.func_174877_v(), world.func_180495_p(te.func_174877_v()), world.func_180495_p(te.func_174877_v()), 3);
                continue;
            }
            System.err.println("Warning on clearing connections: Attached block is not a member of IRecordWire! This may cause ghost connections until a relog!");
            iRecordWire.getConnections().remove(0);
        }
        BlockPos pos = ((TileEntity)iRecordWire).func_174877_v();
        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
    }

    private ConnectionHelper() {
    }

    static {
        ConnectionHelper connectionHelper;
        INSTANCE = connectionHelper = new ConnectionHelper();
    }
}

