/*
 * Decompiled with CFR 0.152.
 */
package com.codingforcookies.betterrecords.client.sound;

import com.codingforcookies.betterrecords.BetterRecords;
import com.codingforcookies.betterrecords.ModConfig;
import com.codingforcookies.betterrecords.api.connection.RecordConnection;
import com.codingforcookies.betterrecords.api.record.IRecordAmplitude;
import com.codingforcookies.betterrecords.api.sound.Sound;
import com.codingforcookies.betterrecords.api.wire.IRecordWireHome;
import com.codingforcookies.betterrecords.client.handler.ClientRenderHandler;
import com.codingforcookies.betterrecords.client.sound.IcyURLConnection;
import com.codingforcookies.betterrecords.client.sound.SoundPlayer;
import com.codingforcookies.betterrecords.util.DownloadUtilKt;
import com.codingforcookies.betterrecords.util.VolumeCalcUtilKt;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.SourceDataLine;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldProvider;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\tJ \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0016\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\tJ \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\tH\u0002J \u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u001e\u0010!\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\nJ\u001e\u0010#\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\nJ \u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\tH\u0002J(\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0016\u0010*\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\tJ \u0010+\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0005\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0004\u0012\u00020\n0\u0006j\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/codingforcookies/betterrecords/client/sound/SoundPlayer;", "", "()V", "downloadFolder", "Ljava/io/File;", "playingSounds", "Ljava/util/HashMap;", "Lkotlin/Pair;", "Lnet/minecraft/util/math/BlockPos;", "", "Lcom/codingforcookies/betterrecords/api/sound/Sound;", "Lkotlin/collections/HashMap;", "getLine", "Ljavax/sound/sampled/SourceDataLine;", "audioFormat", "Ljavax/sound/sampled/AudioFormat;", "getSoundPlayingAt", "pos", "dimension", "getUnscaledWaveform", "", "buffer", "", "high", "", "control", "isSoundPlayingAt", "play", "", "ain", "Ljavax/sound/sampled/AudioInputStream;", "playFile", "file", "playSound", "sound", "playSoundFromStream", "playStream", "stream", "Ljava/io/InputStream;", "rawPlay", "targetFormat", "din", "stopPlayingAt", "updateLights", "BetterRecords"})
public final class SoundPlayer {
    private static final File downloadFolder;
    private static final HashMap<Pair<BlockPos, Integer>, Sound> playingSounds;
    public static final SoundPlayer INSTANCE;

    public final void playSound(@NotNull BlockPos pos, int dimension, @NotNull Sound sound) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)sound, (String)"sound");
        BetterRecords.INSTANCE.getLogger().info("Playing sound at " + pos + " in Dimension " + dimension);
        ClientRenderHandler.INSTANCE.setNowDownloading(sound.getName());
        ClientRenderHandler.INSTANCE.setShowDownloading(true);
        String string2 = FilenameUtils.getName((String)sound.getUrl());
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FilenameUtils.getName(sound.url)");
        CharSequence charSequence = string2;
        Regex regex = new Regex("[^a-zA-Z0-9_\\.]");
        String string3 = "_";
        File file = downloadFolder;
        String string4 = string = regex.replace(charSequence, string3);
        File file2 = file;
        File targetFile = new File(file2, string4);
        DownloadUtilKt.downloadFile(new URL(sound.getUrl()), targetFile, (Function2<? super Float, ? super Float, Unit>)((Function2)playSound.1.INSTANCE), (Function0<Unit>)((Function0)new Function0<Unit>(sound, pos, dimension, targetFile){
            final /* synthetic */ Sound $sound;
            final /* synthetic */ BlockPos $pos;
            final /* synthetic */ int $dimension;
            final /* synthetic */ File $targetFile;

            public final void invoke() {
                ClientRenderHandler.INSTANCE.setShowDownloading(false);
                Map map = SoundPlayer.access$getPlayingSounds$p(SoundPlayer.INSTANCE);
                Pair pair = new Pair((Object)this.$pos, (Object)this.$dimension);
                Sound sound = this.$sound;
                map.put(pair, sound);
                ClientRenderHandler.INSTANCE.showPlayingWithTimeout(this.$sound.getName());
                SoundPlayer.access$playFile(SoundPlayer.INSTANCE, this.$targetFile, this.$pos, this.$dimension);
            }
            {
                this.$sound = sound;
                this.$pos = blockPos;
                this.$dimension = n;
                this.$targetFile = file;
                super(0);
            }
        }), (Function0<Unit>)((Function0)playSound.3.INSTANCE));
    }

    public final void playSoundFromStream(@NotNull BlockPos pos, int dimension, @NotNull Sound sound) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)sound, (String)"sound");
        BetterRecords.INSTANCE.getLogger().info("Playing sound from stream at " + pos + " in " + dimension);
        Object object = new IcyURLConnection(new URL(StringsKt.startsWith$default((String)sound.getUrl(), (String)"http", (boolean)false, (int)2, null) ? sound.getUrl() : "http://" + sound.getUrl()));
        IcyURLConnection $receiver = object;
        $receiver.setInstanceFollowRedirects(true);
        IcyURLConnection urlConn = object;
        urlConn.connect();
        object = playingSounds;
        Pair pair = new Pair((Object)pos, (Object)dimension);
        Sound sound2 = sound;
        object.put(pair, sound2);
        ClientRenderHandler.INSTANCE.showPlayingWithTimeout(sound.getName());
        InputStream inputStream = urlConn.inputStream;
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"urlConn.inputStream");
        this.playStream(inputStream, pos, dimension);
    }

    public final boolean isSoundPlayingAt(@NotNull BlockPos pos, int dimension) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return playingSounds.containsKey(new Pair((Object)pos, (Object)dimension));
    }

    @Nullable
    public final Sound getSoundPlayingAt(@NotNull BlockPos pos, int dimension) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return playingSounds.get(new Pair((Object)pos, (Object)dimension));
    }

    public final void stopPlayingAt(@NotNull BlockPos pos, int dimension) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        BetterRecords.INSTANCE.getLogger().info("Stopping sound at " + pos + " in Dimension " + dimension);
        playingSounds.remove(new Pair((Object)pos, (Object)dimension));
    }

    private final void playFile(File file, BlockPos pos, int dimension) {
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
        Intrinsics.checkExpressionValueIsNotNull((Object)audioInputStream, (String)"AudioSystem.getAudioInputStream(file)");
        this.play(audioInputStream, pos, dimension);
    }

    private final void playStream(InputStream stream, BlockPos pos, int dimension) {
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(stream);
        Intrinsics.checkExpressionValueIsNotNull((Object)audioInputStream, (String)"AudioSystem.getAudioInputStream(stream)");
        this.play(audioInputStream, pos, dimension);
    }

    private final void play(AudioInputStream ain, BlockPos pos, int dimension) {
        AudioInputStream din;
        AudioFormat baseFormat;
        AudioFormat audioFormat = baseFormat = ain.getFormat();
        Intrinsics.checkExpressionValueIsNotNull((Object)audioFormat, (String)"baseFormat");
        AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
        AudioInputStream audioInputStream = din = AudioSystem.getAudioInputStream(decodedFormat, ain);
        Intrinsics.checkExpressionValueIsNotNull((Object)audioInputStream, (String)"din");
        this.rawPlay(decodedFormat, audioInputStream, pos, dimension);
        ain.close();
    }

    private final void rawPlay(AudioFormat targetFormat, AudioInputStream din, BlockPos pos, int dimension) {
        SourceDataLine line = this.getLine(targetFormat);
        Control control = line.getControl(FloatControl.Type.MASTER_GAIN);
        if (control == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.sound.sampled.FloatControl");
        }
        FloatControl volumeControl = (FloatControl)control;
        line.start();
        byte[] buffer = new byte[4096];
        int bytes = din.read(buffer);
        while (bytes >= 0 && this.isSoundPlayingAt(pos, dimension)) {
            volumeControl.setValue(VolumeCalcUtilKt.getVolumeForPlayerFromBlock(pos));
            line.write(buffer, 0, bytes);
            this.updateLights(buffer, pos, dimension);
            bytes = din.read(buffer);
        }
        this.stopPlayingAt(pos, dimension);
        line.drain();
        line.stop();
        line.close();
        din.close();
    }

    private final SourceDataLine getLine(AudioFormat audioFormat) {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        Line res = AudioSystem.getLine(info);
        res.open();
        Line line = res;
        if (line == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.sound.sampled.SourceDataLine");
        }
        return (SourceDataLine)line;
    }

    private final void updateLights(byte[] buffer, BlockPos pos, int dimension) {
        WorldProvider worldProvider = Minecraft.func_71410_x().field_71441_e.field_73011_w;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"Minecraft.getMinecraft().world.provider");
        if (worldProvider.getDimension() != dimension) {
            return;
        }
        float unscaledTreble = -1.0f;
        float unscaledBass = -1.0f;
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
        TileEntity tileEntity = te;
        if (!(tileEntity instanceof IRecordWireHome)) {
            tileEntity = null;
        }
        IRecordWireHome iRecordWireHome = (IRecordWireHome)tileEntity;
        if (iRecordWireHome != null) {
            IRecordWireHome iRecordWireHome2;
            IRecordWireHome it = iRecordWireHome2 = iRecordWireHome;
            ((IRecordWireHome)te).addTreble(INSTANCE.getUnscaledWaveform(buffer, true, false));
            ((IRecordWireHome)te).addBass(INSTANCE.getUnscaledWaveform(buffer, false, false));
            for (RecordConnection connection : ((IRecordWireHome)te).getConnections()) {
                TileEntity connectedTe = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(connection.getX2(), connection.getY2(), connection.getZ2()));
                TileEntity tileEntity2 = connectedTe;
                if (!(tileEntity2 instanceof IRecordAmplitude)) {
                    tileEntity2 = null;
                }
                if ((IRecordAmplitude)tileEntity2 != null) {
                    IRecordAmplitude iRecordAmplitude;
                    IRecordAmplitude it2 = iRecordAmplitude;
                    if (unscaledTreble == -1.0f || unscaledBass == 11.0f) {
                        unscaledTreble = INSTANCE.getUnscaledWaveform(buffer, true, true);
                        unscaledBass = INSTANCE.getUnscaledWaveform(buffer, false, true);
                    }
                    ((IRecordAmplitude)connectedTe).setTreble(unscaledTreble);
                    ((IRecordAmplitude)connectedTe).setBass(unscaledBass);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final float getUnscaledWaveform(byte[] buffer, boolean high, boolean control) {
        byte[] toReturn = new byte[buffer.length / 2];
        float avg = 0.0f;
        boolean bl = false;
        Iterator iterator = ((Iterable)RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)(high ? 0 : 1), (int)buffer.length)), (int)2)).iterator();
        while (iterator.hasNext()) {
            void index;
            int audioByte = ((IntIterator)iterator).nextInt();
            toReturn[index] = buffer[audioByte];
            avg += (float)toReturn[index];
            ++index;
        }
        avg /= (float)toReturn.length;
        if (control) {
            if (avg < 0.0f) {
                float f = avg;
                avg = Math.abs(f);
            }
            if (avg > 20.0f) {
                return ModConfig.client.flashMode < 3 ? 1.0f : 2.0f;
            }
        }
        return avg;
    }

    private SoundPlayer() {
    }

    static {
        SoundPlayer soundPlayer;
        INSTANCE = soundPlayer = new SoundPlayer();
        downloadFolder = new File(Minecraft.func_71410_x().field_71412_D, "betterrecords/cache");
        playingSounds = new HashMap();
    }

    @NotNull
    public static final /* synthetic */ HashMap access$getPlayingSounds$p(SoundPlayer $this) {
        SoundPlayer soundPlayer = $this;
        return playingSounds;
    }

    public static final /* synthetic */ void access$playFile(SoundPlayer $this, @NotNull File file, @NotNull BlockPos pos, int dimension) {
        $this.playFile(file, pos, dimension);
    }
}

