/*
 * Decompiled with CFR 0.152.
 */
package com.codingforcookies.betterrecords.block;

import com.codingforcookies.betterrecords.api.BetterRecordsAPI;
import com.codingforcookies.betterrecords.api.sound.IRepeatableSoundHolder;
import com.codingforcookies.betterrecords.api.sound.IShufflableSoundHolder;
import com.codingforcookies.betterrecords.api.sound.ISoundHolder;
import com.codingforcookies.betterrecords.api.wire.IRecordWire;
import com.codingforcookies.betterrecords.api.wire.IRecordWireManipulator;
import com.codingforcookies.betterrecords.block.ItemModelProvider;
import com.codingforcookies.betterrecords.block.ModBlock;
import com.codingforcookies.betterrecords.block.TESRProvider;
import com.codingforcookies.betterrecords.block.tile.TileRecordPlayer;
import com.codingforcookies.betterrecords.client.render.RenderRecordPlayer;
import com.codingforcookies.betterrecords.helper.ConnectionHelper;
import com.codingforcookies.betterrecords.item.ItemRecord;
import com.codingforcookies.betterrecords.network.PacketHandler;
import com.codingforcookies.betterrecords.network.PacketRecordPlay;
import com.codingforcookies.betterrecords.network.PacketSoundStop;
import java.util.Collection;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J&\u0010\u0013\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aH\u0016JZ\u0010\u001f\u001a\u00020 2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(H\u0016J&\u0010+\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J:\u0010,\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J0\u00101\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u00102\u001a\u00020 H\u0016\u00a8\u00063"}, d2={"Lcom/codingforcookies/betterrecords/block/BlockRecordPlayer;", "Lcom/codingforcookies/betterrecords/block/ModBlock;", "Lcom/codingforcookies/betterrecords/block/TESRProvider;", "Lcom/codingforcookies/betterrecords/block/tile/TileRecordPlayer;", "Lcom/codingforcookies/betterrecords/block/ItemModelProvider;", "name", "", "(Ljava/lang/String;)V", "breakBlock", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "createBlockState", "Lnet/minecraft/block/state/BlockStateContainer;", "dropItem", "getBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "block", "Lnet/minecraft/world/IBlockAccess;", "getMetaFromState", "", "getRenderClass", "Lkotlin/reflect/KClass;", "Lcom/codingforcookies/betterrecords/client/render/RenderRecordPlayer;", "getStateFromMeta", "meta", "getTileEntityClass", "onBlockActivated", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "side", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "onBlockAdded", "onBlockPlacedBy", "placer", "Lnet/minecraft/entity/EntityLivingBase;", "stack", "Lnet/minecraft/item/ItemStack;", "removedByPlayer", "willHarvest", "BetterRecords"})
public final class BlockRecordPlayer
extends ModBlock
implements TESRProvider<TileRecordPlayer>,
ItemModelProvider {
    @Override
    @NotNull
    public KClass<TileRecordPlayer> getTileEntityClass() {
        return Reflection.getOrCreateKotlinClass(TileRecordPlayer.class);
    }

    @Override
    @NotNull
    public KClass<RenderRecordPlayer> getRenderClass() {
        return Reflection.getOrCreateKotlinClass(RenderRecordPlayer.class);
    }

    @NotNull
    public AxisAlignedBB func_185496_a(@Nullable IBlockState state, @Nullable IBlockAccess block, @Nullable BlockPos pos) {
        return new AxisAlignedBB(0.025, 0.0, 0.025, 0.975, 0.975, 0.975);
    }

    public void func_176213_c(@Nullable World world, @Nullable BlockPos pos, @Nullable IBlockState state) {
        super.func_176213_c(world, pos, state);
        World world2 = world;
        if (world2 == null) {
            Intrinsics.throwNpe();
        }
        BlockPos blockPos = pos;
        if (blockPos == null) {
            Intrinsics.throwNpe();
        }
        IBlockState iBlockState = state;
        if (iBlockState == null) {
            Intrinsics.throwNpe();
        }
        world2.func_184138_a(blockPos, iBlockState, state, 3);
    }

    public boolean func_180639_a(@Nullable World world, @Nullable BlockPos pos, @Nullable IBlockState state, @NotNull EntityPlayer player, @Nullable EnumHand hand, @Nullable EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        ItemStack itemStack = player.func_184614_ca();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"player.heldItemMainhand");
        if (itemStack.func_190926_b()) {
            ItemStack itemStack2 = player.func_184614_ca();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"player.heldItemMainhand");
            if (itemStack2.func_77973_b() instanceof IRecordWireManipulator) {
                return false;
            }
        }
        World world2 = world;
        if (world2 == null) {
            Intrinsics.throwNpe();
        }
        BlockPos blockPos = pos;
        if (blockPos == null) {
            Intrinsics.throwNpe();
        }
        if ((tileEntity = world2.func_175625_s(blockPos)) == null || !(tileEntity instanceof TileRecordPlayer)) {
            return false;
        }
        TileRecordPlayer tileRecordPlayer = (TileRecordPlayer)tileEntity;
        if (player.func_70093_af()) {
            IBlockState iBlockState = world.func_180495_p(pos.func_177982_a(0, 1, 0));
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos.add(0, 1, 0))");
            if (iBlockState.func_177230_c() == Blocks.field_150350_a) {
                if (!world.field_72995_K) {
                    tileRecordPlayer.setOpening(!tileRecordPlayer.getOpening());
                }
                IBlockState iBlockState2 = state;
                if (iBlockState2 == null) {
                    Intrinsics.throwNpe();
                }
                world.func_184138_a(pos, iBlockState2, state, 3);
                if (tileRecordPlayer.getOpening()) {
                    world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("block.chest.open")), SoundCategory.NEUTRAL, 0.2f, world.field_73012_v.nextFloat() * 0.2f + 3.0f, false);
                } else {
                    world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("block.chest.open")), SoundCategory.NEUTRAL, 0.2f, world.field_73012_v.nextFloat() * 0.2f + 3.0f, false);
                }
            }
        } else if (tileRecordPlayer.getOpening()) {
            ItemStack itemStack3 = tileRecordPlayer.getRecord();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"tileRecordPlayer.record");
            if (itemStack3.func_190926_b()) {
                ItemStack itemStack4 = player.func_184614_ca();
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack4, (String)"player.heldItemMainhand");
                if (itemStack4.func_77973_b() instanceof ItemRecord) {
                    ItemStack itemStack5 = player.func_184614_ca();
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack5, (String)"player.heldItemMainhand");
                    Item item = itemStack5.func_77973_b();
                    if (item == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.codingforcookies.betterrecords.api.sound.ISoundHolder");
                    }
                    ISoundHolder iSoundHolder = (ISoundHolder)item;
                    ItemStack itemStack6 = player.func_184614_ca();
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack6, (String)"player.heldItemMainhand");
                    Collection collection = iSoundHolder.getSounds(itemStack6);
                    if (!collection.isEmpty()) {
                        tileRecordPlayer.setRecord(player.func_184614_ca());
                        IBlockState iBlockState = state;
                        if (iBlockState == null) {
                            Intrinsics.throwNpe();
                        }
                        world.func_184138_a(pos, iBlockState, state, 3);
                        ItemStack itemStack7 = player.func_184614_ca();
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack7, (String)"player.heldItemMainhand");
                        int n = itemStack7.func_190916_E();
                        itemStack7.func_190920_e(n + -1);
                        if (!world.field_72995_K) {
                            BlockPos blockPos2 = tileRecordPlayer.func_174877_v();
                            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"tileRecordPlayer.pos");
                            WorldProvider worldProvider = tileRecordPlayer.func_145831_w().field_73011_w;
                            Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"tileRecordPlayer.world.provider");
                            int n2 = worldProvider.getDimension();
                            float f = tileRecordPlayer.getSongRadius();
                            ItemStack itemStack8 = ((TileRecordPlayer)tileEntity).getRecord();
                            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack8, (String)"tileEntity.record");
                            Item item2 = itemStack8.func_77973_b();
                            if (item2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.codingforcookies.betterrecords.api.sound.IRepeatableSoundHolder");
                            }
                            IRepeatableSoundHolder iRepeatableSoundHolder = (IRepeatableSoundHolder)item2;
                            ItemStack itemStack9 = ((TileRecordPlayer)tileEntity).getRecord();
                            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack9, (String)"tileEntity.record");
                            boolean bl = iRepeatableSoundHolder.isRepeatable(itemStack9);
                            ItemStack itemStack10 = ((TileRecordPlayer)tileEntity).getRecord();
                            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack10, (String)"tileEntity.record");
                            Item item3 = itemStack10.func_77973_b();
                            if (item3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.codingforcookies.betterrecords.api.sound.IShufflableSoundHolder");
                            }
                            IShufflableSoundHolder iShufflableSoundHolder = (IShufflableSoundHolder)item3;
                            ItemStack itemStack11 = ((TileRecordPlayer)tileEntity).getRecord();
                            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack11, (String)"tileEntity.record");
                            boolean bl2 = iShufflableSoundHolder.isShufflable(itemStack11);
                            ItemStack itemStack12 = ((TileRecordPlayer)tileEntity).getRecord();
                            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack12, (String)"tileEntity.record");
                            PacketHandler.INSTANCE.sendToAll(new PacketRecordPlay(blockPos2, n2, f, bl, bl2, itemStack12));
                        }
                    }
                }
            } else {
                if (!world.field_72995_K) {
                    this.dropItem(world, pos);
                }
                tileRecordPlayer.setRecord(ItemStack.field_190927_a);
                IBlockState iBlockState = state;
                if (iBlockState == null) {
                    Intrinsics.throwNpe();
                }
                world.func_184138_a(pos, iBlockState, state, 3);
            }
        }
        return true;
    }

    @NotNull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{(IProperty)BetterRecordsAPI.INSTANCE.getCARDINAL_DIRECTIONS()});
    }

    public int func_176201_c(@Nullable IBlockState state) {
        IBlockState iBlockState = state;
        if (iBlockState == null) {
            Intrinsics.throwNpe();
        }
        Comparable comparable = iBlockState.func_177229_b((IProperty)BetterRecordsAPI.INSTANCE.getCARDINAL_DIRECTIONS());
        Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"state!!.getValue(BetterR\u2026sAPI.CARDINAL_DIRECTIONS)");
        return ((EnumFacing)comparable).func_176736_b();
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        IBlockState iBlockState = this.func_176223_P().func_177226_a((IProperty)BetterRecordsAPI.INSTANCE.getCARDINAL_DIRECTIONS(), (Comparable)EnumFacing.func_176731_b((int)meta));
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"defaultState.withPropert\u2026cing.getHorizontal(meta))");
        return iBlockState;
    }

    public void func_180633_a(@Nullable World world, @Nullable BlockPos pos, @Nullable IBlockState state, @Nullable EntityLivingBase placer, @Nullable ItemStack stack) {
        World world2 = world;
        if (world2 == null) {
            Intrinsics.throwNpe();
        }
        BlockPos blockPos = pos;
        if (blockPos == null) {
            Intrinsics.throwNpe();
        }
        IBlockState iBlockState = state;
        if (iBlockState == null) {
            Intrinsics.throwNpe();
        }
        IProperty iProperty = (IProperty)BetterRecordsAPI.INSTANCE.getCARDINAL_DIRECTIONS();
        EntityLivingBase entityLivingBase = placer;
        if (entityLivingBase == null) {
            Intrinsics.throwNpe();
        }
        EnumFacing enumFacing = entityLivingBase.func_174811_aO();
        Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"placer!!.horizontalFacing");
        world2.func_175656_a(blockPos, iBlockState.func_177226_a(iProperty, (Comparable)enumFacing.func_176734_d()));
    }

    public boolean removedByPlayer(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull EntityPlayer player, boolean willHarvest) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        if (world.field_72995_K) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IRecordWire) {
            ConnectionHelper.INSTANCE.clearConnections(world, (IRecordWire)te);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180663_b(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.dropItem(world, pos);
        super.func_180663_b(world, pos, state);
    }

    private final void dropItem(World world, BlockPos pos) {
        ItemStack item;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null || !(tileEntity instanceof TileRecordPlayer)) {
            return;
        }
        ItemStack itemStack = item = ((TileRecordPlayer)tileEntity).getRecord();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"item");
        if (!itemStack.func_190926_b()) {
            Random rand = new Random();
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), new ItemStack(item.func_77973_b(), item.func_190916_E(), item.func_77952_i()));
            if (item.func_77942_o()) {
                ItemStack itemStack2 = entityItem.func_92059_d();
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"entityItem.item");
                NBTTagCompound nBTTagCompound = item.func_77978_p();
                if (nBTTagCompound == null) {
                    Intrinsics.throwNpe();
                }
                itemStack2.func_77982_d(nBTTagCompound.func_74737_b());
            }
            entityItem.field_70159_w = rand.nextGaussian() * (double)0.05f;
            entityItem.field_70181_x = rand.nextGaussian() * (double)0.05f + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)0.05f;
            world.func_72838_d((Entity)entityItem);
            item.func_190920_e(0);
            ((TileRecordPlayer)tileEntity).setRecord(ItemStack.field_190927_a);
            BlockPos blockPos = ((TileRecordPlayer)tileEntity).func_174877_v();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"tileEntity.pos");
            WorldProvider worldProvider = world.field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
            PacketHandler.INSTANCE.sendToAll(new PacketSoundStop(blockPos, worldProvider.getDimension()));
        }
    }

    public BlockRecordPlayer(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Material material = Material.field_151575_d;
        Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"Material.WOOD");
        super(material, name);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
    }

    @Override
    public void bindTESR() {
        TESRProvider.DefaultImpls.bindTESR(this);
    }

    @Override
    public void registerTESRItemStacks(@NotNull ModBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)block), (String)"block");
        TESRProvider.DefaultImpls.registerTESRItemStacks(this, block);
    }

    @Override
    public void registerTileEntity(@NotNull Block block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        TESRProvider.DefaultImpls.registerTileEntity(this, block);
    }

    @Override
    public void registerItemModel(@NotNull ModBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)block), (String)"block");
        ItemModelProvider.DefaultImpls.registerItemModel(this, block);
    }
}

