/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.bedrockreplacer;

import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import the_fireplace.bedrockreplacer.config.BRConfigValues;
import the_fireplace.bedrockreplacer.config.BlockList;
import the_fireplace.bedrockreplacer.proxy.Common;

@Mod(modid="bedrockreplacer", name="Bedrock Replacer", guiFactory="the_fireplace.bedrockreplacer.config.BRGuiFactory", canBeDeactivated=true, updateJSON="http://thefireplace.bitnamiapp.com/jsons/bedrockreplacer.json", acceptedMinecraftVersions="[1.12,)")
public class BedrockReplacer {
    public static final String MODID = "bedrockreplacer";
    public static final String MODNAME = "Bedrock Replacer";
    @SidedProxy(clientSide="the_fireplace.bedrockreplacer.proxy.Client", serverSide="the_fireplace.bedrockreplacer.proxy.Common")
    public static Common proxy;
    public static Configuration file;
    public static Property REPLACEWITH_PROPERTY;
    public static Property RISKYBLOCKS_PROPERTY;
    public static Property DIMENSIONS_PROPERTY;

    public static void syncConfig() {
        BRConfigValues.REPLACEWITH = REPLACEWITH_PROPERTY.getString();
        BRConfigValues.RISKYBLOCKS = RISKYBLOCKS_PROPERTY.getBoolean();
        BRConfigValues.DIMENSIONS = DIMENSIONS_PROPERTY.getIntList();
        if (file.hasChanged()) {
            file.save();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        file = new Configuration(event.getSuggestedConfigurationFile());
        file.load();
        REPLACEWITH_PROPERTY = file.get("general", "replacewith", "minecraft:stone", proxy.translateToLocal("replacewith.tooltip", new Object[0]));
        RISKYBLOCKS_PROPERTY = file.get("general", "riskyblocks", false, proxy.translateToLocal("riskyblocks.tooltip", new Object[0]));
        DIMENSIONS_PROPERTY = file.get("general", "disabledindimensions", BRConfigValues.DIMENSIONS_DEFAULT, proxy.translateToLocal("disabledindimensions.tooltip", new Object[0]));
        if (event.getSide().isClient()) {
            REPLACEWITH_PROPERTY.setConfigEntryClass(BlockList.class);
            RISKYBLOCKS_PROPERTY.setRequiresMcRestart(true);
        }
        BedrockReplacer.syncConfig();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide().isClient()) {
            Object[] reg;
            IForgeRegistry registry = ForgeRegistries.BLOCKS;
            for (Object element : reg = registry.getKeys().toArray()) {
                String name;
                String id = element.toString();
                Block block = Block.func_149684_b((String)id);
                if (block == null || (name = proxy.translateToLocal(block.func_149739_a() + ".name", new Object[0])).contains("tile.") || name.contains(".name")) continue;
                if (BRConfigValues.RISKYBLOCKS) {
                    BlockList.entries.put(id, name);
                    continue;
                }
                if (!block.func_176223_P().func_185914_p() || !block.func_149703_v() || block.func_149716_u()) continue;
                BlockList.entries.put(id, name);
            }
        }
    }
}

