/*
 * Decompiled with CFR 0.152.
 */
package workbench.botanianeedsit.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import workbench.botanianeedsit.common.tile.TileBase;

public abstract class TileSimpleInventory
extends TileBase {
    protected ItemStackHandler itemHandler = this.createItemstackHandler();

    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    public abstract int getInventorySize();

    public ItemStackHandler createItemstackHandler() {
        return new ItemstackHandler(this, true);
    }

    public void onContentChanged() {
        this.func_70296_d();
    }

    public void onBlockBreak() {
    }

    @Override
    public NBTTagCompound writePacketNBT(NBTTagCompound compound) {
        compound = super.writePacketNBT(compound);
        compound.func_179237_a(this.itemHandler.serializeNBT());
        return compound;
    }

    @Override
    public void readPacketNBT(NBTTagCompound compound) {
        super.readPacketNBT(compound);
        this.itemHandler = this.createItemstackHandler();
        this.itemHandler.deserializeNBT(compound);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler) : super.getCapability(capability, facing));
    }

    public static class ItemstackHandler
    extends ItemStackHandler {
        public final boolean _allowWrite;
        public final TileSimpleInventory _tile;

        public ItemstackHandler(TileSimpleInventory tile, boolean allowWrite) {
            super(tile.getInventorySize());
            this._tile = tile;
            this._allowWrite = allowWrite;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this._allowWrite) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this._allowWrite) {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        protected void onContentsChanged(int slot) {
            this._tile.onContentChanged();
        }
    }
}

