/*
 * Decompiled with CFR 0.152.
 */
package workbench.botanianeedsit.common.tile;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import workbench.botanianeedsit.common.tile.TileSimpleInventory;
import workbench.botanianeedsit.lib.Lib;

public class TileManaCharger
extends TileSimpleInventory
implements ITickable {
    public static final int RATE = 1000;
    public ItemStack _stackIn;
    public int _rotation;

    @Override
    public int getInventorySize() {
        return 1;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.func_190926_b()) {
            return;
        }
        Item item = stack.func_77973_b();
        if (item instanceof IManaItem) {
            IManaItem manaItem = (IManaItem)item;
            TileEntity tilePool = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            if (tilePool instanceof IManaPool) {
                IManaPool pool = (IManaPool)tilePool;
                if (pool.isOutputtingPower()) {
                    if (manaItem.canReceiveManaFromPool(stack, tilePool) && manaItem.getMana(stack) != manaItem.getMaxMana(stack) && pool.getCurrentMana() > 0) {
                        int mana = Math.min(manaItem.getMaxMana(stack) - manaItem.getMana(stack), 1000);
                        mana = Math.min(pool.getCurrentMana(), mana);
                        pool.recieveMana(-mana);
                        manaItem.addMana(stack, mana);
                        this.func_70296_d();
                    }
                } else if (manaItem.canExportManaToPool(stack, tilePool)) {
                    int currentManaInStack = manaItem.getMana(stack);
                    if (!pool.isFull() && currentManaInStack > 0) {
                        int mana = Math.min(currentManaInStack, 1000);
                        pool.recieveMana(mana);
                        manaItem.addMana(stack, -mana);
                        this.func_70296_d();
                    }
                }
            }
        }
    }

    @Override
    public ItemStackHandler createItemstackHandler() {
        return new TileSimpleInventory.ItemstackHandler(this, true){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    public void onContentChanged() {
        if (!this.itemHandler.getStackInSlot(0).func_190926_b()) {
            this.initItem();
        }
        this.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }

    public boolean handleClick(EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof IManaItem) {
            ItemStack chargerStack = this.itemHandler.getStackInSlot(0);
            if (chargerStack.func_190926_b()) {
                ItemStack newStack = heldItem.func_77946_l();
                newStack.func_190920_e(1);
                this.itemHandler.setStackInSlot(0, newStack);
                heldItem.func_190918_g(1);
                return true;
            }
            return false;
        }
        if (heldItem.func_190926_b() && !this.itemHandler.getStackInSlot(0).func_190926_b()) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)this.itemHandler.getStackInSlot(0).func_77946_l());
            this.itemHandler.setStackInSlot(0, ItemStack.field_190927_a);
            return true;
        }
        return false;
    }

    public int getComparatorOutput() {
        ItemStack stack = this.itemHandler.getStackInSlot(0).func_77946_l();
        if (stack.func_190926_b()) {
            return 0;
        }
        IManaItem manaItem = (IManaItem)stack.func_77973_b();
        int currentMana = manaItem.getMana(stack);
        int maxMana = manaItem.getMaxMana(stack);
        if (maxMana < 1 || currentMana < 1) {
            return 1;
        }
        return 1 + (int)((float)currentMana / (float)maxMana * 14.0f) + 1;
    }

    @Override
    public void onBlockBreak() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!stack.func_190926_b()) {
            this.itemHandler.setStackInSlot(0, ItemStack.field_190927_a);
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack);
        }
    }

    @Override
    public void readPacketNBT(NBTTagCompound compound) {
        super.readPacketNBT(compound);
        if (!this.itemHandler.getStackInSlot(0).func_190926_b()) {
            this.initItem();
        }
    }

    protected void initItem() {
        this._stackIn = this.itemHandler.getStackInSlot(0).func_77946_l();
        this._rotation = Lib.RANDOM.nextInt(360);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getItemHandler()) : super.getCapability(capability, facing));
    }
}

